/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.test.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.aries.transaction.test.TestBean;

public class TestBeanImpl
implements TestBean {
    private DataSource xads;
    private DataSource ds;
    private String user;
    private String password;
    private TestBean bean;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.ds.getConnection(this.user, this.password);
            conn.setAutoCommit(true);
            stmt = conn.createStatement();
            stmt.executeUpdate("DROP TABLE TESTTABLE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        try {
            conn = this.ds.getConnection(this.user, this.password);
            conn.setAutoCommit(true);
            stmt = conn.createStatement();
            stmt.executeUpdate("CREATE TABLE TESTTABLE (NAME VARCHAR(64), VALUE INTEGER, PRIMARY KEY(NAME, VALUE))");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void insertRow(String name, int value) throws SQLException {
        this.insertRow(name, value, false);
    }

    public void insertRow(String name, int value, Exception e) throws SQLException {
        this.insertRow(name, value, false);
        if (e instanceof SQLException) {
            throw (SQLException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow(String name, int value, boolean delegate) throws SQLException {
        if (delegate) {
            this.bean.insertRow(name, value);
        } else {
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = this.xads.getConnection(this.user, this.password);
                stmt = conn.prepareStatement("INSERT INTO TESTTABLE VALUES (?, ?)");
                stmt.setString(1, name);
                stmt.setInt(2, value);
                stmt.executeUpdate();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countRows() throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        int count = -1;
        try {
            conn = this.ds.getConnection(this.user, this.password);
            stmt = conn.prepareStatement("SELECT * FROM TESTTABLE", 1004, 1007);
            rs = stmt.executeQuery();
            rs.last();
            count = rs.getRow();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        return count;
    }

    public void throwApplicationException() throws SQLException {
        throw new SQLException("Test exception");
    }

    public void throwRuntimeException() {
        throw new RuntimeException("Test exception");
    }

    public void setEnlistingDataSource(DataSource xads) {
        this.xads = xads;
    }

    public void setDataSource(DataSource ds) {
        this.ds = ds;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTestBean(TestBean bean) {
        this.bean = bean;
    }
}

