/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.apache.aries.subsystem.core.archive.DynamicImportPackageHeader;
import org.apache.aries.subsystem.core.archive.DynamicImportPackageRequirement;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleResourceInstaller;
import org.apache.aries.subsystem.core.internal.RegionUpdater;
import org.apache.aries.subsystem.core.internal.StartAction;
import org.apache.aries.subsystem.core.internal.Subsystems;
import org.eclipse.equinox.region.Region;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;

public class WovenClassListener
implements org.osgi.framework.hooks.weaving.WovenClassListener {
    private final BundleContext context;
    private final Subsystems subsystems;

    public WovenClassListener(BundleContext context, Subsystems subsystems) {
        this.context = context;
        this.subsystems = subsystems;
    }

    public void modified(WovenClass wovenClass) {
        if (wovenClass.getState() != 2) {
            return;
        }
        List dynamicImports = wovenClass.getDynamicImports();
        if (dynamicImports.isEmpty()) {
            return;
        }
        Bundle wovenBundle = wovenClass.getBundleWiring().getBundle();
        BundleRevision wovenRevision = (BundleRevision)wovenBundle.adapt(BundleRevision.class);
        BasicSubsystem subsystem = this.subsystems.getSubsystemsByConstituent((Resource)new BundleResourceInstaller.BundleConstituent(null, wovenRevision)).iterator().next();
        if (subsystem.getSubsystemId() == 0L) {
            return;
        }
        if (EnumSet.of(Subsystem.State.INSTALLING, Subsystem.State.INSTALLED).contains((Object)subsystem.getState())) {
            AccessController.doPrivileged(new StartAction(subsystem, subsystem, subsystem, true));
        }
        ArrayList<DynamicImportPackageRequirement> requirements = new ArrayList<DynamicImportPackageRequirement>();
        for (String dynamicImport : dynamicImports) {
            DynamicImportPackageHeader header = new DynamicImportPackageHeader(dynamicImport);
            for (DynamicImportPackageRequirement requirement : header.toRequirements((Resource)wovenRevision)) {
                String pkg = requirement.getPackageName();
                if (pkg.endsWith(".*")) {
                    requirements.add(requirement);
                    continue;
                }
                FrameworkWiring fw = (FrameworkWiring)this.context.getBundle("System Bundle").adapt(FrameworkWiring.class);
                Collection providers = fw.findProviders((Requirement)requirement);
                boolean found = false;
                for (BundleCapability provider : providers) {
                    BundleRevision br = provider.getResource();
                    if (!subsystem.getConstituents().contains(new BundleResourceInstaller.BundleConstituent(null, br))) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                requirements.add(requirement);
            }
        }
        if (requirements.isEmpty()) {
            return;
        }
        Region from = subsystem.getRegion();
        Region to = ((BasicSubsystem)subsystem.getParents().iterator().next()).getRegion();
        RegionUpdater updater = new RegionUpdater(from, to);
        try {
            updater.addRequirements(requirements);
        }
        catch (Exception e) {
            throw new SubsystemException(e);
        }
    }
}

