/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.internal.AbstractRequirement;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleResource;
import org.apache.aries.subsystem.core.internal.RawSubsystemResource;
import org.apache.aries.subsystem.core.internal.SubsystemResource;
import org.apache.aries.subsystem.core.repository.Repository;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHelper {
    private static final Logger logger = LoggerFactory.getLogger(ResourceHelper.class);
    private static final String ATTR = "((?:\\s*[^=><~()]\\s*)+)";
    private static final String VALUE = "(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+";
    private static final String FINAL = "(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?";
    private static final String STAR_VALUE = "(?:(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?(?:\\*(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?)*)";
    private static final String ANY = "(?:\\*(?:(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?(?:\\*(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?)*))";
    private static final String INITIAL = "(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?";
    private static final String SUBSTRING = "(?:((?:\\s*[^=><~()]\\s*)+)=(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?(?:\\*(?:(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?(?:\\*(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?)*))(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?)";
    private static final String PRESENT = "(?:((?:\\s*[^=><~()]\\s*)+)=\\*)";
    private static final String LESS_EQ = "(?:<=)";
    private static final String GREATER_EQ = "(?:>=)";
    private static final String APPROX = "(?:~=)";
    private static final String EQUAL = "(?:=)";
    private static final String FILTER_TYPE = "(?:(?:=)|(?:~=)|(?:>=)|(?:<=))";
    private static final String SIMPLE = "(?:((?:\\s*[^=><~()]\\s*)+)(?:(?:=)|(?:~=)|(?:>=)|(?:<=))(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)";
    private static final String OPERATION = "(?:(?:((?:\\s*[^=><~()]\\s*)+)(?:(?:=)|(?:~=)|(?:>=)|(?:<=))(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)|(?:((?:\\s*[^=><~()]\\s*)+)=\\*)|(?:((?:\\s*[^=><~()]\\s*)+)=(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?(?:\\*(?:(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?(?:\\*(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?)*))(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?))";
    private static final Pattern PATTERN = Pattern.compile("(?:(?:((?:\\s*[^=><~()]\\s*)+)(?:(?:=)|(?:~=)|(?:>=)|(?:<=))(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)|(?:((?:\\s*[^=><~()]\\s*)+)=\\*)|(?:((?:\\s*[^=><~()]\\s*)+)=(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?(?:\\*(?:(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?(?:\\*(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?)*))(?:(?:\\\\\\\\|\\\\\\*|\\\\\\(|\\\\\\)|[^\\*()])+)?))");

    public static boolean areEqual(Resource resource1, Resource resource2) {
        return ResourceHelper.getTypeAttribute(resource1).equals(ResourceHelper.getTypeAttribute(resource2)) && ResourceHelper.getSymbolicNameAttribute(resource1).equals(ResourceHelper.getSymbolicNameAttribute(resource2)) && ResourceHelper.getVersionAttribute(resource1).equals((Object)ResourceHelper.getVersionAttribute(resource2));
    }

    public static String getContentAttribute(Resource resource) {
        return (String)ResourceHelper.getContentAttribute(resource, "osgi.content");
    }

    public static Object getContentAttribute(Resource resource, String name) {
        List capabilities = resource.getCapabilities("osgi.content");
        Capability capability = (Capability)capabilities.get(0);
        return capability.getAttributes().get(name);
    }

    public static Object getIdentityAttribute(Resource resource, String name) {
        List capabilities = resource.getCapabilities("osgi.identity");
        Capability capability = (Capability)capabilities.get(0);
        return capability.getAttributes().get(name);
    }

    public static String getLocation(Resource resource) {
        if (resource instanceof BundleResource) {
            return ((BundleResource)resource).getLocation();
        }
        if (resource instanceof BundleRevision) {
            return ((BundleRevision)resource).getBundle().getLocation();
        }
        if (resource instanceof BasicSubsystem) {
            return ((BasicSubsystem)resource).getLocation();
        }
        if (resource instanceof SubsystemResource) {
            return ((SubsystemResource)resource).getLocation();
        }
        if (resource instanceof RawSubsystemResource) {
            return ((RawSubsystemResource)resource).getLocation().getValue();
        }
        return ResourceHelper.getSymbolicNameAttribute(resource) + '@' + ResourceHelper.getVersionAttribute(resource);
    }

    public static Resource getResource(Requirement requirement, Repository repository) {
        Map<Requirement, Collection<Capability>> map = repository.findProviders(Arrays.asList(requirement));
        Collection<Capability> capabilities = map.get(requirement);
        return capabilities == null ? null : (capabilities.size() == 0 ? null : capabilities.iterator().next().getResource());
    }

    public static String getSymbolicNameAttribute(Resource resource) {
        return (String)ResourceHelper.getIdentityAttribute(resource, "osgi.identity");
    }

    public static String getTypeAttribute(Resource resource) {
        String result = (String)ResourceHelper.getIdentityAttribute(resource, "type");
        if (result == null) {
            result = "osgi.bundle";
        }
        return result;
    }

    public static Version getVersionAttribute(Resource resource) {
        Version result = (Version)ResourceHelper.getIdentityAttribute(resource, "version");
        if (result == null) {
            result = Version.emptyVersion;
        }
        return result;
    }

    public static boolean matches(Requirement requirement, Capability capability) {
        if (requirement == null && capability == null) {
            return true;
        }
        if (requirement == null || capability == null) {
            return false;
        }
        if (!capability.getNamespace().equals(requirement.getNamespace())) {
            return false;
        }
        Filter filter = null;
        try {
            if (requirement instanceof AbstractRequirement) {
                filter = ((AbstractRequirement)requirement).getFilter();
            } else {
                String filterStr = (String)requirement.getDirectives().get("filter");
                if (filterStr != null) {
                    filter = FrameworkUtil.createFilter((String)filterStr);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            logger.debug("Requirement had invalid filter string: " + requirement, (Throwable)e);
            return false;
        }
        if (filter != null && !filter.matches(capability.getAttributes())) {
            return false;
        }
        return ResourceHelper.matchMandatoryDirective(requirement, capability);
    }

    private static boolean matchMandatoryDirective(Requirement requirement, Capability capability) {
        if (!requirement.getNamespace().startsWith("osgi.wiring.")) {
            return true;
        }
        String mandatoryDirective = (String)capability.getDirectives().get("mandatory");
        if (mandatoryDirective == null) {
            return true;
        }
        String filterDirective = (String)requirement.getDirectives().get("filter");
        if (filterDirective == null) {
            return false;
        }
        HashSet<String> attributeNames = new HashSet<String>();
        Matcher matcher = PATTERN.matcher(filterDirective);
        while (matcher.find()) {
            attributeNames.add(matcher.group(1));
        }
        for (String s : mandatoryDirective.split(",")) {
            if (attributeNames.contains(s.trim())) continue;
            return false;
        }
        return true;
    }
}

