/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.DeploymentManifest;
import org.apache.aries.subsystem.core.archive.Header;
import org.apache.aries.subsystem.core.archive.ImportPackageHeader;
import org.apache.aries.subsystem.core.archive.RequireBundleHeader;
import org.apache.aries.subsystem.core.archive.RequireCapabilityHeader;
import org.apache.aries.subsystem.core.archive.SubsystemContentHeader;
import org.apache.aries.subsystem.core.archive.SubsystemImportServiceHeader;
import org.apache.aries.subsystem.core.archive.SubsystemLocalizationHeader;
import org.apache.aries.subsystem.core.archive.SubsystemManifest;
import org.apache.aries.subsystem.core.archive.SubsystemSymbolicNameHeader;
import org.apache.aries.subsystem.core.archive.SubsystemVersionHeader;
import org.apache.aries.subsystem.core.capabilityset.SimpleFilter;
import org.apache.aries.subsystem.core.internal.AbstractCapability;
import org.apache.aries.subsystem.core.internal.BasicCapability;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleResource;
import org.apache.aries.subsystem.core.internal.CompositeRepository;
import org.apache.aries.subsystem.core.internal.CustomResources;
import org.apache.aries.subsystem.core.internal.DependencyCalculator;
import org.apache.aries.subsystem.core.internal.FileResource;
import org.apache.aries.subsystem.core.internal.LocalRepository;
import org.apache.aries.subsystem.core.internal.Location;
import org.apache.aries.subsystem.core.internal.OsgiIdentityCapability;
import org.apache.aries.subsystem.core.internal.RepositoryServiceRepository;
import org.apache.aries.subsystem.core.internal.SubsystemIdentifier;
import org.apache.aries.subsystem.core.internal.SubsystemUri;
import org.apache.aries.subsystem.core.internal.TranslationFile;
import org.apache.aries.subsystem.core.repository.Repository;
import org.apache.aries.util.filesystem.FileSystem;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.io.IOUtils;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.apache.aries.util.manifest.ManifestProcessor;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.subsystem.Subsystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawSubsystemResource
implements Resource {
    private static final Logger logger = LoggerFactory.getLogger(RawSubsystemResource.class);
    private static final Pattern PATTERN = Pattern.compile("([^@/\\\\]+)(?:@(.+))?.esa");
    private static final String APPLICATION_IMPORT_SERVICE_HEADER = "Application-ImportService";
    private final List<Capability> capabilities;
    private final DeploymentManifest deploymentManifest;
    private final long id;
    private final Repository localRepository;
    private final Location location;
    private final BasicSubsystem parentSubsystem;
    private final List<Requirement> requirements;
    private final Collection<Resource> resources;
    private final Resource fakeImportServiceResource;
    private final SubsystemManifest subsystemManifest;
    private final Collection<TranslationFile> translations;

    private static SubsystemManifest computeExistingSubsystemManifest(IDirectory directory) throws IOException {
        Manifest manifest = ManifestProcessor.obtainManifestFromAppDir((IDirectory)directory, (String)"OSGI-INF/SUBSYSTEM.MF");
        if (manifest == null) {
            return null;
        }
        return new SubsystemManifest(manifest);
    }

    private static SubsystemManifest computeNewSubsystemManifest() {
        return new SubsystemManifest.Builder().build();
    }

    private static SubsystemManifest computeSubsystemManifest(IDirectory directory) throws IOException {
        SubsystemManifest result = RawSubsystemResource.computeExistingSubsystemManifest(directory);
        if (result == null) {
            result = RawSubsystemResource.computeNewSubsystemManifest();
        }
        return result;
    }

    private static String convertFileToLocation(IFile file) throws MalformedURLException {
        String result = RawSubsystemResource.convertFileNameToLocation(file.getName());
        if (result == null) {
            result = file.toURL().toString();
        }
        return result;
    }

    private static String convertFileNameToLocation(String fileName) {
        Matcher matcher = PATTERN.matcher(fileName);
        if (!matcher.matches()) {
            return null;
        }
        String version = matcher.group(2);
        return new SubsystemUri(matcher.group(1), version == null ? null : Version.parseVersion((String)version), null).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawSubsystemResource(String location, IDirectory content, BasicSubsystem parent) throws URISyntaxException, IOException, ResolutionException {
        this.id = SubsystemIdentifier.getNextId();
        this.location = new Location(location);
        this.parentSubsystem = parent;
        if (content == null) {
            content = this.location.open();
        }
        try {
            SubsystemManifest manifest = RawSubsystemResource.computeSubsystemManifest(content);
            this.resources = this.computeResources(content, manifest);
            this.fakeImportServiceResource = RawSubsystemResource.createFakeResource(manifest);
            this.localRepository = this.computeLocalRepository();
            manifest = this.computeSubsystemManifestBeforeRequirements(manifest);
            this.requirements = this.computeRequirements(manifest);
            this.subsystemManifest = this.computeSubsystemManifestAfterRequirements(manifest);
            this.capabilities = this.computeCapabilities();
            this.deploymentManifest = this.computeDeploymentManifest(content);
            this.translations = this.computeTranslations(content);
        }
        finally {
            IOUtils.close((Closeable)content.toCloseable());
        }
    }

    public RawSubsystemResource(File file, BasicSubsystem parent) throws IOException, URISyntaxException, ResolutionException {
        this(FileSystem.getFSRoot((File)file), parent);
    }

    public RawSubsystemResource(IDirectory idir, BasicSubsystem parent) throws IOException, URISyntaxException, ResolutionException {
        this.resources = Collections.emptyList();
        this.fakeImportServiceResource = null;
        this.localRepository = this.computeLocalRepository();
        this.subsystemManifest = this.initializeSubsystemManifest(idir);
        this.requirements = this.subsystemManifest.toRequirements(this);
        this.capabilities = this.subsystemManifest.toCapabilities(this);
        this.deploymentManifest = this.initializeDeploymentManifest(idir);
        this.id = Long.parseLong(this.deploymentManifest.getHeaders().get("AriesSubsystem-Id").getValue());
        this.location = new Location(this.deploymentManifest.getHeaders().get("AriesSubsystem-Location").getValue());
        this.parentSubsystem = parent;
        this.translations = Collections.emptyList();
    }

    private static Resource createFakeResource(SubsystemManifest manifest) {
        Header<?> importServiceHeader = manifest.getHeaders().get(APPLICATION_IMPORT_SERVICE_HEADER);
        if (importServiceHeader == null) {
            return null;
        }
        ArrayList<AbstractCapability> modifiableCaps = new ArrayList<AbstractCapability>();
        final List fakeCapabilities = Collections.unmodifiableList(modifiableCaps);
        Resource fakeResource = new Resource(){

            public List<Capability> getCapabilities(String namespace) {
                if (namespace == null) {
                    return fakeCapabilities;
                }
                ArrayList<Capability> results = new ArrayList<Capability>();
                for (Capability capability : fakeCapabilities) {
                    if (!namespace.equals(capability.getNamespace())) continue;
                    results.add(capability);
                }
                return results;
            }

            public List<Requirement> getRequirements(String namespace) {
                return Collections.emptyList();
            }
        };
        modifiableCaps.add(new OsgiIdentityCapability(fakeResource, "org.apache.aries.subsystem.resource.synthesized", new Version(1, 0, 0), "org.apache.aries.subsystem.resource.synthesized"));
        Map serviceImports = ManifestHeaderProcessor.parseImportString((String)importServiceHeader.getValue());
        for (Map.Entry serviceImport : serviceImports.entrySet()) {
            ArrayList<String> objectClasses = new ArrayList<String>(Arrays.asList((String)serviceImport.getKey()));
            String filter = (String)((Map)serviceImport.getValue()).get("filter");
            BasicCapability.Builder capBuilder = new BasicCapability.Builder();
            capBuilder.namespace("osgi.service");
            capBuilder.attribute("objectClass", objectClasses);
            if (filter != null) {
                capBuilder.attributes(new HashMap<String, Object>(SimpleFilter.attributes(filter)));
            }
            capBuilder.attribute("service.imported", "");
            capBuilder.resource(fakeResource);
            modifiableCaps.add(capBuilder.build());
        }
        return fakeResource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawSubsystemResource)) {
            return false;
        }
        RawSubsystemResource that = (RawSubsystemResource)o;
        return this.getLocation().equals(that.getLocation());
    }

    public List<Capability> getCapabilities(String namespace) {
        if (namespace == null) {
            return Collections.unmodifiableList(this.capabilities);
        }
        ArrayList<Capability> result = new ArrayList<Capability>(this.capabilities.size());
        for (Capability capability : this.capabilities) {
            if (!namespace.equals(capability.getNamespace())) continue;
            result.add(capability);
        }
        result.trimToSize();
        return Collections.unmodifiableList(result);
    }

    public DeploymentManifest getDeploymentManifest() {
        return this.deploymentManifest;
    }

    public long getId() {
        return this.id;
    }

    public Repository getLocalRepository() {
        return this.localRepository;
    }

    public Location getLocation() {
        return this.location;
    }

    public List<Requirement> getRequirements(String namespace) {
        if (namespace == null) {
            return Collections.unmodifiableList(this.requirements);
        }
        ArrayList<Requirement> result = new ArrayList<Requirement>(this.requirements.size());
        for (Requirement requirement : this.requirements) {
            if (!namespace.equals(requirement.getNamespace())) continue;
            result.add(requirement);
        }
        result.trimToSize();
        return Collections.unmodifiableList(result);
    }

    public SubsystemManifest getSubsystemManifest() {
        return this.subsystemManifest;
    }

    public Collection<TranslationFile> getTranslations() {
        return this.translations;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getLocation().hashCode();
        return result;
    }

    private void addHeader(SubsystemManifest.Builder builder, Header<?> header) {
        if (header == null) {
            return;
        }
        builder.header(header);
    }

    private void addImportPackageHeader(SubsystemManifest.Builder builder) {
        this.addHeader(builder, this.computeImportPackageHeader());
    }

    private void addRequireBundleHeader(SubsystemManifest.Builder builder) {
        this.addHeader(builder, this.computeRequireBundleHeader());
    }

    private void addRequireCapabilityHeader(SubsystemManifest.Builder builder) {
        this.addHeader(builder, this.computeRequireCapabilityHeader());
    }

    private void addSubsystemContentHeader(SubsystemManifest.Builder builder, SubsystemManifest manifest) {
        this.addHeader(builder, this.computeSubsystemContentHeader(manifest));
    }

    private void addSubsystemImportServiceHeader(SubsystemManifest.Builder builder) {
        this.addHeader(builder, this.computeSubsystemImportServiceHeader());
    }

    private void addSubsystemSymbolicNameHeader(SubsystemManifest.Builder builder, SubsystemManifest manifest) {
        this.addHeader(builder, this.computeSubsystemSymbolicNameHeader(manifest));
    }

    private void addSubsystemVersionHeader(SubsystemManifest.Builder builder, SubsystemManifest manifest) {
        this.addHeader(builder, this.computeSubsystemVersionHeader(manifest));
    }

    private List<Capability> computeCapabilities() {
        return this.subsystemManifest.toCapabilities(this);
    }

    private DeploymentManifest computeDeploymentManifest(IDirectory directory) throws IOException {
        return this.computeExistingDeploymentManifest(directory);
    }

    private DeploymentManifest computeExistingDeploymentManifest(IDirectory directory) throws IOException {
        Manifest manifest = ManifestProcessor.obtainManifestFromAppDir((IDirectory)directory, (String)"OSGI-INF/DEPLOYMENT.MF");
        if (manifest == null) {
            return null;
        }
        return new DeploymentManifest(manifest);
    }

    private ImportPackageHeader computeImportPackageHeader() {
        if (this.requirements.isEmpty()) {
            return null;
        }
        ArrayList<ImportPackageHeader.Clause> clauses = new ArrayList<ImportPackageHeader.Clause>(this.requirements.size());
        for (Requirement requirement : this.requirements) {
            if (!"osgi.wiring.package".equals(requirement.getNamespace())) continue;
            clauses.add(ImportPackageHeader.Clause.valueOf(requirement));
        }
        if (clauses.isEmpty()) {
            return null;
        }
        clauses.trimToSize();
        return new ImportPackageHeader((Collection<ImportPackageHeader.Clause>)clauses);
    }

    private Repository computeLocalRepository() {
        if (this.fakeImportServiceResource != null) {
            ArrayList<Resource> temp = new ArrayList<Resource>(this.resources);
            temp.add(this.fakeImportServiceResource);
            return new LocalRepository(temp);
        }
        return new LocalRepository(this.resources);
    }

    private RequireBundleHeader computeRequireBundleHeader() {
        if (this.requirements.isEmpty()) {
            return null;
        }
        ArrayList<RequireBundleHeader.Clause> clauses = new ArrayList<RequireBundleHeader.Clause>(this.requirements.size());
        for (Requirement requirement : this.requirements) {
            if (!"osgi.wiring.bundle".equals(requirement.getNamespace())) continue;
            clauses.add(RequireBundleHeader.Clause.valueOf(requirement));
        }
        if (clauses.isEmpty()) {
            return null;
        }
        clauses.trimToSize();
        return new RequireBundleHeader((Collection<RequireBundleHeader.Clause>)clauses);
    }

    private RequireCapabilityHeader computeRequireCapabilityHeader() {
        if (this.requirements.isEmpty()) {
            return null;
        }
        ArrayList<RequireCapabilityHeader.Clause> clauses = new ArrayList<RequireCapabilityHeader.Clause>();
        for (Requirement requirement : this.requirements) {
            String namespace = requirement.getNamespace();
            if (namespace.startsWith("osgi.") && !namespace.equals("osgi.ee") && !namespace.equals("osgi.service")) continue;
            clauses.add(RequireCapabilityHeader.Clause.valueOf(requirement));
        }
        if (clauses.isEmpty()) {
            return null;
        }
        clauses.trimToSize();
        return new RequireCapabilityHeader((Collection<RequireCapabilityHeader.Clause>)clauses);
    }

    private List<Requirement> computeRequirements(SubsystemManifest manifest) throws ResolutionException {
        if (this.isComposite(manifest)) {
            return manifest.toRequirements(this);
        }
        SubsystemContentHeader header = manifest.getSubsystemContentHeader();
        if (header == null) {
            return Collections.emptyList();
        }
        List<Requirement> requirements = header.toRequirements(this);
        ArrayList<Resource> resources = new ArrayList<Resource>(requirements.size());
        RepositoryServiceRepository serviceRepo = new RepositoryServiceRepository();
        CompositeRepository compositeRepo = new CompositeRepository(this.localRepository, serviceRepo);
        for (Requirement requirement : requirements) {
            Collection<Capability> capabilities = compositeRepo.findProviders(requirement);
            if (capabilities.isEmpty()) continue;
            resources.add(capabilities.iterator().next().getResource());
        }
        return new DependencyCalculator(resources).calculateDependencies();
    }

    private Collection<Resource> computeResources(IDirectory directory, SubsystemManifest manifest) throws IOException, URISyntaxException, ResolutionException {
        List files = directory.listFiles();
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Resource> result = new ArrayList<Resource>(files.size());
        for (IFile file : directory.listFiles()) {
            if (file.isFile()) {
                this.addResource(file, file.convertNested(), manifest, result);
                continue;
            }
            this.addResource(file, file.convert(), manifest, result);
        }
        result.trimToSize();
        return result;
    }

    private void addResource(IFile file, IDirectory content, SubsystemManifest manifest, ArrayList<Resource> result) throws URISyntaxException, IOException, ResolutionException, MalformedURLException {
        block7: {
            String name = file.getName();
            if (name.endsWith(".esa")) {
                result.add(new RawSubsystemResource(RawSubsystemResource.convertFileToLocation(file), content, this.parentSubsystem));
            } else if (name.endsWith(".jar")) {
                result.add(new BundleResource(file));
            } else {
                Capability idcap;
                Object type;
                FileResource fr = new FileResource(file);
                fr.setCapabilities(this.computeFileCapabilities(fr, file, manifest));
                List<Capability> idcaps = fr.getCapabilities("osgi.identity");
                if (idcaps.size() > 0 && (type = (idcap = idcaps.get(0)).getAttributes().get("type")) instanceof String && this.parentSubsystem != null && CustomResources.getCustomContentHandler(this.parentSubsystem, (String)type) != null) {
                    result.add(fr);
                    return;
                }
                try {
                    result.add(new BundleResource(file));
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block7;
                    logger.debug("File \"" + file.getName() + "\" in subsystem with location \"" + this.location + "\" will be ignored because it is not recognized as a supported resource", (Throwable)e);
                }
            }
        }
    }

    private List<Capability> computeFileCapabilities(FileResource resource, IFile file, SubsystemManifest manifest) {
        SubsystemContentHeader ssch = manifest.getSubsystemContentHeader();
        if (ssch == null) {
            return Collections.emptyList();
        }
        for (SubsystemContentHeader.Clause c : ssch.getClauses()) {
            Attribute er = c.getAttribute("embedded-resource");
            if (er == null || !file.getName().equals(er.getValue())) continue;
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("embedded-resource", er.getValue());
            return Collections.singletonList(new OsgiIdentityCapability(resource, c.getSymbolicName(), c.getVersionRange().getLeft(), c.getType(), attrs));
        }
        return Collections.emptyList();
    }

    private SubsystemContentHeader computeSubsystemContentHeader(SubsystemManifest manifest) {
        SubsystemContentHeader header = manifest.getSubsystemContentHeader();
        if (header == null && !this.resources.isEmpty()) {
            header = SubsystemContentHeader.newInstance(this.resources);
        }
        return header;
    }

    private SubsystemImportServiceHeader computeSubsystemImportServiceHeader() {
        if (this.requirements.isEmpty()) {
            return null;
        }
        ArrayList<SubsystemImportServiceHeader.Clause> clauses = new ArrayList<SubsystemImportServiceHeader.Clause>(this.requirements.size());
        for (Requirement requirement : this.requirements) {
            if (!"osgi.service".equals(requirement.getNamespace())) continue;
            clauses.add(SubsystemImportServiceHeader.Clause.valueOf(requirement));
        }
        if (clauses.isEmpty()) {
            return null;
        }
        clauses.trimToSize();
        return new SubsystemImportServiceHeader((Collection<SubsystemImportServiceHeader.Clause>)clauses);
    }

    private SubsystemManifest computeSubsystemManifestAfterRequirements(SubsystemManifest manifest) {
        if (this.isComposite(manifest)) {
            return manifest;
        }
        SubsystemManifest.Builder builder = new SubsystemManifest.Builder().manifest(manifest);
        this.addImportPackageHeader(builder);
        this.addRequireBundleHeader(builder);
        this.addRequireCapabilityHeader(builder);
        this.addSubsystemImportServiceHeader(builder);
        return builder.build();
    }

    private SubsystemManifest computeSubsystemManifestBeforeRequirements(SubsystemManifest manifest) {
        SubsystemManifest.Builder builder = new SubsystemManifest.Builder().manifest(manifest);
        this.addSubsystemSymbolicNameHeader(builder, manifest);
        this.addSubsystemVersionHeader(builder, manifest);
        this.addSubsystemContentHeader(builder, manifest);
        return builder.build();
    }

    private SubsystemSymbolicNameHeader computeSubsystemSymbolicNameHeader(SubsystemManifest manifest) {
        SubsystemSymbolicNameHeader header = manifest.getSubsystemSymbolicNameHeader();
        if (header != null) {
            return header;
        }
        String symbolicName = this.location.getSymbolicName();
        if (symbolicName == null) {
            symbolicName = "org.apache.aries.subsystem." + this.id;
        }
        return new SubsystemSymbolicNameHeader(symbolicName);
    }

    private SubsystemVersionHeader computeSubsystemVersionHeader(SubsystemManifest manifest) {
        SubsystemVersionHeader header = manifest.getSubsystemVersionHeader();
        if (header.getVersion().equals((Object)Version.emptyVersion) && this.location.getVersion() != null) {
            header = new SubsystemVersionHeader(this.location.getVersion());
        }
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<TranslationFile> computeTranslations(IDirectory directory) throws IOException {
        IDirectory file;
        SubsystemManifest manifest = this.getSubsystemManifest();
        SubsystemLocalizationHeader header = manifest.getSubsystemLocalizationHeader();
        String directoryName = header.getDirectoryName();
        Object object = file = directoryName == null ? directory : directory.getFile(directoryName);
        if (file == null || !file.isDirectory()) {
            return Collections.emptyList();
        }
        List files = file.convert().listFiles();
        if (files == null || files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TranslationFile> result = new ArrayList<TranslationFile>(files.size());
        for (IFile f : files) {
            Properties properties = new Properties();
            InputStream is = f.open();
            try {
                properties.load(is);
                result.add(new TranslationFile(f.getName(), properties));
            }
            finally {
                is.close();
            }
        }
        result.trimToSize();
        return result;
    }

    private DeploymentManifest initializeDeploymentManifest(IDirectory idir) throws IOException {
        Manifest manifest = ManifestProcessor.obtainManifestFromAppDir((IDirectory)idir, (String)"OSGI-INF/DEPLOYMENT.MF");
        if (manifest != null) {
            return new DeploymentManifest(manifest);
        }
        return new DeploymentManifest.Builder().manifest(this.getSubsystemManifest()).location(BasicSubsystem.ROOT_LOCATION).autostart(true).id(0L).lastId(SubsystemIdentifier.getLastId()).state(Subsystem.State.INSTALLING).build();
    }

    private SubsystemManifest initializeSubsystemManifest(IDirectory idir) throws IOException {
        Manifest manifest = ManifestProcessor.obtainManifestFromAppDir((IDirectory)idir, (String)"OSGI-INF/SUBSYSTEM.MF");
        if (manifest != null) {
            return new SubsystemManifest(manifest);
        }
        return new SubsystemManifest.Builder().symbolicName("org.osgi.service.subsystem.root").version(BasicSubsystem.ROOT_VERSION).type("osgi.subsystem.application;provision-policy:=acceptDependencies").build();
    }

    private boolean isComposite(SubsystemManifest manifest) {
        return "osgi.subsystem.composite".equals(manifest.getSubsystemTypeHeader().getType());
    }
}

