/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.security.PrivilegedAction;
import java.util.EnumSet;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.RegionContextBundleHelper;
import org.apache.aries.subsystem.core.internal.Utils;
import org.eclipse.equinox.region.Region;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.subsystem.Subsystem;

public class GetBundleContextAction
implements PrivilegedAction<BundleContext> {
    private final BasicSubsystem subsystem;

    public GetBundleContextAction(BasicSubsystem subsystem) {
        this.subsystem = subsystem;
    }

    @Override
    public BundleContext run() {
        if (EnumSet.of(Subsystem.State.INSTALL_FAILED, Subsystem.State.UNINSTALLED).contains((Object)this.subsystem.getState())) {
            return null;
        }
        BasicSubsystem subsystem = Utils.findScopedSubsystemInRegion(this.subsystem);
        Region region = subsystem.getRegion();
        String bundleName = "org.osgi.service.subsystem.region.context." + subsystem.getSubsystemId();
        Bundle bundle = region.getBundle(bundleName, RegionContextBundleHelper.VERSION);
        return bundle.getBundleContext();
    }
}

