/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.aries.util.filesystem.IFile;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.RepositoryContent;

public class FileResource
implements Resource,
RepositoryContent {
    private final IFile file;
    private volatile Map<String, List<Capability>> capabilities;

    public FileResource(IFile file) {
        this.file = file;
    }

    public List<Capability> getCapabilities(String namespace) {
        Map<String, List<Capability>> namespace2capabilities = this.capabilities;
        if (namespace2capabilities == null) {
            return Collections.emptyList();
        }
        if (namespace == null) {
            ArrayList<Capability> caps = new ArrayList<Capability>();
            for (List<Capability> l : this.capabilities.values()) {
                caps.addAll(l);
            }
            return Collections.unmodifiableList(caps);
        }
        List<Capability> caps = namespace2capabilities.get(namespace);
        if (caps != null) {
            return Collections.unmodifiableList(caps);
        }
        return Collections.emptyList();
    }

    public List<Requirement> getRequirements(String namespace) {
        return Collections.emptyList();
    }

    public void setCapabilities(List<Capability> capabilities) {
        HashMap<String, List<Capability>> m = new HashMap<String, List<Capability>>();
        for (Capability c : capabilities) {
            ArrayList<Capability> l = (ArrayList<Capability>)m.get(c.getNamespace());
            if (l == null) {
                l = new ArrayList<Capability>();
                m.put(c.getNamespace(), l);
            }
            l.add(c);
        }
        this.capabilities = m;
    }

    @Override
    public InputStream getContent() {
        try {
            return this.file.open();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

