/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.InputStream;
import org.apache.aries.subsystem.ContentHandler;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.apache.aries.subsystem.core.internal.ResourceInstaller;
import org.osgi.framework.ServiceReference;
import org.osgi.resource.Resource;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.repository.RepositoryContent;

public class CustomResourceInstaller
extends ResourceInstaller {
    private final ServiceReference<ContentHandler> handlerRef;
    private final String type;

    public CustomResourceInstaller(Coordination coordination, Resource resource, String type, BasicSubsystem subsystem, ServiceReference<ContentHandler> handlerRef) {
        super(coordination, resource, subsystem);
        this.handlerRef = handlerRef;
        this.type = type;
    }

    @Override
    public Resource install() throws Exception {
        try {
            ContentHandler handler = (ContentHandler)this.subsystem.getBundleContext().getService(this.handlerRef);
            if (handler != null) {
                InputStream is = ((RepositoryContent)this.resource).getContent();
                handler.install(is, ResourceHelper.getSymbolicNameAttribute(this.resource), this.type, this.subsystem, this.coordination);
                this.addReference(this.resource);
                Resource resource = this.resource;
                return resource;
            }
            throw new Exception("Custom content handler not found: " + this.handlerRef);
        }
        finally {
            this.subsystem.getBundleContext().ungetService(this.handlerRef);
        }
    }
}

