/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.aries.subsystem.AriesSubsystem;
import org.apache.aries.subsystem.core.archive.AriesSubsystemParentsHeader;
import org.apache.aries.subsystem.core.archive.DeployedContentHeader;
import org.apache.aries.subsystem.core.archive.DeploymentManifest;
import org.apache.aries.subsystem.core.archive.Header;
import org.apache.aries.subsystem.core.archive.SubsystemContentHeader;
import org.apache.aries.subsystem.core.archive.SubsystemManifest;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicCapability;
import org.apache.aries.subsystem.core.internal.BasicRequirement;
import org.apache.aries.subsystem.core.internal.GetBundleContextAction;
import org.apache.aries.subsystem.core.internal.GetDeploymentHeadersAction;
import org.apache.aries.subsystem.core.internal.GetSubsystemHeadersAction;
import org.apache.aries.subsystem.core.internal.InstallAction;
import org.apache.aries.subsystem.core.internal.RegionUpdater;
import org.apache.aries.subsystem.core.internal.SecurityManager;
import org.apache.aries.subsystem.core.internal.StartAction;
import org.apache.aries.subsystem.core.internal.StopAction;
import org.apache.aries.subsystem.core.internal.SubsystemIdentifier;
import org.apache.aries.subsystem.core.internal.SubsystemManifestValidator;
import org.apache.aries.subsystem.core.internal.SubsystemResource;
import org.apache.aries.subsystem.core.internal.TranslationFile;
import org.apache.aries.subsystem.core.internal.UninstallAction;
import org.apache.aries.util.filesystem.FileSystem;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.io.IOUtils;
import org.eclipse.equinox.region.Region;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Participant;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicSubsystem
implements Resource,
AriesSubsystem {
    private static final Logger logger = LoggerFactory.getLogger(BasicSubsystem.class);
    public static final String ROOT_SYMBOLIC_NAME = "org.osgi.service.subsystem.root";
    public static final Version ROOT_VERSION = Version.parseVersion((String)"1.0.0");
    public static final String ROOT_LOCATION = "subsystem://?Subsystem-SymbolicName=org.osgi.service.subsystem.root&Subsystem-Version=" + ROOT_VERSION;
    private volatile Bundle regionContextBundle;
    private DeploymentManifest deploymentManifest;
    private SubsystemResource resource;
    private SubsystemManifest subsystemManifest;
    private final IDirectory directory;

    public BasicSubsystem(SubsystemResource resource) throws URISyntaxException, IOException, BundleException, InvalidSyntaxException {
        this(resource, null);
    }

    public BasicSubsystem(SubsystemResource resource, InputStream deploymentManifest) throws URISyntaxException, IOException, BundleException, InvalidSyntaxException {
        this.resource = resource;
        final File file = new File(Activator.getInstance().getBundleContext().getDataFile(""), Long.toString(resource.getId()));
        file.mkdirs();
        Coordination coordination = Activator.getInstance().getCoordinator().peek();
        if (coordination != null) {
            coordination.addParticipant(new Participant(){

                public void ended(Coordination c) throws Exception {
                }

                public void failed(Coordination c) throws Exception {
                    IOUtils.deleteRecursive((File)file);
                }
            });
        }
        this.directory = FileSystem.getFSRoot((File)file);
        this.setSubsystemManifest(resource.getSubsystemManifest());
        SubsystemManifestValidator.validate(this, this.getSubsystemManifest());
        this.setDeploymentManifest(new DeploymentManifest.Builder().manifest(resource.getSubsystemManifest()).manifest(deploymentManifest == null ? resource.getDeploymentManifest() : new DeploymentManifest(deploymentManifest)).location(resource.getLocation()).autostart(false).id(resource.getId()).lastId(SubsystemIdentifier.getLastId()).region(resource.getRegion().getName()).state(Subsystem.State.INSTALLING).build());
        this.setTranslations();
    }

    public BasicSubsystem(File file) throws IOException, URISyntaxException, ResolutionException {
        this(FileSystem.getFSRoot((File)file));
    }

    public BasicSubsystem(IDirectory directory) throws IOException, URISyntaxException, ResolutionException {
        this.directory = directory;
        Subsystem.State state = Subsystem.State.valueOf(this.getDeploymentManifestHeaderValue("AriesSubsystem-State"));
        if (EnumSet.of(Subsystem.State.STARTING, Subsystem.State.ACTIVE, Subsystem.State.STOPPING).contains((Object)state)) {
            state = Subsystem.State.RESOLVED;
        } else if (Subsystem.State.RESOLVING.equals((Object)state)) {
            state = Subsystem.State.INSTALLED;
        }
        this.setDeploymentManifest(new DeploymentManifest.Builder().manifest(this.getDeploymentManifest()).state(state).build());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicSubsystem)) {
            return false;
        }
        BasicSubsystem that = (BasicSubsystem)o;
        return this.getLocation().equals(that.getLocation());
    }

    public List<Capability> getCapabilities(String namespace) {
        SubsystemManifest manifest = this.getSubsystemManifest();
        List<Capability> result = manifest.toCapabilities(this);
        if (namespace != null) {
            Iterator<Capability> i = result.iterator();
            while (i.hasNext()) {
                if (i.next().getNamespace().equals(namespace)) continue;
                i.remove();
            }
        }
        if (this.isScoped() || "osgi.identity".equals(namespace)) {
            return result;
        }
        SubsystemContentHeader header = manifest.getSubsystemContentHeader();
        for (Resource constituent : this.getConstituents()) {
            if (!header.contains(constituent)) continue;
            for (Capability capability : constituent.getCapabilities(namespace)) {
                result.add(new BasicCapability(capability, this));
            }
        }
        return result;
    }

    public List<Requirement> getRequirements(String namespace) {
        SubsystemManifest manifest = this.getSubsystemManifest();
        List<Requirement> result = manifest.toRequirements(this);
        if (namespace != null) {
            Iterator<Requirement> i = result.iterator();
            while (i.hasNext()) {
                if (i.next().getNamespace().equals(namespace)) continue;
                i.remove();
            }
        }
        if (this.isScoped()) {
            return result;
        }
        SubsystemContentHeader header = manifest.getSubsystemContentHeader();
        for (Resource constituent : this.getConstituents()) {
            if (!header.contains(constituent)) continue;
            for (Requirement requirement : constituent.getRequirements(namespace)) {
                result.add(new BasicRequirement(requirement, this));
            }
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getLocation().hashCode();
        return result;
    }

    @Override
    public BundleContext getBundleContext() {
        SecurityManager.checkContextPermission(this);
        return AccessController.doPrivileged(new GetBundleContextAction(this));
    }

    @Override
    public Collection<Subsystem> getChildren() {
        return Activator.getInstance().getSubsystems().getChildren(this);
    }

    @Override
    public Map<String, String> getSubsystemHeaders(Locale locale) {
        SecurityManager.checkMetadataPermission(this);
        return AccessController.doPrivileged(new GetSubsystemHeadersAction(this, locale));
    }

    @Override
    public String getLocation() {
        SecurityManager.checkMetadataPermission(this);
        return this.getDeploymentManifestHeaderValue("AriesSubsystem-Location");
    }

    @Override
    public Collection<Subsystem> getParents() {
        AriesSubsystemParentsHeader header = this.getDeploymentManifest().getAriesSubsystemParentsHeader();
        if (header == null) {
            return Collections.emptyList();
        }
        ArrayList<Subsystem> result = new ArrayList<Subsystem>(header.getClauses().size());
        for (AriesSubsystemParentsHeader.Clause clause : header.getClauses()) {
            BasicSubsystem subsystem = Activator.getInstance().getSubsystems().getSubsystemById(clause.getId());
            if (subsystem == null) continue;
            result.add(subsystem);
        }
        return result;
    }

    @Override
    public Collection<Resource> getConstituents() {
        return Activator.getInstance().getSubsystems().getConstituents(this);
    }

    @Override
    public Subsystem.State getState() {
        return Subsystem.State.valueOf(this.getDeploymentManifestHeaderValue("AriesSubsystem-State"));
    }

    @Override
    public long getSubsystemId() {
        return Long.parseLong(this.getDeploymentManifestHeaderValue("AriesSubsystem-Id"));
    }

    @Override
    public String getSymbolicName() {
        return this.getSubsystemManifest().getSubsystemSymbolicNameHeader().getSymbolicName();
    }

    @Override
    public String getType() {
        return this.getSubsystemManifest().getSubsystemTypeHeader().getType();
    }

    @Override
    public Version getVersion() {
        return this.getSubsystemManifest().getSubsystemVersionHeader().getVersion();
    }

    @Override
    public AriesSubsystem install(String location) {
        return this.install(location, (InputStream)null);
    }

    @Override
    public AriesSubsystem install(String location, InputStream content) {
        return this.install(location, content, null);
    }

    @Override
    public void start() {
        SecurityManager.checkExecutePermission(this);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                BasicSubsystem.this.setAutostart(true);
                return null;
            }
        });
        AccessController.doPrivileged(new StartAction(this, this, this));
    }

    @Override
    public void stop() {
        SecurityManager.checkExecutePermission(this);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                BasicSubsystem.this.setAutostart(false);
                return null;
            }
        });
        AccessController.doPrivileged(new StopAction(this, this, !this.isRoot()));
    }

    @Override
    public void uninstall() {
        SecurityManager.checkLifecyclePermission(this);
        AccessController.doPrivileged(new UninstallAction(this, this, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addedConstituent(Resource resource, boolean referenced) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Adding constituent {} to deployment manifest...", (Object)resource);
            }
            BasicSubsystem basicSubsystem = this;
            synchronized (basicSubsystem) {
                this.setDeploymentManifest(new DeploymentManifest.Builder().manifest(this.getDeploymentManifest()).content(resource, referenced).build());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Added constituent {} to deployment manifest", (Object)resource);
            }
        }
        catch (Exception e) {
            throw new SubsystemException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addedParent(BasicSubsystem subsystem, boolean referenceCount) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Adding parent {} to deployment manifest...", (Object)subsystem.getSymbolicName());
            }
            BasicSubsystem basicSubsystem = this;
            synchronized (basicSubsystem) {
                this.setDeploymentManifest(new DeploymentManifest.Builder().manifest(this.getDeploymentManifest()).parent(subsystem, referenceCount).build());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Added parent {} to deployment manifest", (Object)subsystem.getSymbolicName());
            }
        }
        catch (Exception e) {
            throw new SubsystemException(e);
        }
    }

    synchronized DeploymentManifest getDeploymentManifest() {
        if (this.deploymentManifest == null) {
            try {
                this.deploymentManifest = new DeploymentManifest(this.directory.getFile("OSGI-INF/DEPLOYMENT.MF").open());
            }
            catch (Throwable t) {
                throw new SubsystemException(t);
            }
        }
        return this.deploymentManifest;
    }

    File getDirectory() {
        try {
            return new File(this.directory.toURL().toURI());
        }
        catch (Exception e) {
            throw new SubsystemException(e);
        }
    }

    Region getRegion() {
        Bundle bundle = this.regionContextBundle;
        if (bundle == null) {
            return Activator.getInstance().getRegionDigraph().getRegion(this.getRegionName());
        }
        return Activator.getInstance().getRegionDigraph().getRegion(bundle);
    }

    String getRegionName() {
        DeploymentManifest manifest = this.getDeploymentManifest();
        Header<?> header = manifest.getHeaders().get("AriesSubsystem-Region");
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    synchronized SubsystemResource getResource() {
        if (this.resource == null) {
            try {
                this.resource = new SubsystemResource(this.directory);
            }
            catch (Exception e) {
                throw new SubsystemException(e);
            }
            Collection<DeployedContentHeader.Clause> missingResources = this.resource.getMissingResources();
            if (!missingResources.isEmpty()) {
                if (this.isRoot()) {
                    this.removedContent(missingResources);
                } else {
                    throw new SubsystemException("Missing resources: " + missingResources);
                }
            }
        }
        return this.resource;
    }

    synchronized SubsystemManifest getSubsystemManifest() {
        if (this.subsystemManifest == null) {
            try {
                this.subsystemManifest = new SubsystemManifest(this.directory.getFile("OSGI-INF/SUBSYSTEM.MF").open());
            }
            catch (Throwable t) {
                throw new SubsystemException(t);
            }
        }
        return this.subsystemManifest;
    }

    boolean isApplication() {
        return this.getSubsystemManifest().getSubsystemTypeHeader().isApplication();
    }

    boolean isAutostart() {
        DeploymentManifest manifest = this.getDeploymentManifest();
        Header<?> header = manifest.getHeaders().get("AriesSubsystem-Autostart");
        return Boolean.valueOf(header.getValue());
    }

    boolean isComposite() {
        return this.getSubsystemManifest().getSubsystemTypeHeader().isComposite();
    }

    boolean isFeature() {
        return this.getSubsystemManifest().getSubsystemTypeHeader().isFeature();
    }

    boolean isReadyToStart() {
        if (this.isRoot()) {
            return true;
        }
        for (Subsystem parent : this.getParents()) {
            if (!EnumSet.of(Subsystem.State.STARTING, Subsystem.State.ACTIVE).contains((Object)parent.getState()) || !this.isAutostart()) continue;
            return true;
        }
        return false;
    }

    boolean isReferenced(Resource resource) {
        if (this.isRoot() && EnumSet.of(Subsystem.State.INSTALLING, Subsystem.State.INSTALLED).contains((Object)this.getState())) {
            return true;
        }
        DeployedContentHeader header = this.getDeploymentManifest().getDeployedContentHeader();
        if (header == null) {
            return false;
        }
        return header.isReferenced(resource);
    }

    boolean isRoot() {
        return ROOT_LOCATION.equals(this.getLocation());
    }

    boolean isScoped() {
        return this.isApplication() || this.isComposite();
    }

    void removedContent(Resource resource) {
        DeploymentManifest manifest = this.getDeploymentManifest();
        DeployedContentHeader header = manifest.getDeployedContentHeader();
        if (header == null) {
            return;
        }
        DeployedContentHeader.Clause clause = header.getClause(resource);
        if (clause == null) {
            return;
        }
        this.removedContent(Collections.singleton(clause));
    }

    synchronized void removedContent(Collection<DeployedContentHeader.Clause> content) {
        DeploymentManifest manifest = this.getDeploymentManifest();
        DeployedContentHeader header = manifest.getDeployedContentHeader();
        if (header == null) {
            return;
        }
        ArrayList<DeployedContentHeader.Clause> clauses = new ArrayList<DeployedContentHeader.Clause>(header.getClauses());
        Iterator i = clauses.iterator();
        while (i.hasNext()) {
            if (!content.contains(i.next())) continue;
            i.remove();
            break;
        }
        DeploymentManifest.Builder builder = new DeploymentManifest.Builder();
        for (Map.Entry<String, Header<?>> entry : manifest.getHeaders().entrySet()) {
            if ("Deployed-Content".equals(entry.getKey())) continue;
            builder.header(entry.getValue());
        }
        if (!clauses.isEmpty()) {
            builder.header(new DeployedContentHeader((Collection<DeployedContentHeader.Clause>)clauses));
        }
        try {
            this.setDeploymentManifest(builder.build());
        }
        catch (Exception e) {
            throw new SubsystemException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAutostart(boolean value) {
        try {
            BasicSubsystem basicSubsystem = this;
            synchronized (basicSubsystem) {
                this.setDeploymentManifest(new DeploymentManifest.Builder().manifest(this.getDeploymentManifest()).autostart(value).build());
            }
        }
        catch (Exception e) {
            throw new SubsystemException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setDeploymentManifest(DeploymentManifest value) throws IOException {
        this.deploymentManifest = value;
        Coordination coordination = Activator.getInstance().getCoordinator().peek();
        if (logger.isDebugEnabled()) {
            logger.debug("Setting deployment manifest for subsystem {} using coordination {}", (Object)this.getSymbolicName(), (Object)(coordination == null ? null : coordination.getName()));
        }
        if (coordination == null) {
            this.saveDeploymentManifest();
        } else {
            Map variables;
            Map map = variables = coordination.getVariables();
            synchronized (map) {
                HashSet<BasicSubsystem> dirtySubsystems = (HashSet<BasicSubsystem>)variables.get(SaveManifestParticipant.class);
                if (dirtySubsystems == null) {
                    dirtySubsystems = new HashSet<BasicSubsystem>();
                    variables.put(SaveManifestParticipant.class, dirtySubsystems);
                    coordination.addParticipant((Participant)new SaveManifestParticipant());
                }
                dirtySubsystems.add(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void saveDeploymentManifest() throws IOException {
        File file = new File(this.getDirectory(), "OSGI-INF");
        if (!file.exists()) {
            file.mkdirs();
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(file, "DEPLOYMENT.MF")));
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Writing deployment manifest for subsystem {} in state {}", (Object)this.getSymbolicName(), (Object)this.getState());
            }
            this.deploymentManifest.write(out);
            if (logger.isDebugEnabled()) {
                logger.debug("Wrote deployment manifest for subsystem {} in state {}", (Object)this.getSymbolicName(), (Object)this.getState());
            }
        }
        finally {
            IOUtils.close((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(Subsystem.State value) {
        BasicSubsystem basicSubsystem;
        Subsystem.State state;
        if (logger.isDebugEnabled()) {
            logger.debug("Setting state of subsystem {} to {}", (Object)this.getSymbolicName(), (Object)value);
        }
        if (value.equals((Object)(state = this.getState()))) {
            if (logger.isDebugEnabled()) {
                logger.debug("Requested state {} equals current state {}", (Object)value, (Object)state);
            }
            return;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Setting the deployment manifest...");
            }
            basicSubsystem = this;
            synchronized (basicSubsystem) {
                this.setDeploymentManifest(new DeploymentManifest.Builder().manifest(this.getDeploymentManifest()).state(value).build());
            }
        }
        catch (Exception e) {
            throw new SubsystemException(e);
        }
        Activator.getInstance().getSubsystemServiceRegistrar().update(this);
        basicSubsystem = this;
        synchronized (basicSubsystem) {
            if (logger.isDebugEnabled()) {
                logger.debug("Notifying all waiting for state change of subsystem {}", (Object)this.getSymbolicName());
            }
            this.notifyAll();
        }
    }

    void setRegionContextBundle(Bundle value) {
        this.regionContextBundle = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setSubsystemManifest(SubsystemManifest value) throws URISyntaxException, IOException {
        File file = new File(this.getDirectory(), "OSGI-INF");
        if (!file.exists()) {
            file.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(new File(file, "SUBSYSTEM.MF"));
        try {
            value.write(fos);
            this.subsystemManifest = value;
        }
        finally {
            IOUtils.close((Closeable)fos);
        }
    }

    private String getDeploymentManifestHeaderValue(String name) {
        DeploymentManifest manifest = this.getDeploymentManifest();
        if (manifest == null) {
            return null;
        }
        Header<?> header = manifest.getHeaders().get(name);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    @Override
    public synchronized void addRequirements(Collection<Requirement> requirements) {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("The root subsystem does not accept additional requirements");
        }
        if (!this.isScoped()) {
            return;
        }
        RegionUpdater updater = new RegionUpdater(this.getRegion(), ((BasicSubsystem)this.getParents().iterator().next()).getRegion());
        try {
            updater.addRequirements(requirements);
        }
        catch (Exception e) {
            throw new SubsystemException(e);
        }
    }

    @Override
    public AriesSubsystem install(String location, IDirectory content) {
        return this.install(location, content, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AriesSubsystem install(String location, IDirectory content, InputStream deploymentManifest) {
        try {
            AriesSubsystem ariesSubsystem = AccessController.doPrivileged(new InstallAction(location, content, this, AccessController.getContext(), deploymentManifest));
            return ariesSubsystem;
        }
        finally {
            IOUtils.close((Closeable)deploymentManifest);
        }
    }

    @Override
    public Map<String, String> getDeploymentHeaders() {
        SecurityManager.checkMetadataPermission(this);
        return AccessController.doPrivileged(new GetDeploymentHeadersAction(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AriesSubsystem install(String location, final InputStream content, InputStream deploymentManifest) {
        try {
            AriesSubsystem ariesSubsystem = this.install(location, content == null ? null : AccessController.doPrivileged(new PrivilegedAction<IDirectory>(){

                @Override
                public IDirectory run() {
                    return FileSystem.getFSRoot((InputStream)content);
                }
            }), deploymentManifest);
            return ariesSubsystem;
        }
        finally {
            IOUtils.close((Closeable)content);
        }
    }

    private void setTranslations() throws IOException {
        File file;
        String directoryName = this.getSubsystemManifest().getSubsystemLocalizationHeader().getDirectoryName();
        File file2 = file = directoryName == null ? this.getDirectory() : new File(this.getDirectory(), directoryName);
        if (!file.exists()) {
            file.mkdirs();
        }
        for (TranslationFile translation : this.getResource().getTranslations()) {
            translation.write(file);
        }
    }

    private static class SaveManifestParticipant
    implements Participant {
        protected SaveManifestParticipant() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ended(Coordination coordination) throws Exception {
            Set dirtySubsystems;
            Map variables;
            if (logger.isDebugEnabled()) {
                logger.debug("Saving deployment manifests because coordination {} ended", (Object)coordination.getName());
            }
            Map map = variables = coordination.getVariables();
            synchronized (map) {
                Set temp = (Set)variables.remove(SaveManifestParticipant.class);
                dirtySubsystems = temp == null ? Collections.emptySet() : temp;
            }
            for (BasicSubsystem dirtySubsystem : dirtySubsystems) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Saving deployment manifest of subsystem {} for coordination {}", (Object)dirtySubsystem.getSymbolicName(), (Object)coordination.getName());
                }
                dirtySubsystem.saveDeploymentManifest();
            }
        }

        public void failed(Coordination coordination) throws Exception {
        }
    }
}

