/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.security.PrivilegedAction;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAction
implements PrivilegedAction<Object> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAction.class);
    protected final boolean disableRootCheck;
    protected final BasicSubsystem requestor;
    protected final BasicSubsystem target;

    public AbstractAction(BasicSubsystem requestor, BasicSubsystem target, boolean disableRootCheck) {
        this.requestor = requestor;
        this.target = target;
        this.disableRootCheck = disableRootCheck;
    }

    protected void checkRoot() {
        if (!this.disableRootCheck && this.target.isRoot()) {
            throw new SubsystemException("This operation may not be performed on the root subsystem");
        }
    }

    protected void checkValid() {
        BasicSubsystem s = (BasicSubsystem)Activator.getInstance().getSubsystemServiceRegistrar().getSubsystemService(this.target);
        if (s != this.target) {
            throw new IllegalStateException("Detected stale subsystem instance: " + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForStateChange(Subsystem.State fromState) {
        long then = System.currentTimeMillis() + 60000L;
        BasicSubsystem basicSubsystem = this.target;
        synchronized (basicSubsystem) {
            if (logger.isDebugEnabled()) {
                logger.debug("Request to wait for state change of subsystem {} from state {}", (Object)this.target.getSymbolicName(), (Object)this.target.getState());
            }
            while (this.target.getState().equals((Object)fromState)) {
                long now;
                if (logger.isDebugEnabled()) {
                    logger.debug("{} equals {}", (Object)this.target.getState(), (Object)fromState);
                }
                if (then <= (now = System.currentTimeMillis())) {
                    throw new SubsystemException("Operation timed out while waiting for the subsystem to change state from " + (Object)((Object)fromState));
                }
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Waiting for {} ms", (Object)(then - now));
                    }
                    this.target.wait(then - now);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SubsystemException(e);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Done waiting for subsystem {} in state {} to change from state {}", new Object[]{this.target.getSymbolicName(), this.target.getState(), fromState});
            }
        }
    }
}

