/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import org.apache.aries.subsystem.core.archive.AbstractAttribute;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class VersionRangeAttribute
extends AbstractAttribute {
    public static final String NAME_BUNDLEVERSION = "bundle-version";
    public static final String NAME_VERSION = "version";
    public static final VersionRangeAttribute DEFAULT_BUNDLEVERSION = new VersionRangeAttribute("bundle-version", new VersionRange(Version.emptyVersion.toString()));
    public static final VersionRangeAttribute DEFAULT_VERSION = new VersionRangeAttribute();
    private final VersionRange range;

    public VersionRangeAttribute() {
        this(Version.emptyVersion.toString());
    }

    public VersionRangeAttribute(String value) {
        this(new VersionRange(value));
    }

    public VersionRangeAttribute(VersionRange range) {
        this(NAME_VERSION, range);
    }

    public VersionRangeAttribute(String name, VersionRange range) {
        super(name, range.toString());
        this.range = range;
    }

    @Override
    public StringBuilder appendToFilter(StringBuilder builder) {
        return builder.append(this.range.toFilterString(this.name));
    }

    @Override
    public Object getValue() {
        return '\"' + this.range.toString() + '\"';
    }

    public VersionRange getVersionRange() {
        return this.range;
    }
}

