/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.aries.subsystem.core.archive.AbstractClause;
import org.apache.aries.subsystem.core.archive.AbstractClauseBasedHeader;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.apache.aries.subsystem.core.archive.ResolutionDirective;
import org.apache.aries.subsystem.core.archive.StartOrderDirective;
import org.apache.aries.subsystem.core.archive.SubsystemContentRequirement;
import org.apache.aries.subsystem.core.archive.TypeAttribute;
import org.apache.aries.subsystem.core.archive.VersionRangeAttribute;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class SubsystemContentHeader
extends AbstractClauseBasedHeader<Clause>
implements RequirementHeader<Clause> {
    public static final String NAME = "Subsystem-Content";

    public static SubsystemContentHeader newInstance(Collection<Resource> resources) {
        StringBuilder builder = new StringBuilder();
        for (Resource resource : resources) {
            SubsystemContentHeader.appendResource(resource, builder);
            builder.append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return new SubsystemContentHeader(builder.toString());
    }

    private static StringBuilder appendResource(Resource resource, StringBuilder builder) {
        String symbolicName = ResourceHelper.getSymbolicNameAttribute(resource);
        Version version = ResourceHelper.getVersionAttribute(resource);
        String type = ResourceHelper.getTypeAttribute(resource);
        builder.append(symbolicName).append(';').append("version").append('=').append(version.toString()).append(';').append("type").append('=').append(type);
        return builder;
    }

    public SubsystemContentHeader(Collection<Clause> clauses) {
        super(clauses);
    }

    public SubsystemContentHeader(String value) {
        super(value, new AbstractClauseBasedHeader.ClauseFactory<Clause>(){

            @Override
            public Clause newInstance(String clause) {
                return new Clause(clause);
            }
        });
    }

    public boolean contains(Resource resource) {
        return this.getClause(resource) != null;
    }

    public Clause getClause(Resource resource) {
        String symbolicName = ResourceHelper.getSymbolicNameAttribute(resource);
        Version version = ResourceHelper.getVersionAttribute(resource);
        String type = ResourceHelper.getTypeAttribute(resource);
        for (Clause clause : this.clauses) {
            if (!symbolicName.equals(clause.getPath()) || !clause.getVersionRange().includes(version) || !type.equals(clause.getType())) continue;
            return clause;
        }
        return null;
    }

    public boolean isMandatory(Resource resource) {
        Clause clause = this.getClause(resource);
        if (clause == null) {
            return false;
        }
        return clause.isMandatory();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<Requirement> toRequirements(Resource resource) {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>(this.clauses.size());
        for (Clause clause : this.clauses) {
            requirements.add(clause.toRequirement(resource));
        }
        return requirements;
    }

    public static class Clause
    extends AbstractClause {
        public static final String ATTRIBUTE_VERSION = "version";
        public static final String ATTRIBUTE_TYPE = "type";
        public static final String DIRECTIVE_RESOLUTION = "resolution";
        public static final String DIRECTIVE_STARTORDER = "start-order";

        public Clause(String clause) {
            super(Clause.parsePath(clause, Patterns.SYMBOLIC_NAME, false), Clause.parseParameters(clause, true), Clause.generateDefaultParameters(TypeAttribute.DEFAULT, VersionRangeAttribute.DEFAULT_VERSION, ResolutionDirective.MANDATORY, new StartOrderDirective("0")));
        }

        public Clause(Resource resource) {
            this(SubsystemContentHeader.appendResource(resource, new StringBuilder()).toString());
        }

        public boolean contains(Resource resource) {
            return this.getSymbolicName().equals(ResourceHelper.getSymbolicNameAttribute(resource)) && this.getVersionRange().includes(ResourceHelper.getVersionAttribute(resource)) && this.getType().equals(ResourceHelper.getTypeAttribute(resource));
        }

        public String getSymbolicName() {
            return this.path;
        }

        public int getStartOrder() {
            return ((StartOrderDirective)this.getDirective(DIRECTIVE_STARTORDER)).getStartOrder();
        }

        public String getType() {
            return ((TypeAttribute)this.getAttribute(ATTRIBUTE_TYPE)).getType();
        }

        public VersionRange getVersionRange() {
            return ((VersionRangeAttribute)this.getAttribute(ATTRIBUTE_VERSION)).getVersionRange();
        }

        public boolean isMandatory() {
            return ((ResolutionDirective)this.getDirective(DIRECTIVE_RESOLUTION)).isMandatory();
        }

        public SubsystemContentRequirement toRequirement(Resource resource) {
            return new SubsystemContentRequirement(this, resource);
        }
    }
}

