/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.AbstractClause;
import org.apache.aries.subsystem.core.archive.AbstractClauseBasedHeader;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.AttributeFactory;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.DirectiveFactory;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.apache.aries.subsystem.core.archive.RequireBundleRequirement;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.apache.aries.subsystem.core.archive.ResolutionDirective;
import org.apache.aries.subsystem.core.archive.VersionRangeAttribute;
import org.apache.aries.subsystem.core.archive.VisibilityDirective;
import org.apache.aries.subsystem.core.capabilityset.SimpleFilter;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class RequireBundleHeader
extends AbstractClauseBasedHeader<Clause>
implements RequirementHeader<Clause> {
    public static final String NAME = "Require-Bundle";

    public RequireBundleHeader(Collection<Clause> clauses) {
        super(clauses);
    }

    public RequireBundleHeader(String value) {
        super(value, new AbstractClauseBasedHeader.ClauseFactory<Clause>(){

            @Override
            public Clause newInstance(String clause) {
                return new Clause(clause);
            }
        });
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<RequireBundleRequirement> toRequirements(Resource resource) {
        ArrayList<RequireBundleRequirement> requirements = new ArrayList<RequireBundleRequirement>(this.clauses.size());
        for (Clause clause : this.clauses) {
            requirements.add(clause.toRequirement(resource));
        }
        return requirements;
    }

    public static class Clause
    extends AbstractClause {
        public static final String ATTRIBUTE_BUNDLEVERSION = "bundle-version";
        public static final String DIRECTIVE_RESOLUTION = "resolution";
        public static final String DIRECTIVE_VISIBILITY = "visibility";
        private static final Collection<Parameter> defaultParameters = Clause.generateDefaultParameters(VersionRangeAttribute.DEFAULT_BUNDLEVERSION, VisibilityDirective.PRIVATE, ResolutionDirective.MANDATORY);

        public Clause(String clause) {
            super(Clause.parsePath(clause, Patterns.SYMBOLIC_NAME, false), Clause.parseParameters(clause, true), defaultParameters);
        }

        public Clause(String path, Map<String, Parameter> parameters, Collection<Parameter> defaultParameters) {
            super(path, parameters, defaultParameters);
        }

        public static Clause valueOf(Requirement requirement) {
            String namespace = requirement.getNamespace();
            if (!"osgi.wiring.bundle".equals(namespace)) {
                throw new IllegalArgumentException("Invalid namespace:" + namespace);
            }
            HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
            String filter = null;
            Map directives = requirement.getDirectives();
            for (Map.Entry entry : directives.entrySet()) {
                String key = (String)entry.getKey();
                if ("filter".equals(key)) {
                    filter = (String)entry.getValue();
                    continue;
                }
                parameters.put(key, DirectiveFactory.createDirective(key, (String)entry.getValue()));
            }
            Map<String, List<SimpleFilter>> attributes = SimpleFilter.attributes(filter);
            String path = null;
            for (Map.Entry<String, List<SimpleFilter>> entry : attributes.entrySet()) {
                String key = entry.getKey();
                List<SimpleFilter> value = entry.getValue();
                if ("osgi.wiring.bundle".equals(key)) {
                    path = String.valueOf(value.get(0).getValue());
                    continue;
                }
                if (ATTRIBUTE_BUNDLEVERSION.equals(key)) {
                    parameters.put(key, new VersionRangeAttribute(key, AbstractClauseBasedHeader.parseVersionRange(value)));
                    continue;
                }
                parameters.put(key, AttributeFactory.createAttribute(key, String.valueOf(value.get(0).getValue())));
            }
            return new Clause(path, parameters, defaultParameters);
        }

        @Override
        public Attribute getAttribute(String name) {
            Parameter result = (Parameter)this.parameters.get(name);
            if (result instanceof Attribute) {
                return (Attribute)result;
            }
            return null;
        }

        @Override
        public Collection<Attribute> getAttributes() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Attribute)) continue;
                attributes.add((Attribute)parameter);
            }
            attributes.trimToSize();
            return attributes;
        }

        @Override
        public Directive getDirective(String name) {
            Parameter result = (Parameter)this.parameters.get(name);
            if (result instanceof Directive) {
                return (Directive)result;
            }
            return null;
        }

        @Override
        public Collection<Directive> getDirectives() {
            ArrayList<Directive> directives = new ArrayList<Directive>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Directive)) continue;
                directives.add((Directive)parameter);
            }
            directives.trimToSize();
            return directives;
        }

        public String getSymbolicName() {
            return this.path;
        }

        public RequireBundleRequirement toRequirement(Resource resource) {
            return new RequireBundleRequirement(this, resource);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.getPath());
            for (Parameter parameter : this.getParameters()) {
                builder.append(';').append(parameter);
            }
            return builder.toString();
        }
    }
}

