/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.aries.subsystem.core.archive.AbstractClause;
import org.apache.aries.subsystem.core.archive.AbstractClauseBasedHeader;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.CapabilityHeader;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.ExportPackageCapability;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.apache.aries.subsystem.core.archive.VersionAttribute;
import org.osgi.resource.Resource;

public class ExportPackageHeader
extends AbstractClauseBasedHeader<Clause>
implements CapabilityHeader<Clause> {
    public static final String NAME = "Export-Package";

    public ExportPackageHeader(String value) {
        super(value, new AbstractClauseBasedHeader.ClauseFactory<Clause>(){

            @Override
            public Clause newInstance(String clause) {
                return new Clause(clause);
            }
        });
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<ExportPackageCapability> toCapabilities(Resource resource) {
        ArrayList<ExportPackageCapability> result = new ArrayList<ExportPackageCapability>();
        for (Clause clause : this.clauses) {
            result.addAll(clause.toCapabilities(resource));
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Clause clause : this.getClauses()) {
            builder.append(clause).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static class Clause
    extends AbstractClause {
        public static final String ATTRIBUTE_VERSION = "version";
        public static final String DIRECTIVE_EXCLUDE = "exclude";
        public static final String DIRECTIVE_INCLUDE = "include";
        public static final String DIRECTIVE_MANDATORY = "mandatory";
        public static final String DIRECTIVE_USES = "uses";

        public Clause(String clause) {
            super(Clause.parsePath(clause, Patterns.PACKAGE_NAMES, false), Clause.parseParameters(clause, false), Clause.generateDefaultParameters(VersionAttribute.DEFAULT));
        }

        @Override
        public Attribute getAttribute(String name) {
            Parameter result = (Parameter)this.parameters.get(name);
            if (result instanceof Attribute) {
                return (Attribute)result;
            }
            return null;
        }

        @Override
        public Collection<Attribute> getAttributes() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Attribute)) continue;
                attributes.add((Attribute)parameter);
            }
            attributes.trimToSize();
            return attributes;
        }

        @Override
        public Directive getDirective(String name) {
            Parameter result = (Parameter)this.parameters.get(name);
            if (result instanceof Directive) {
                return (Directive)result;
            }
            return null;
        }

        @Override
        public Collection<Directive> getDirectives() {
            ArrayList<Directive> directives = new ArrayList<Directive>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Directive)) continue;
                directives.add((Directive)parameter);
            }
            directives.trimToSize();
            return directives;
        }

        public Collection<String> getPackageNames() {
            return Arrays.asList(this.path.split(";"));
        }

        @Override
        public Parameter getParameter(String name) {
            return (Parameter)this.parameters.get(name);
        }

        @Override
        public Collection<Parameter> getParameters() {
            return Collections.unmodifiableCollection(this.parameters.values());
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public Collection<ExportPackageCapability> toCapabilities(Resource resource) {
            Collection<String> packageNames = this.getPackageNames();
            ArrayList<ExportPackageCapability> result = new ArrayList<ExportPackageCapability>(packageNames.size());
            for (String packageName : packageNames) {
                result.add(new ExportPackageCapability(packageName, this.parameters.values(), resource));
            }
            return result;
        }
    }
}

