/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.DynamicImportPackageHeader;
import org.apache.aries.subsystem.core.archive.VersionRangeAttribute;
import org.apache.aries.subsystem.core.internal.AbstractRequirement;
import org.osgi.resource.Resource;

public class DynamicImportPackageRequirement
extends AbstractRequirement {
    public static final String DIRECTIVE_FILTER = "filter";
    public static final String NAMESPACE = "osgi.wiring.package";
    private final Map<String, String> directives;
    private final String packageName;
    private final Resource resource;

    public DynamicImportPackageRequirement(String pkg, DynamicImportPackageHeader.Clause clause, Resource resource) {
        this.packageName = pkg;
        Collection<Directive> clauseDirectives = clause.getDirectives();
        this.directives = new HashMap<String, String>(clauseDirectives.size() + 1);
        for (Directive directive : clauseDirectives) {
            this.directives.put(directive.getName(), directive.getValue());
        }
        StringBuilder filter = new StringBuilder("(&(").append(NAMESPACE).append('=').append(pkg).append(')');
        VersionRangeAttribute versionRange = clause.getVersionRangeAttribute();
        if (versionRange != null) {
            versionRange.appendToFilter(filter);
        }
        this.directives.put(DIRECTIVE_FILTER, filter.append(')').toString());
        this.resource = resource;
    }

    public Map<String, Object> getAttributes() {
        return Collections.emptyMap();
    }

    public Map<String, String> getDirectives() {
        return Collections.unmodifiableMap(this.directives);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Resource getResource() {
        return this.resource;
    }
}

