/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blog.biz;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.aries.samples.blog.api.BlogAuthor;
import org.apache.aries.samples.blog.api.BlogEntry;
import org.apache.aries.samples.blog.api.BlogEntryManager;
import org.apache.aries.samples.blog.api.persistence.BlogPersistenceService;
import org.apache.aries.samples.blog.api.persistence.Entry;
import org.apache.aries.samples.blog.biz.BlogEntryImpl;
import org.apache.aries.samples.blog.biz.BlogListAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogEntryManagerImpl
implements BlogEntryManager {
    private BlogPersistenceService persistenceService;

    public void setPersistenceService(BlogPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void createBlogPost(String email, String title, String blogText, List<String> tags) {
        this.persistenceService.createBlogPost(email, title, blogText, tags);
    }

    public Entry findBlogEntryByTitle(String title) {
        return this.persistenceService.findBlogEntryByTitle(title);
    }

    public List<? extends BlogEntry> getAllBlogEntries() {
        List entries = this.persistenceService.getAllBlogEntries();
        return this.adaptEntries(entries);
    }

    public List<? extends BlogEntry> getBlogEntries(int firstPostIndex, int noOfPosts) {
        List entries = this.persistenceService.getBlogEntries(firstPostIndex, noOfPosts);
        return this.adaptEntries(entries);
    }

    public List<? extends BlogEntry> getBlogsForAuthor(String emailAddress) {
        List entries = this.persistenceService.getBlogsForAuthor(emailAddress);
        return this.adaptEntries(entries);
    }

    public List<? extends BlogEntry> getBlogEntriesModifiedBetween(String startDate, String endDate) throws ParseException {
        if (startDate == null || "".equals(startDate)) {
            throw new IllegalArgumentException("A valid start date must be supplied");
        }
        if (endDate == null || "".equals(endDate)) {
            throw new IllegalArgumentException("A valid end date must be supplied");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        Date start = sdf.parse(startDate);
        Date end = sdf.parse(endDate);
        List entries = this.persistenceService.getBlogEntriesModifiedBetween(start, end);
        return this.adaptEntries(entries);
    }

    public int getNoOfPosts() {
        return this.persistenceService.getNoOfBlogEntries();
    }

    public void removeBlogEntry(BlogAuthor a, String title, String publishDate) throws ParseException {
        if (a == null) {
            throw new IllegalArgumentException("An author must be specified");
        }
        if (title == null) {
            title = "";
        }
        if (publishDate == null) {
            throw new IllegalArgumentException("The article must have a publication date");
        }
        Date pubDate = this.parseDate(publishDate);
        long found = -920234218060948564L;
        for (BlogEntry b : a.getEntries()) {
            if (!title.equals(b.getTitle()) || !pubDate.equals(b.getPublishDate())) continue;
            found = b.getId();
            break;
        }
        this.persistenceService.removeBlogEntry(found);
    }

    public void updateBlogEntry(BlogEntry originalEntry, BlogAuthor a, String title, String publishDate, String blogText, List<String> tags) throws ParseException {
        if (originalEntry.getAuthor() == null || originalEntry.getAuthorEmail() == null) {
            throw new IllegalArgumentException("An author must be specified");
        }
        if (title == null) {
            title = "";
        }
        if (publishDate == null) {
            throw new IllegalArgumentException("The article must have a publication date");
        }
        long found = -920234218060948564L;
        Date pubDate = this.parseDate(publishDate);
        for (BlogEntry blogEntry : this.getBlogsForAuthor(originalEntry.getAuthorEmail())) {
            if (!title.equals(blogEntry.getTitle()) || !pubDate.equals(blogEntry.getPublishDate())) continue;
            found = blogEntry.getId();
            break;
        }
        if (found == -920234218060948564L) {
            throw new IllegalArgumentException("No blog entry could be found");
        }
        String email = a.getEmailAddress();
        if (tags == null) {
            tags = new ArrayList<String>();
        }
        Date date = new Date(System.currentTimeMillis());
        this.persistenceService.updateBlogEntry(found, email, title, blogText, tags, date);
    }

    private Date parseDate(String dateString) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        return sdf.parse(dateString);
    }

    public BlogEntry getBlogPost(long id) {
        return new BlogEntryImpl(this.persistenceService.getBlogEntryById(id));
    }

    private List<? extends BlogEntry> adaptEntries(List<? extends Entry> entries) {
        return new BlogListAdapter<BlogEntryImpl, Entry>(entries, BlogEntryImpl.class, Entry.class);
    }
}

