/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blog.biz;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.aries.samples.blog.api.BlogComment;
import org.apache.aries.samples.blog.api.BlogCommentManager;
import org.apache.aries.samples.blog.api.comment.persistence.BlogCommentService;
import org.apache.aries.samples.blog.api.comment.persistence.Comment;
import org.apache.aries.samples.blog.biz.BlogCommentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogCommentManagerImpl
implements BlogCommentManager {
    private BlogCommentService commentService;
    private boolean commentServiceValid;

    public void setCommentService(BlogCommentService bcs) {
        this.commentService = bcs;
    }

    public void createComment(String comment, String email, long entryId) {
        this.commentService.createComment(comment, email, entryId);
    }

    public List<? extends BlogComment> getCommentsByAuthor(String email) {
        List comment = this.commentService.getCommentsForAuthor(email);
        return this.adaptComment(comment);
    }

    public List<? extends BlogComment> getCommentsForPost(long id) {
        List comment = this.commentService.getCommentsForEntry(id);
        return this.adaptComment(comment);
    }

    public void deleteComment(int id) {
        this.commentService.delete(id);
    }

    private List<? extends BlogComment> adaptComment(List<? extends Comment> comments) {
        ArrayList<BlogCommentImpl> list = new ArrayList<BlogCommentImpl>();
        Iterator<? extends Comment> c = comments.iterator();
        while (c.hasNext()) {
            list.add(new BlogCommentImpl(c.next()));
        }
        return list;
    }

    public boolean isCommentingAvailable() {
        return this.commentServiceValid;
    }

    public void blogServiceBound(BlogCommentService comment, Map props) {
        this.commentServiceValid = true;
    }

    public void blogServiceUnbound(BlogCommentService comment, Map props) {
    }
}

