/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blog.biz;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.aries.samples.blog.api.BlogAuthor;
import org.apache.aries.samples.blog.api.BlogAuthorManager;
import org.apache.aries.samples.blog.api.persistence.Author;
import org.apache.aries.samples.blog.api.persistence.BlogPersistenceService;
import org.apache.aries.samples.blog.biz.BlogAuthorImpl;
import org.apache.aries.samples.blog.biz.BlogListAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogAuthorManagerImpl
implements BlogAuthorManager {
    private BlogPersistenceService persistenceService;

    public void setPersistenceService(BlogPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void createAuthor(String email, String dob, String name, String displayName, String bio) throws ParseException {
        if (email == null) {
            throw new IllegalArgumentException("Email must not be null");
        }
        Date dateOfBirth = dob == null || "".equals(dob) ? null : new SimpleDateFormat("yyyy-MM-dd").parse(dob);
        this.persistenceService.createAuthor(email, dateOfBirth, name, displayName, bio);
    }

    public List<? extends BlogAuthor> getAllAuthors() {
        List authors = this.persistenceService.getAllAuthors();
        return this.adaptAuthor(authors);
    }

    public BlogAuthor getAuthor(String emailAddress) {
        if (emailAddress == null) {
            throw new IllegalArgumentException("Email must not be null");
        }
        Author a = this.persistenceService.getAuthor(emailAddress);
        if (a != null) {
            return new BlogAuthorImpl(a);
        }
        return null;
    }

    public void removeAuthor(String emailAddress) {
        if (emailAddress == null) {
            throw new IllegalArgumentException("Email must not be null");
        }
        this.persistenceService.removeAuthor(emailAddress);
    }

    public void updateAuthor(String email, String dob, String name, String displayName, String bio) throws ParseException {
        if (email == null) {
            throw new IllegalArgumentException("Email must not be null");
        }
        Date dateOfBirth = dob == null || "".equals(dob) ? null : new SimpleDateFormat("yyyy-MM-dd").parse(dob);
        this.persistenceService.updateAuthor(email, dateOfBirth, name, displayName, bio);
    }

    private List<? extends BlogAuthor> adaptAuthor(List<? extends Author> authors) {
        return new BlogListAdapter<BlogAuthorImpl, Author>(authors, BlogAuthorImpl.class, Author.class);
    }
}

