/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.ariestrader.web.prims;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.aries.samples.ariestrader.api.TradeServiceUtilities;
import org.apache.aries.samples.ariestrader.api.TradeServices;
import org.apache.aries.samples.ariestrader.api.persistence.QuoteDataBean;
import org.apache.aries.samples.ariestrader.util.Log;
import org.apache.aries.samples.ariestrader.util.TradeConfig;

public class PingJDBCWrite
extends HttpServlet {
    private static String initTime;
    private static int hitCount;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String symbol = null;
        StringBuffer output = new StringBuffer(100);
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        try {
            symbol = TradeConfig.rndSymbol();
            BigDecimal newPrice = TradeConfig.getRandomPriceChangeFactor();
            TradeServices tradeServices = TradeServiceUtilities.getTradeServices((String)"(mode=JDBC)");
            QuoteDataBean quoteData = null;
            int iter = TradeConfig.getPrimIterations();
            for (int ii = 0; ii < iter; ++ii) {
                quoteData = tradeServices.updateQuotePriceVolume(symbol, newPrice, 100.0);
            }
            output.append("<html><head><title>Ping JDBC Write w/ Prepared Stmt.</title></head><body><HR><FONT size=\"+2\" color=\"#000066\">Ping JDBC Write w/ Prep Stmt:</FONT><FONT size=\"-1\" color=\"#000066\"><HR>Init time : " + initTime);
            output.append("<BR>Hit Count: " + ++hitCount);
            output.append("<HR>Update Information<BR>");
            output.append("<BR>" + quoteData.toHTML() + "<HR></FONT></BODY></HTML>");
            out.println(output.toString());
        }
        catch (Exception e) {
            Log.error((Throwable)e, (String)"PingJDBCWrite -- error updating quote for symbol", (String)symbol);
            res.sendError(500, "PingJDBCWrite Exception caught: " + e.toString());
        }
    }

    public String getServletInfo() {
        return "Basic JDBC Write using a prepared statment makes use of TradeJdbc code.";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        initTime = new Date().toString();
        hitCount = 0;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }
}

