/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.ariestrader.web.prims;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.aries.samples.ariestrader.api.TradeServiceUtilities;
import org.apache.aries.samples.ariestrader.api.TradeServices;
import org.apache.aries.samples.ariestrader.api.persistence.QuoteDataBean;
import org.apache.aries.samples.ariestrader.util.Log;
import org.apache.aries.samples.ariestrader.util.TradeConfig;

public class PingJDBCRead
extends HttpServlet {
    private static String initTime;
    private static int hitCount;

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        String symbol = null;
        StringBuffer output = new StringBuffer(100);
        try {
            TradeServices tradeServices = TradeServiceUtilities.getTradeServices((String)"(mode=JDBC)");
            symbol = TradeConfig.rndSymbol();
            QuoteDataBean quoteData = null;
            int iter = TradeConfig.getPrimIterations();
            for (int ii = 0; ii < iter; ++ii) {
                quoteData = tradeServices.getQuote(symbol);
            }
            output.append("<html><head><title>Ping JDBC Read w/ Prepared Stmt.</title></head><body><HR><FONT size=\"+2\" color=\"#000066\">Ping JDBC Read w/ Prep Stmt:</FONT><HR><FONT size=\"-1\" color=\"#000066\">Init time : " + initTime);
            output.append("<BR>Hit Count: " + ++hitCount);
            output.append("<HR>Quote Information <BR><BR>: " + quoteData.toHTML());
            output.append("<HR></body></html>");
            out.println(output.toString());
        }
        catch (Exception e) {
            Log.error((Throwable)e, (String)"PingJDBCRead w/ Prep Stmt -- error getting quote for symbol", (String)symbol);
            res.sendError(500, "PingJDBCRead Exception caught: " + e.toString());
        }
    }

    public String getServletInfo() {
        return "Basic JDBC Read using a prepared statment, makes use of TradeJdbc class via TradeServices";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        hitCount = 0;
        initTime = new Date().toString();
    }
}

