/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.ariestrader.web;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.aries.samples.ariestrader.api.TradeServices;
import org.apache.aries.samples.ariestrader.api.persistence.AccountDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.AccountProfileDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.HoldingDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.OrderDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.QuoteDataBean;
import org.apache.aries.samples.ariestrader.util.Log;
import org.apache.aries.samples.ariestrader.util.TradeConfig;

public class TradeServletAction {
    private TradeServices tradeServices = null;

    public TradeServletAction(TradeServices tradeServices) {
        this.tradeServices = tradeServices;
    }

    void doAccount(ServletContext ctx, HttpServletRequest req, HttpServletResponse resp, String userID, String results) throws ServletException, IOException {
        try {
            AccountDataBean accountData = this.tradeServices.getAccountData(userID);
            AccountProfileDataBean accountProfileData = this.tradeServices.getAccountProfileData(userID);
            ArrayList orderDataBeans = TradeConfig.getLongRun() ? new ArrayList() : (ArrayList)this.tradeServices.getOrders(userID);
            req.setAttribute("accountData", (Object)accountData);
            req.setAttribute("accountProfileData", (Object)accountProfileData);
            req.setAttribute("orderDataBeans", (Object)orderDataBeans);
            req.setAttribute("results", (Object)results);
            this.requestDispatch(ctx, req, resp, userID, TradeConfig.getPage((int)5));
        }
        catch (IllegalArgumentException e) {
            req.setAttribute("results", (Object)(results + "could not find account for userID = " + userID));
            this.requestDispatch(ctx, req, resp, userID, TradeConfig.getPage((int)4));
            Log.error((String)"TradeServletAction.doAccount(...)", (String)"illegal argument, information should be in exception string", (Throwable)e);
        }
        catch (Exception e) {
            throw new ServletException("TradeServletAction.doAccount(...) exception user =" + userID, (Throwable)e);
        }
    }

    void doAccountUpdate(ServletContext ctx, HttpServletRequest req, HttpServletResponse resp, String userID, String password, String cpassword, String fullName, String address, String creditcard, String email) throws ServletException, IOException {
        String results = "";
        boolean doUpdate = true;
        if (!password.equals(cpassword)) {
            results = "Update profile error: passwords do not match";
            doUpdate = false;
        } else if (password.length() <= 0 || fullName.length() <= 0 || address.length() <= 0 || creditcard.length() <= 0 || email.length() <= 0) {
            results = "Update profile error: please fill in all profile information fields";
            doUpdate = false;
        }
        try {
            if (doUpdate) {
                this.tradeServices.updateAccountProfile(userID, password, fullName, address, email, creditcard);
                results = "Account profile update successful";
            }
        }
        catch (IllegalArgumentException e) {
            req.setAttribute("results", (Object)(results + "invalid argument, check userID is correct, and the database is populated" + userID));
            Log.error((Throwable)e, (String)"TradeServletAction.doAccount(...)", (String)"illegal argument, information should be in exception string", (String)"treating this as a user error and forwarding on to a new page");
        }
        catch (Exception e) {
            throw new ServletException("TradeServletAction.doAccountUpdate(...) exception user =" + userID, (Throwable)e);
        }
        this.doAccount(ctx, req, resp, userID, results);
    }

    void doBuy(ServletContext ctx, HttpServletRequest req, HttpServletResponse resp, String userID, String symbol, String quantity) throws ServletException, IOException {
        String results = "";
        try {
            OrderDataBean orderData = this.tradeServices.buy(userID, symbol, new Double(quantity).doubleValue(), TradeConfig.orderProcessingMode);
            req.setAttribute("orderData", (Object)orderData);
            req.setAttribute("results", (Object)results);
        }
        catch (IllegalArgumentException e) {
            req.setAttribute("results", (Object)(results + "illegal argument:"));
            this.requestDispatch(ctx, req, resp, userID, TradeConfig.getPage((int)4));
            Log.error((Throwable)e, (String)"TradeServletAction.doBuy(...)", (String)("illegal argument. userID = " + userID), (String)("symbol = " + symbol));
        }
        catch (Exception e) {
            throw new ServletException("TradeServletAction.buy(...) exception buying stock " + symbol + " for user " + userID, (Throwable)e);
        }
        this.requestDispatch(ctx, req, resp, userID, TradeConfig.getPage((int)6));
    }

    void doHome(ServletContext ctx, HttpServletRequest req, HttpServletResponse resp, String userID, String results) throws ServletException, IOException {
        try {
            AccountDataBean accountData = this.tradeServices.getAccountData(userID);
            Collection holdingDataBeans = this.tradeServices.getHoldings(userID);
            req.setAttribute("accountData", (Object)accountData);
            req.setAttribute("holdingDataBeans", (Object)holdingDataBeans);
            req.setAttribute("results", (Object)results);
        }
        catch (IllegalArgumentException e) {
            req.setAttribute("results", (Object)(results + "check userID = " + userID + " and that the database is populated"));
            this.requestDispatch(ctx, req, resp, userID, TradeConfig.getPage((int)4));
            Log.error((String)"TradeServletAction.doHome(...)illegal argument, information should be in exception stringtreating this as a user error and forwarding on to a new page", (Throwable)e);
        }
        catch (Exception e) {
            throw new ServletException("TradeServletAction.doHome(...) exception user =" + userID, (Throwable)e);
        }
        this.requestDispatch(ctx, req, resp, userID, TradeConfig.getPage((int)4));
    }

    void doLogin(ServletContext ctx, HttpServletRequest req, HttpServletResponse resp, String userID, String passwd) throws ServletException, IOException {
        String results = "";
        try {
            AccountDataBean accountData = this.tradeServices.login(userID, passwd);
            if (accountData != null) {
                HttpSession session = req.getSession(true);
                session.setAttribute("uidBean", (Object)userID);
                session.setAttribute("sessionCreationDate", (Object)new Date());
                results = "Ready to Trade";
                this.doHome(ctx, req, resp, userID, results);
                return;
            }
            req.setAttribute("results", (Object)(results + "\nCould not find account for + " + userID));
            Log.log((String)"TradeServletAction.doLogin(...)", (String)("Error finding account for user " + userID + ""), (String)"user entered a bad username or the database is not populated");
        }
        catch (IllegalArgumentException e) {
            req.setAttribute("results", (Object)(results + "illegal argument:" + e.getMessage()));
            Log.error((Throwable)e, (String)"TradeServletAction.doLogin(...)", (String)"illegal argument, information should be in exception string", (String)"treating this as a user error and forwarding on to a new page");
        }
        catch (Exception e) {
            throw new ServletException("TradeServletAction.doLogin(...)Exception logging in user " + userID + "with password" + passwd, (Throwable)e);
        }
        this.requestDispatch(ctx, req, resp, userID, TradeConfig.getPage((int)0));
    }

    void doLogout(ServletContext ctx, HttpServletRequest req, HttpServletResponse resp, String userID) throws ServletException, IOException {
        Object o;
        String results = "";
        try {
            this.tradeServices.logout(userID);
        }
        catch (IllegalArgumentException e) {
            req.setAttribute("results", (Object)(results + "illegal argument:" + e.getMessage()));
            Log.error((Throwable)e, (String)"TradeServletAction.doLogout(...)", (String)"illegal argument, information should be in exception string", (String)"treating this as a user error and forwarding on to a new page");
        }
        catch (Exception e) {
            Log.error((Throwable)e, (String)"TradeServletAction.doLogout(...):", (String)("Error logging out" + userID), (String)"fowarding to an error page");
            throw new ServletException("TradeServletAction.doLogout(...)exception logging out user " + userID, (Throwable)e);
        }
        HttpSession session = req.getSession();
        if (session != null) {
            session.invalidate();
        }
        if ((o = req.getAttribute("TSS-RecreateSessionInLogout")) != null && ((Boolean)o).equals(Boolean.TRUE)) {
            session = req.getSession(true);
        }
        this.requestDispatch(ctx, req, resp, userID, TradeConfig.getPage((int)0));
    }

    void doPortfolio(ServletContext ctx, HttpServletRequest req, HttpServletResponse resp, String userID, String results) throws ServletException, IOException {
        try {
            ArrayList<QuoteDataBean> quoteDataBeans = new ArrayList<QuoteDataBean>();
            Collection holdingDataBeans = this.tradeServices.getHoldings(userID);
            if (holdingDataBeans.size() > 0) {
                for (HoldingDataBean holdingData : holdingDataBeans) {
                    QuoteDataBean quoteData = this.tradeServices.getQuote(holdingData.getQuoteID());
                    quoteDataBeans.add(quoteData);
                }
            } else {
                results = results + ".  Your portfolio is empty.";
            }
            req.setAttribute("results", (Object)results);
            req.setAttribute("holdingDataBeans", (Object)holdingDataBeans);
            req.setAttribute("quoteDataBeans", quoteDataBeans);
            this.requestDispatch(ctx, req, resp, userID, TradeConfig.getPage((int)2));
        }
        catch (IllegalArgumentException e) {
            req.setAttribute("results", (Object)(results + "illegal argument:" + e.getMessage()));
            this.requestDispatch(ctx, req, resp, userID, TradeConfig.getPage((int)2));
            Log.error((Throwable)e, (String)"TradeServletAction.doPortfolio(...)", (String)"illegal argument, information should be in exception string", (String)"user error");
        }
        catch (Exception e) {
            throw new ServletException("TradeServletAction.doPortfolio(...) exception user =" + userID, (Throwable)e);
        }
    }

    void doQuotes(ServletContext ctx, HttpServletRequest req, HttpServletResponse resp, String userID, String symbols) throws ServletException, IOException {
        String results = "";
        this.requestDispatch(ctx, req, resp, userID, TradeConfig.getPage((int)3));
    }

    void doRegister(ServletContext ctx, HttpServletRequest req, HttpServletResponse resp, String userID, String passwd, String cpasswd, String fullname, String ccn, String openBalanceString, String email, String address) throws ServletException, IOException {
        String results = "";
        try {
            if (passwd.equals(cpasswd) && passwd.length() >= 1) {
                AccountDataBean accountData = this.tradeServices.register(userID, passwd, fullname, address, email, ccn, new BigDecimal(openBalanceString));
                if (accountData == null) {
                    results = "Registration operation failed;";
                    System.out.println(results);
                    req.setAttribute("results", (Object)results);
                    this.requestDispatch(ctx, req, resp, userID, TradeConfig.getPage((int)1));
                } else {
                    this.doLogin(ctx, req, resp, userID, passwd);
                    results = "Registration operation succeeded;  Account " + accountData.getAccountID() + " has been created.";
                    req.setAttribute("results", (Object)results);
                }
            } else {
                results = "Registration operation failed, your passwords did not match";
                System.out.println(results);
                req.setAttribute("results", (Object)results);
                this.requestDispatch(ctx, req, resp, userID, TradeConfig.getPage((int)1));
            }
        }
        catch (Exception e) {
            throw new ServletException("TradeServletAction.doRegister(...) exception user =" + userID, (Throwable)e);
        }
    }

    void doSell(ServletContext ctx, HttpServletRequest req, HttpServletResponse resp, String userID, Integer holdingID) throws ServletException, IOException {
        String results = "";
        try {
            OrderDataBean orderData = this.tradeServices.sell(userID, holdingID, TradeConfig.orderProcessingMode);
            req.setAttribute("orderData", (Object)orderData);
            req.setAttribute("results", (Object)results);
        }
        catch (IllegalArgumentException e) {
            Log.error((Throwable)e, (String)"TradeServletAction.doSell(...)", (String)"illegal argument, information should be in exception string", (String)"user error");
        }
        catch (Exception e) {
            throw new ServletException("TradeServletAction.doSell(...) exception selling holding " + holdingID + " for user =" + userID, (Throwable)e);
        }
        this.requestDispatch(ctx, req, resp, userID, TradeConfig.getPage((int)6));
    }

    void doWelcome(ServletContext ctx, HttpServletRequest req, HttpServletResponse resp, String status) throws ServletException, IOException {
        req.setAttribute("results", (Object)status);
        this.requestDispatch(ctx, req, resp, null, TradeConfig.getPage((int)0));
    }

    private void requestDispatch(ServletContext ctx, HttpServletRequest req, HttpServletResponse resp, String userID, String page) throws ServletException, IOException {
        ctx.getRequestDispatcher(page).include((ServletRequest)req, (ServletResponse)resp);
    }
}

