/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.ariestrader.web;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.aries.samples.ariestrader.api.TradeDBManager;
import org.apache.aries.samples.ariestrader.api.TradeServiceUtilities;
import org.apache.aries.samples.ariestrader.api.persistence.RunStatsDataBean;
import org.apache.aries.samples.ariestrader.util.Log;
import org.apache.aries.samples.ariestrader.util.TradeConfig;
import org.apache.aries.samples.ariestrader.web.TradeBuildDB;

public class TradeConfigServlet
extends HttpServlet {
    private static TradeDBManager tradeDBManager = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    void doConfigDisplay(HttpServletRequest req, HttpServletResponse resp, String results) throws Exception {
        TradeConfig currentConfig = new TradeConfig();
        req.setAttribute("tradeConfig", (Object)currentConfig);
        req.setAttribute("status", (Object)results);
        this.getServletConfig().getServletContext().getRequestDispatcher(TradeConfig.getPage((int)7)).include((ServletRequest)req, (ServletResponse)resp);
    }

    void doResetTrade(HttpServletRequest req, HttpServletResponse resp, String results) throws Exception {
        RunStatsDataBean runStatsData = new RunStatsDataBean();
        TradeConfig currentConfig = new TradeConfig();
        if (tradeDBManager == null) {
            tradeDBManager = TradeServiceUtilities.getTradeDBManager();
        }
        try {
            runStatsData = tradeDBManager.resetTrade(false);
            req.setAttribute("runStatsData", (Object)runStatsData);
            req.setAttribute("tradeConfig", (Object)currentConfig);
            results = results + "Trade Reset completed successfully";
            req.setAttribute("status", (Object)results);
        }
        catch (Exception e) {
            results = results + "Trade Reset Error  - see log for details";
            Log.error((Throwable)e, (String)results);
            throw e;
        }
        this.getServletConfig().getServletContext().getRequestDispatcher(TradeConfig.getPage((int)8)).include((ServletRequest)req, (ServletResponse)resp);
    }

    void doConfigUpdate(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String currentConfigStr = "\n\n########## Trade configuration update. Current config:\n\n";
        String runTimeModeStr = req.getParameter("RunTimeMode");
        if (runTimeModeStr != null) {
            try {
                int i = Integer.parseInt(runTimeModeStr);
                if (i >= 0 && i < TradeConfig.runTimeModeNames.length) {
                    TradeConfig.setRunTimeMode((TradeConfig.ModeType)TradeConfig.ModeType.values()[i]);
                }
            }
            catch (Exception e) {
                Log.error((Throwable)e, (String)"TradeConfigServlet.doConfigUpdate(..): minor exception caught", (String)("trying to set runtimemode to " + runTimeModeStr), (String)"reverting to current value");
            }
        }
        currentConfigStr = currentConfigStr + "\t\tRunTimeMode:\t\t" + TradeConfig.runTimeModeNames[TradeConfig.getRunTimeMode().ordinal()] + "\n";
        String jpaLayerStr = req.getParameter("JPALayer");
        if (jpaLayerStr != null) {
            try {
                int i = Integer.parseInt(jpaLayerStr);
                if (i >= 0 && i < TradeConfig.jpaLayerNames.length) {
                    TradeConfig.jpaLayer = i;
                }
            }
            catch (Exception e) {
                Log.error((Throwable)e, (String)"TradeConfigServlet.doConfigUpdate(..): minor exception caught", (String)("trying to set JPALayer to " + jpaLayerStr), (String)"reverting to current value");
            }
        }
        currentConfigStr = currentConfigStr + "\t\tJPALayer:\t\t" + TradeConfig.jpaLayerNames[TradeConfig.jpaLayer] + "\n";
        String orderProcessingModeStr = req.getParameter("OrderProcessingMode");
        if (orderProcessingModeStr != null) {
            try {
                int i = Integer.parseInt(orderProcessingModeStr);
                if (i >= 0 && i < TradeConfig.orderProcessingModeNames.length) {
                    TradeConfig.orderProcessingMode = i;
                }
            }
            catch (Exception e) {
                Log.error((Throwable)e, (String)"TradeConfigServlet.doConfigUpdate(..): minor exception caught", (String)("trying to set orderProcessing to " + orderProcessingModeStr), (String)"reverting to current value");
            }
        }
        currentConfigStr = currentConfigStr + "\t\tOrderProcessingMode:\t" + TradeConfig.orderProcessingModeNames[TradeConfig.orderProcessingMode] + "\n";
        String accessModeStr = req.getParameter("AcessMode");
        if (accessModeStr != null) {
            try {
                int i = Integer.parseInt(accessModeStr);
                if (i >= 0 && i < TradeConfig.accessModeNames.length && i != TradeConfig.getAccessMode()) {
                    TradeConfig.setAccessMode((int)i);
                }
            }
            catch (Exception e) {
                Log.error((Throwable)e, (String)"TradeConfigServlet.doConfigUpdate(..): minor exception caught", (String)("trying to set orderProcessing to " + orderProcessingModeStr), (String)"reverting to current value");
            }
        }
        currentConfigStr = currentConfigStr + "\t\tAcessMode:\t\t" + TradeConfig.accessModeNames[TradeConfig.getAccessMode()] + "\n";
        String workloadMixStr = req.getParameter("WorkloadMix");
        if (workloadMixStr != null) {
            try {
                int i = Integer.parseInt(workloadMixStr);
                if (i >= 0 && i < TradeConfig.workloadMixNames.length) {
                    TradeConfig.workloadMix = i;
                }
            }
            catch (Exception e) {
                Log.error((Throwable)e, (String)"TradeConfigServlet.doConfigUpdate(..): minor exception caught", (String)("trying to set workloadMix to " + workloadMixStr), (String)"reverting to current value");
            }
        }
        currentConfigStr = currentConfigStr + "\t\tWorkload Mix:\t\t" + TradeConfig.workloadMixNames[TradeConfig.workloadMix] + "\n";
        String webInterfaceStr = req.getParameter("WebInterface");
        if (webInterfaceStr != null) {
            try {
                int i = Integer.parseInt(webInterfaceStr);
                if (i >= 0 && i < TradeConfig.webInterfaceNames.length) {
                    TradeConfig.webInterface = i;
                }
            }
            catch (Exception e) {
                Log.error((Throwable)e, (String)"TradeConfigServlet.doConfigUpdate(..): minor exception caught", (String)("trying to set WebInterface to " + webInterfaceStr), (String)"reverting to current value");
            }
        }
        currentConfigStr = currentConfigStr + "\t\tWeb Interface:\t\t" + TradeConfig.webInterfaceNames[TradeConfig.webInterface] + "\n";
        String cachingTypeStr = req.getParameter("CachingType");
        if (cachingTypeStr != null) {
            try {
                int i = Integer.parseInt(cachingTypeStr);
                if (i >= 0 && i < TradeConfig.cachingTypeNames.length) {
                    TradeConfig.cachingType = i;
                }
            }
            catch (Exception e) {
                Log.error((Throwable)e, (String)"TradeConfigServlet.doConfigUpdate(..): minor exception caught", (String)("trying to set CachingType to " + cachingTypeStr), (String)"reverting to current value");
            }
        }
        currentConfigStr = currentConfigStr + "\t\tCachingType:\t\t" + TradeConfig.cachingTypeNames[TradeConfig.cachingType] + "\n";
        String parm = req.getParameter("SOAP_URL");
        if (parm != null && parm.length() > 0) {
            if (!TradeConfig.getSoapURL().equals(parm)) {
                TradeConfig.setSoapURL((String)parm);
            }
        } else {
            TradeConfig.setSoapURL(null);
        }
        if ((parm = req.getParameter("MaxUsers")) != null && parm.length() > 0) {
            try {
                TradeConfig.setMAX_USERS((int)Integer.parseInt(parm));
            }
            catch (Exception e) {
                Log.error((Throwable)e, (String)"TradeConfigServlet.doConfigUpdate(..): minor exception caught", (String)("Setting maxusers, probably error parsing string to int:" + parm), (String)("revertying to current value: " + TradeConfig.getMAX_USERS()));
            }
        }
        if ((parm = req.getParameter("MaxQuotes")) != null && parm.length() > 0) {
            try {
                TradeConfig.setMAX_QUOTES((int)Integer.parseInt(parm));
            }
            catch (Exception e) {
                Log.error((Throwable)e, (String)"TradeConfigServlet: minor exception caught", (String)("trying to set max_quotes, error on parsing int " + parm), (String)("reverting to current value " + TradeConfig.getMAX_QUOTES()));
            }
        }
        currentConfigStr = currentConfigStr + "\t\t#Trade  Users:\t\t" + TradeConfig.getMAX_USERS() + "\n";
        currentConfigStr = currentConfigStr + "\t\t#Trade Quotes:\t\t" + TradeConfig.getMAX_QUOTES() + "\n";
        parm = req.getParameter("marketSummaryInterval");
        if (parm != null && parm.length() > 0) {
            try {
                TradeConfig.setMarketSummaryInterval((int)Integer.parseInt(parm));
            }
            catch (Exception e) {
                Log.error((Throwable)e, (String)"TradeConfigServlet: minor exception caught", (String)("trying to set marketSummaryInterval, error on parsing int " + parm), (String)("reverting to current value " + TradeConfig.getMarketSummaryInterval()));
            }
        }
        currentConfigStr = currentConfigStr + "\t\tMarket Summary Interval:\t\t" + TradeConfig.getMarketSummaryInterval() + "\n";
        parm = req.getParameter("primIterations");
        if (parm != null && parm.length() > 0) {
            try {
                TradeConfig.setPrimIterations((int)Integer.parseInt(parm));
            }
            catch (Exception e) {
                Log.error((Throwable)e, (String)"TradeConfigServlet: minor exception caught", (String)("trying to set primIterations, error on parsing int " + parm), (String)("reverting to current value " + TradeConfig.getPrimIterations()));
            }
        }
        currentConfigStr = currentConfigStr + "\t\tPrimitive Iterations:\t\t" + TradeConfig.getPrimIterations() + "\n";
        String enablePublishQuotePriceChange = req.getParameter("EnablePublishQuotePriceChange");
        if (enablePublishQuotePriceChange != null) {
            TradeConfig.setPublishQuotePriceChange((boolean)true);
        } else {
            TradeConfig.setPublishQuotePriceChange((boolean)false);
        }
        currentConfigStr = currentConfigStr + "\t\tTradeStreamer MDB Enabled:\t" + TradeConfig.getPublishQuotePriceChange() + "\n";
        String enableTrace = req.getParameter("EnableTrace");
        if (enableTrace != null) {
            Log.setTrace((boolean)true);
        } else {
            Log.setTrace((boolean)false);
        }
        String enableActionTrace = req.getParameter("EnableActionTrace");
        if (enableActionTrace != null) {
            Log.setActionTrace((boolean)true);
        } else {
            Log.setActionTrace((boolean)false);
        }
        String enableLongRun = req.getParameter("EnableLongRun");
        if (enableLongRun != null) {
            TradeConfig.setLongRun((boolean)true);
        } else {
            TradeConfig.setLongRun((boolean)false);
        }
        currentConfigStr = currentConfigStr + "\t\tLong Run Enabled:\t\t" + TradeConfig.getLongRun() + "\n";
        System.out.println(currentConfigStr);
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = null;
        String result = "";
        resp.setContentType("text/html");
        try {
            action = req.getParameter("action");
            if (action == null) {
                this.doConfigDisplay(req, resp, result + "<b><br>Current AriesTrader Configuration:</br></b>");
                return;
            }
            if (action.equals("updateConfig")) {
                this.doConfigUpdate(req, resp);
                result = "<B><BR>AriesTrader Configuration Updated</BR></B>";
            } else {
                if (action.equals("resetTrade")) {
                    this.doResetTrade(req, resp, "");
                    return;
                }
                if (action.equals("buildDB")) {
                    resp.setContentType("text/html");
                    new TradeBuildDB(resp.getWriter(), false);
                    result = "AriesTrader Database Built - " + TradeConfig.getMAX_USERS() + "users created";
                } else if (action.equals("buildDBTables")) {
                    resp.setContentType("text/html");
                    new TradeBuildDB(resp.getWriter(), true);
                }
            }
            this.doConfigDisplay(req, resp, result + "Current AriesTrader Configuration:");
        }
        catch (Exception e) {
            Log.error((Throwable)e, (String)"TradeConfigServlet.service(...)", (String)("Exception trying to perform action=" + action));
            resp.sendError(500, "TradeConfigServlet.service(...)Exception trying to perform action=" + action + "\nException details: " + e.toString());
        }
    }
}

