/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.ariestrader.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import org.apache.aries.samples.ariestrader.api.TradeDBManager;
import org.apache.aries.samples.ariestrader.api.TradeServiceUtilities;
import org.apache.aries.samples.ariestrader.api.TradeServices;
import org.apache.aries.samples.ariestrader.api.TradeServicesManager;
import org.apache.aries.samples.ariestrader.api.persistence.AccountDataBean;
import org.apache.aries.samples.ariestrader.util.Log;
import org.apache.aries.samples.ariestrader.util.TradeConfig;

public class TradeBuildDB {
    private static TradeServicesManager tradeServicesManager = null;
    private static TradeDBManager tradeDBManager = null;

    public TradeBuildDB() throws Exception {
        this(new PrintWriter(System.out), false);
    }

    public TradeBuildDB(PrintWriter out, boolean createTables) throws Exception {
        String symbol;
        int i;
        int errorCount = 0;
        if (tradeServicesManager == null) {
            tradeServicesManager = TradeServiceUtilities.getTradeServicesManager();
        }
        TradeServices tradeServices = tradeServicesManager.getTradeServices();
        if (tradeDBManager == null) {
            tradeDBManager = TradeServiceUtilities.getTradeDBManager();
        }
        out.println("<HEAD><BR><EM> TradeBuildDB: Building AriesTrader Database...</EM><BR>This operation will take several minutes. Please wait...</HEAD>");
        out.println("<BODY>");
        if (createTables) {
            boolean success = false;
            String dbProductName = null;
            String fileLocation = null;
            URL ddlFile = null;
            Object[] sqlBuffer = null;
            try {
                dbProductName = tradeDBManager.checkDBProductName();
            }
            catch (Exception e) {
                Log.error((Throwable)e, (String)"TradeBuildDB: Unable to check DB Product name");
            }
            if (dbProductName == null) {
                out.println("<BR>TradeBuildDB: **** Unable to check DB Product name,please check Database/AppServer configuration and retry ****</BR></BODY>");
                return;
            }
            try {
                out.println("<BR>TradeBuildDB: **** Database Product detected: " + dbProductName + " ****</BR>");
                if (dbProductName.startsWith("DB2/")) {
                    fileLocation = File.separatorChar + "dbscripts" + File.separatorChar + "db2" + File.separatorChar + "Table.ddl";
                } else if (dbProductName.startsWith("Apache Derby")) {
                    fileLocation = File.separatorChar + "dbscripts" + File.separatorChar + "derby" + File.separatorChar + "Table.ddl";
                } else if (dbProductName.startsWith("Oracle")) {
                    fileLocation = File.separatorChar + "dbscripts" + File.separatorChar + "oracle" + File.separatorChar + "Table.ddl";
                } else {
                    fileLocation = File.separatorChar + "dbscripts" + File.separatorChar + "other" + File.separatorChar + "Table.ddl";
                    out.println("<BR>TradeBuildDB: **** This Database is unsupported/untested use at your own risk ****</BR>");
                }
                ddlFile = this.getClass().getResource(fileLocation);
            }
            catch (Exception e) {
                Log.error((Throwable)e, (String)"TradeBuildDB: Unable to locate DDL file for the specified database");
                out.println("<BR>TradeBuildDB: **** Unable to locate DDL file for the specified database ****</BR></BODY>");
                return;
            }
            try {
                sqlBuffer = this.parseDDLToBuffer(ddlFile);
            }
            catch (Exception e) {
                Log.error((Throwable)e, (String)"TradeBuildDB: Unable to parse DDL file");
                out.println("<BR>TradeBuildDB: **** Unable to parse DDL file for the specified database ****</BR></BODY>");
                return;
            }
            if (sqlBuffer == null || sqlBuffer.length == 0) {
                out.println("<BR>TradeBuildDB: **** Parsing DDL file returned empty buffer, please check that a valid DB specific DDL file is available and retry ****</BR></BODY>");
                return;
            }
            out.println("<BR>TradeBuildDB: **** Dropping and Recreating the AriesTrader tables... ****</BR>");
            try {
                success = tradeDBManager.recreateDBTables(sqlBuffer, out);
            }
            catch (Exception e) {
                Log.error((Throwable)e, (String)"TradeBuildDB: Unable to drop and recreate AriesTrader Db Tables, please check for database consistency before continuing");
            }
            if (!success) {
                out.println("<BR>TradeBuildDB: **** Unable to drop and recreate AriesTrader Db Tables, please check for database consistency before continuing ****</BR></BODY>");
                return;
            }
            out.println("<BR>TradeBuildDB: **** AriesTrader tables successfully created! ****</BR><BR><b> Please Stop and Re-start your AriesTrader application (or your application server) and then use the \"Repopulate AriesTrader Database\" link to populate your database.</b></BR><BR><BR></BODY>");
            return;
        }
        out.println("<BR>TradeBuildDB: **** Creating " + TradeConfig.getMAX_QUOTES() + " Quotes ****</BR>");
        try {
            tradeDBManager.resetTrade(true);
        }
        catch (Exception e) {
            Log.error((Throwable)e, (String)"TradeBuildDB: Unable to delete Trade users (uid:0, uid:1, ...) and Trade Quotes (s:0, s:1, ...)");
        }
        for (i = 0; i < TradeConfig.getMAX_QUOTES(); ++i) {
            symbol = "s:" + i;
            String companyName = "S" + i + " Incorporated";
            try {
                tradeServices.createQuote(symbol, companyName, new BigDecimal(TradeConfig.rndPrice()));
                if (i % 10 != 0) continue;
                out.print("....." + symbol);
                if (i % 100 != 0) continue;
                out.println(" -<BR>");
                out.flush();
                continue;
            }
            catch (Exception e) {
                if (errorCount++ < 10) continue;
                String error = "Populate Trade DB aborting after 10 create quote errors. Check the EJB datasource configuration. Check the log for details <BR><BR> Exception is: <BR> " + e.toString();
                Log.error((Throwable)e, (String)error);
                throw e;
            }
        }
        out.println("<BR>");
        out.println("<BR>**** Registering " + TradeConfig.getMAX_USERS() + " Users **** ");
        errorCount = 0;
        for (i = 0; i < TradeConfig.getMAX_USERS(); ++i) {
            String userID = "uid:" + i;
            String fullname = TradeConfig.rndFullName();
            String email = TradeConfig.rndEmail((String)userID);
            String address = TradeConfig.rndAddress();
            String creditcard = TradeConfig.rndCreditCard();
            double initialBalance = (double)TradeConfig.rndInt((int)100000) + 200000.0;
            if (i == 0) {
                initialBalance = 1000000.0;
            }
            try {
                AccountDataBean accountData = tradeServices.register(userID, "xxx", fullname, address, email, creditcard, new BigDecimal(initialBalance));
                if (accountData != null) {
                    if (i % 50 == 0) {
                        out.print("<BR>Account# " + accountData.getAccountID() + " userID=" + userID);
                    }
                    int holdings = TradeConfig.rndInt((int)(TradeConfig.getMAX_HOLDINGS() + 1));
                    double quantity = 0.0;
                    for (int j = 0; j < holdings; ++j) {
                        symbol = TradeConfig.rndSymbol();
                        quantity = TradeConfig.rndQuantity();
                        tradeServices.buy(userID, symbol, quantity, TradeConfig.orderProcessingMode);
                    }
                    if (i % 50 != 0) continue;
                    out.println(" has " + holdings + " holdings.");
                    out.flush();
                    continue;
                }
                out.println("<BR>UID " + userID + " already registered.</BR>");
                out.flush();
                continue;
            }
            catch (Exception e) {
                if (errorCount++ < 10) continue;
                String error = "Populate Trade DB aborting after 10 user registration errors. Check the log for details. <BR><BR> Exception is: <BR>" + e.toString();
                Log.error((Throwable)e, (String)error);
                throw e;
            }
        }
        out.println("</BODY>");
    }

    public Object[] parseDDLToBuffer(URL ddlFile) throws Exception {
        BufferedReader br = null;
        InputStreamReader ir = null;
        ArrayList<String> sqlBuffer = new ArrayList<String>(30);
        try {
            String s;
            if (Log.doTrace()) {
                Log.traceEnter((String)("TradeBuildDB:parseDDLToBuffer - " + ddlFile));
            }
            ir = new InputStreamReader(ddlFile.openStream());
            br = new BufferedReader(ir);
            String sql = new String();
            while ((s = br.readLine()) != null) {
                if ((s = s.trim()).length() == 0 || s.charAt(0) == '#') continue;
                sql = sql + " " + s;
                if (!s.endsWith(";")) continue;
                sql = sql.replace(';', ' ');
                sqlBuffer.add(sql);
                sql = "";
            }
        }
        catch (IOException ex) {
            Log.error((String)("TradeBuildDB:parseDDLToBuffer Exeception during open/read of File: " + ddlFile), (Throwable)ex);
            throw ex;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    Log.error((String)"TradeBuildDB:parseDDLToBuffer Failed to close BufferedReader", (Throwable)ex);
                }
            }
        }
        return sqlBuffer.toArray();
    }

    public static void main(String[] args) throws Exception {
        new TradeBuildDB();
    }
}

