/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.ariestrader.entities;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.aries.samples.ariestrader.api.persistence.AccountDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.AccountProfileDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.HoldingDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.OrderDataBean;
import org.apache.aries.samples.ariestrader.entities.AccountProfileDataBeanImpl;
import org.apache.aries.samples.ariestrader.entities.HoldingDataBeanImpl;
import org.apache.aries.samples.ariestrader.entities.OrderDataBeanImpl;
import org.apache.aries.samples.ariestrader.util.Log;
import org.apache.aries.samples.ariestrader.util.TradeConfig;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.InternalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="accountejb")
@Table(name="accountejb")
@NamedQueries(value={@NamedQuery(name="accountejb.findByCreationdate", query="SELECT a FROM accountejb a WHERE a.creationDate = :creationdate"), @NamedQuery(name="accountejb.findByOpenbalance", query="SELECT a FROM accountejb a WHERE a.openBalance = :openbalance"), @NamedQuery(name="accountejb.findByLogoutcount", query="SELECT a FROM accountejb a WHERE a.logoutCount = :logoutcount"), @NamedQuery(name="accountejb.findByBalance", query="SELECT a FROM accountejb a WHERE a.balance = :balance"), @NamedQuery(name="accountejb.findByAccountid", query="SELECT a FROM accountejb a WHERE a.accountID = :accountid"), @NamedQuery(name="accountejb.findByAccountid_eager", query="SELECT a FROM accountejb a LEFT JOIN FETCH a.profile WHERE a.accountID = :accountid"), @NamedQuery(name="accountejb.findByAccountid_eagerholdings", query="SELECT a FROM accountejb a LEFT JOIN FETCH a.holdings WHERE a.accountID = :accountid"), @NamedQuery(name="accountejb.findByLastlogin", query="SELECT a FROM accountejb a WHERE a.lastLogin = :lastlogin"), @NamedQuery(name="accountejb.findByLogincount", query="SELECT a FROM accountejb a WHERE a.loginCount = :logincount")})
public class AccountDataBeanImpl
implements AccountDataBean,
Serializable,
PersistenceCapable {
    @TableGenerator(name="accountIdGen", table="KEYGENEJB", pkColumnName="KEYNAME", valueColumnName="KEYVAL", pkColumnValue="account", allocationSize=1000)
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="accountIdGen")
    @Column(name="ACCOUNTID", nullable=false)
    private Integer accountID;
    @Column(name="LOGINCOUNT", nullable=false)
    private int loginCount;
    @Column(name="LOGOUTCOUNT", nullable=false)
    private int logoutCount;
    @Column(name="LASTLOGIN")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastLogin;
    @Column(name="CREATIONDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationDate;
    @Column(name="BALANCE")
    private BigDecimal balance;
    @Column(name="OPENBALANCE")
    private BigDecimal openBalance;
    @OneToMany(mappedBy="account", fetch=FetchType.LAZY)
    private Collection<OrderDataBeanImpl> orders;
    @OneToMany(mappedBy="account", fetch=FetchType.LAZY)
    private Collection<HoldingDataBeanImpl> holdings;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROFILE_USERID", columnDefinition="VARCHAR(255)")
    private AccountProfileDataBeanImpl profile;
    @Transient
    private String profileID;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$math$BigDecimal;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Ljava$util$Collection;
    static /* synthetic */ Class class$Lorg$apache$aries$samples$ariestrader$entities$AccountProfileDataBeanImpl;
    static /* synthetic */ Class class$Lorg$apache$aries$samples$ariestrader$entities$AccountDataBeanImpl;
    private transient Object pcDetachedState;
    private static final long serialVersionUID;

    public AccountDataBeanImpl() {
    }

    public AccountDataBeanImpl(Integer accountID, int loginCount, int logoutCount, Date lastLogin, Date creationDate, BigDecimal balance, BigDecimal openBalance, String profileID) {
        this.setAccountID(accountID);
        this.setLoginCount(loginCount);
        this.setLogoutCount(logoutCount);
        this.setLastLogin(lastLogin);
        this.setCreationDate(creationDate);
        this.setBalance(balance);
        this.setOpenBalance(openBalance);
        this.setProfileID(profileID);
    }

    public AccountDataBeanImpl(int loginCount, int logoutCount, Date lastLogin, Date creationDate, BigDecimal balance, BigDecimal openBalance, String profileID) {
        this.setLoginCount(loginCount);
        this.setLogoutCount(logoutCount);
        this.setLastLogin(lastLogin);
        this.setCreationDate(creationDate);
        this.setBalance(balance);
        this.setOpenBalance(openBalance);
        this.setProfileID(profileID);
    }

    public static AccountDataBean getRandomInstance() {
        return new AccountDataBeanImpl(new Integer(TradeConfig.rndInt((int)100000)), TradeConfig.rndInt((int)10000), TradeConfig.rndInt((int)10000), new Date(), new Date(TradeConfig.rndInt((int)Integer.MAX_VALUE)), TradeConfig.rndBigDecimal((float)1000000.0f), TradeConfig.rndBigDecimal((float)1000000.0f), TradeConfig.rndUserID());
    }

    public String toString() {
        return "\n\tAccount Data for account: " + this.getAccountID() + "\n\t\t   loginCount:" + this.getLoginCount() + "\n\t\t  logoutCount:" + this.getLogoutCount() + "\n\t\t    lastLogin:" + this.getLastLogin() + "\n\t\t creationDate:" + this.getCreationDate() + "\n\t\t      balance:" + this.getBalance() + "\n\t\t  openBalance:" + this.getOpenBalance() + "\n\t\t    profileID:" + this.getProfileID();
    }

    public String toHTML() {
        return "<BR>Account Data for account: <B>" + this.getAccountID() + "</B>" + "<LI>   loginCount:" + this.getLoginCount() + "</LI>" + "<LI>  logoutCount:" + this.getLogoutCount() + "</LI>" + "<LI>    lastLogin:" + this.getLastLogin() + "</LI>" + "<LI> creationDate:" + this.getCreationDate() + "</LI>" + "<LI>      balance:" + this.getBalance() + "</LI>" + "<LI>  openBalance:" + this.getOpenBalance() + "</LI>" + "<LI>    profileID:" + this.getProfileID() + "</LI>";
    }

    public void print() {
        Log.log((String)this.toString());
    }

    public Integer getAccountID() {
        return AccountDataBeanImpl.pcGetaccountID(this);
    }

    public void setAccountID(Integer accountID) {
        AccountDataBeanImpl.pcSetaccountID(this, accountID);
    }

    public int getLoginCount() {
        return AccountDataBeanImpl.pcGetloginCount(this);
    }

    public void setLoginCount(int loginCount) {
        AccountDataBeanImpl.pcSetloginCount(this, loginCount);
    }

    public int getLogoutCount() {
        return AccountDataBeanImpl.pcGetlogoutCount(this);
    }

    public void setLogoutCount(int logoutCount) {
        AccountDataBeanImpl.pcSetlogoutCount(this, logoutCount);
    }

    public Date getLastLogin() {
        return AccountDataBeanImpl.pcGetlastLogin(this);
    }

    public void setLastLogin(Date lastLogin) {
        AccountDataBeanImpl.pcSetlastLogin(this, lastLogin);
    }

    public Date getCreationDate() {
        return AccountDataBeanImpl.pcGetcreationDate(this);
    }

    public void setCreationDate(Date creationDate) {
        AccountDataBeanImpl.pcSetcreationDate(this, creationDate);
    }

    public BigDecimal getBalance() {
        return AccountDataBeanImpl.pcGetbalance(this);
    }

    public void setBalance(BigDecimal balance) {
        AccountDataBeanImpl.pcSetbalance(this, balance);
    }

    public BigDecimal getOpenBalance() {
        return AccountDataBeanImpl.pcGetopenBalance(this);
    }

    public void setOpenBalance(BigDecimal openBalance) {
        AccountDataBeanImpl.pcSetopenBalance(this, openBalance);
    }

    public String getProfileID() {
        return this.profileID;
    }

    public void setProfileID(String profileID) {
        this.profileID = profileID;
    }

    public Collection<OrderDataBean> getOrders() {
        ArrayList<OrderDataBean> orderDataBeans = new ArrayList<OrderDataBean>();
        for (OrderDataBeanImpl o : AccountDataBeanImpl.pcGetorders(this)) {
            orderDataBeans.add(o);
        }
        return orderDataBeans;
    }

    public void setOrders(Collection<OrderDataBeanImpl> orders) {
        AccountDataBeanImpl.pcSetorders(this, orders);
    }

    public Collection<HoldingDataBean> getHoldings() {
        ArrayList<HoldingDataBean> holdingDataBeans = new ArrayList<HoldingDataBean>();
        for (HoldingDataBeanImpl h : AccountDataBeanImpl.pcGetholdings(this)) {
            holdingDataBeans.add(h);
        }
        return holdingDataBeans;
    }

    public void setHoldings(Collection<HoldingDataBeanImpl> holdings) {
        AccountDataBeanImpl.pcSetholdings(this, holdings);
    }

    public AccountProfileDataBean getProfile() {
        return AccountDataBeanImpl.pcGetprofile(this);
    }

    public void setProfile(AccountProfileDataBean profile) {
        AccountDataBeanImpl.pcSetprofile(this, (AccountProfileDataBeanImpl)profile);
    }

    public void login(String password) {
        AccountProfileDataBean profile = this.getProfile();
        if (profile == null || !profile.getPassword().equals(password)) {
            String error = "AccountBean:Login failure for account: " + this.getAccountID() + (profile == null ? "null AccountProfile" : "\n\tIncorrect password-->" + profile.getUserID() + ":" + profile.getPassword());
            throw new RuntimeException(error);
        }
        this.setLastLogin(new Timestamp(System.currentTimeMillis()));
        this.setLoginCount(this.getLoginCount() + 1);
    }

    public void logout() {
        this.setLogoutCount(this.getLogoutCount() + 1);
    }

    public int hashCode() {
        int hash = 0;
        return hash += AccountDataBeanImpl.pcGetaccountID(this) != null ? AccountDataBeanImpl.pcGetaccountID(this).hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AccountDataBeanImpl)) {
            return false;
        }
        AccountDataBeanImpl other = (AccountDataBeanImpl)object;
        return AccountDataBeanImpl.pcGetaccountID(this) == AccountDataBeanImpl.pcGetaccountID(other) || AccountDataBeanImpl.pcGetaccountID(this) != null && AccountDataBeanImpl.pcGetaccountID(this).equals(AccountDataBeanImpl.pcGetaccountID(other));
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        serialVersionUID = -128835729491116972L;
        pcFieldNames = new String[]{"accountID", "balance", "creationDate", "holdings", "lastLogin", "loginCount", "logoutCount", "openBalance", "orders", "profile"};
        Class[] classArray = new Class[10];
        Class clazz = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = AccountDataBeanImpl.class$("java.lang.Integer"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$math$BigDecimal != null ? class$Ljava$math$BigDecimal : (class$Ljava$math$BigDecimal = AccountDataBeanImpl.class$("java.math.BigDecimal"));
        classArray[1] = clazz2;
        Class clazz3 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = AccountDataBeanImpl.class$("java.util.Date"));
        classArray[2] = clazz3;
        Class clazz4 = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = AccountDataBeanImpl.class$("java.util.Collection"));
        classArray[3] = clazz4;
        classArray[4] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = AccountDataBeanImpl.class$("java.util.Date"));
        classArray[5] = Integer.TYPE;
        classArray[6] = Integer.TYPE;
        classArray[7] = class$Ljava$math$BigDecimal != null ? class$Ljava$math$BigDecimal : (class$Ljava$math$BigDecimal = AccountDataBeanImpl.class$("java.math.BigDecimal"));
        classArray[8] = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = AccountDataBeanImpl.class$("java.util.Collection"));
        Class clazz5 = class$Lorg$apache$aries$samples$ariestrader$entities$AccountProfileDataBeanImpl != null ? class$Lorg$apache$aries$samples$ariestrader$entities$AccountProfileDataBeanImpl : (class$Lorg$apache$aries$samples$ariestrader$entities$AccountProfileDataBeanImpl = AccountDataBeanImpl.class$("org.apache.aries.samples.ariestrader.entities.AccountProfileDataBeanImpl"));
        classArray[9] = clazz5;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 5, 26, 26, 26, 26, 5, 21};
        Class clazz6 = class$Lorg$apache$aries$samples$ariestrader$entities$AccountDataBeanImpl != null ? class$Lorg$apache$aries$samples$ariestrader$entities$AccountDataBeanImpl : (class$Lorg$apache$aries$samples$ariestrader$entities$AccountDataBeanImpl = AccountDataBeanImpl.class$("org.apache.aries.samples.ariestrader.entities.AccountDataBeanImpl"));
        PCRegistry.register((Class)clazz6, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"accountejb", (PersistenceCapable)new AccountDataBeanImpl());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.accountID = null;
        this.balance = null;
        this.creationDate = null;
        this.holdings = null;
        this.lastLogin = null;
        this.loginCount = 0;
        this.logoutCount = 0;
        this.openBalance = null;
        this.orders = null;
        this.profile = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        AccountDataBeanImpl accountDataBeanImpl = new AccountDataBeanImpl();
        if (bl) {
            accountDataBeanImpl.pcClearFields();
        }
        accountDataBeanImpl.pcStateManager = stateManager;
        accountDataBeanImpl.pcCopyKeyFieldsFromObjectId(object);
        return accountDataBeanImpl;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        AccountDataBeanImpl accountDataBeanImpl = new AccountDataBeanImpl();
        if (bl) {
            accountDataBeanImpl.pcClearFields();
        }
        accountDataBeanImpl.pcStateManager = stateManager;
        return accountDataBeanImpl;
    }

    protected static int pcGetManagedFieldCount() {
        return 10;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.accountID = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.balance = (BigDecimal)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.creationDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.holdings = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.lastLogin = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.loginCount = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.logoutCount = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.openBalance = (BigDecimal)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.orders = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.profile = (AccountProfileDataBeanImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.accountID);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.balance);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.creationDate);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.holdings);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastLogin);
                return;
            }
            case 5: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.loginCount);
                return;
            }
            case 6: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.logoutCount);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.openBalance);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.orders);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.profile);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(AccountDataBeanImpl accountDataBeanImpl, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.accountID = accountDataBeanImpl.accountID;
                return;
            }
            case 1: {
                this.balance = accountDataBeanImpl.balance;
                return;
            }
            case 2: {
                this.creationDate = accountDataBeanImpl.creationDate;
                return;
            }
            case 3: {
                this.holdings = accountDataBeanImpl.holdings;
                return;
            }
            case 4: {
                this.lastLogin = accountDataBeanImpl.lastLogin;
                return;
            }
            case 5: {
                this.loginCount = accountDataBeanImpl.loginCount;
                return;
            }
            case 6: {
                this.logoutCount = accountDataBeanImpl.logoutCount;
                return;
            }
            case 7: {
                this.openBalance = accountDataBeanImpl.openBalance;
                return;
            }
            case 8: {
                this.orders = accountDataBeanImpl.orders;
                return;
            }
            case 9: {
                this.profile = accountDataBeanImpl.profile;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        AccountDataBeanImpl accountDataBeanImpl = (AccountDataBeanImpl)object;
        if (accountDataBeanImpl.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(accountDataBeanImpl, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        IntId intId = (IntId)object;
        fieldConsumer.storeObjectField(0 + pcInheritedFieldCount, (Object)new Integer(intId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        IntId intId = (IntId)object;
        this.accountID = new Integer(intId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$aries$samples$ariestrader$entities$AccountDataBeanImpl != null ? class$Lorg$apache$aries$samples$ariestrader$entities$AccountDataBeanImpl : (class$Lorg$apache$aries$samples$ariestrader$entities$AccountDataBeanImpl = AccountDataBeanImpl.class$("org.apache.aries.samples.ariestrader.entities.AccountDataBeanImpl"));
        return new IntId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$aries$samples$ariestrader$entities$AccountDataBeanImpl != null ? class$Lorg$apache$aries$samples$ariestrader$entities$AccountDataBeanImpl : (class$Lorg$apache$aries$samples$ariestrader$entities$AccountDataBeanImpl = AccountDataBeanImpl.class$("org.apache.aries.samples.ariestrader.entities.AccountDataBeanImpl"));
        return new IntId(clazz, this.accountID);
    }

    private static final Integer pcGetaccountID(AccountDataBeanImpl accountDataBeanImpl) {
        if (accountDataBeanImpl.pcStateManager == null) {
            return accountDataBeanImpl.accountID;
        }
        int n = pcInheritedFieldCount + 0;
        accountDataBeanImpl.pcStateManager.accessingField(n);
        return accountDataBeanImpl.accountID;
    }

    private static final void pcSetaccountID(AccountDataBeanImpl accountDataBeanImpl, Integer n) {
        if (accountDataBeanImpl.pcStateManager == null) {
            accountDataBeanImpl.accountID = n;
            return;
        }
        accountDataBeanImpl.pcStateManager.settingObjectField((PersistenceCapable)accountDataBeanImpl, pcInheritedFieldCount + 0, (Object)accountDataBeanImpl.accountID, (Object)n, 0);
    }

    private static final BigDecimal pcGetbalance(AccountDataBeanImpl accountDataBeanImpl) {
        if (accountDataBeanImpl.pcStateManager == null) {
            return accountDataBeanImpl.balance;
        }
        int n = pcInheritedFieldCount + 1;
        accountDataBeanImpl.pcStateManager.accessingField(n);
        return accountDataBeanImpl.balance;
    }

    private static final void pcSetbalance(AccountDataBeanImpl accountDataBeanImpl, BigDecimal bigDecimal) {
        if (accountDataBeanImpl.pcStateManager == null) {
            accountDataBeanImpl.balance = bigDecimal;
            return;
        }
        accountDataBeanImpl.pcStateManager.settingObjectField((PersistenceCapable)accountDataBeanImpl, pcInheritedFieldCount + 1, (Object)accountDataBeanImpl.balance, (Object)bigDecimal, 0);
    }

    private static final Date pcGetcreationDate(AccountDataBeanImpl accountDataBeanImpl) {
        if (accountDataBeanImpl.pcStateManager == null) {
            return accountDataBeanImpl.creationDate;
        }
        int n = pcInheritedFieldCount + 2;
        accountDataBeanImpl.pcStateManager.accessingField(n);
        return accountDataBeanImpl.creationDate;
    }

    private static final void pcSetcreationDate(AccountDataBeanImpl accountDataBeanImpl, Date date) {
        if (accountDataBeanImpl.pcStateManager == null) {
            accountDataBeanImpl.creationDate = date;
            return;
        }
        accountDataBeanImpl.pcStateManager.settingObjectField((PersistenceCapable)accountDataBeanImpl, pcInheritedFieldCount + 2, (Object)accountDataBeanImpl.creationDate, (Object)date, 0);
    }

    private static final Collection pcGetholdings(AccountDataBeanImpl accountDataBeanImpl) {
        if (accountDataBeanImpl.pcStateManager == null) {
            return accountDataBeanImpl.holdings;
        }
        int n = pcInheritedFieldCount + 3;
        accountDataBeanImpl.pcStateManager.accessingField(n);
        return accountDataBeanImpl.holdings;
    }

    private static final void pcSetholdings(AccountDataBeanImpl accountDataBeanImpl, Collection collection) {
        if (accountDataBeanImpl.pcStateManager == null) {
            accountDataBeanImpl.holdings = collection;
            return;
        }
        accountDataBeanImpl.pcStateManager.settingObjectField((PersistenceCapable)accountDataBeanImpl, pcInheritedFieldCount + 3, accountDataBeanImpl.holdings, (Object)collection, 0);
    }

    private static final Date pcGetlastLogin(AccountDataBeanImpl accountDataBeanImpl) {
        if (accountDataBeanImpl.pcStateManager == null) {
            return accountDataBeanImpl.lastLogin;
        }
        int n = pcInheritedFieldCount + 4;
        accountDataBeanImpl.pcStateManager.accessingField(n);
        return accountDataBeanImpl.lastLogin;
    }

    private static final void pcSetlastLogin(AccountDataBeanImpl accountDataBeanImpl, Date date) {
        if (accountDataBeanImpl.pcStateManager == null) {
            accountDataBeanImpl.lastLogin = date;
            return;
        }
        accountDataBeanImpl.pcStateManager.settingObjectField((PersistenceCapable)accountDataBeanImpl, pcInheritedFieldCount + 4, (Object)accountDataBeanImpl.lastLogin, (Object)date, 0);
    }

    private static final int pcGetloginCount(AccountDataBeanImpl accountDataBeanImpl) {
        if (accountDataBeanImpl.pcStateManager == null) {
            return accountDataBeanImpl.loginCount;
        }
        int n = pcInheritedFieldCount + 5;
        accountDataBeanImpl.pcStateManager.accessingField(n);
        return accountDataBeanImpl.loginCount;
    }

    private static final void pcSetloginCount(AccountDataBeanImpl accountDataBeanImpl, int n) {
        if (accountDataBeanImpl.pcStateManager == null) {
            accountDataBeanImpl.loginCount = n;
            return;
        }
        accountDataBeanImpl.pcStateManager.settingIntField((PersistenceCapable)accountDataBeanImpl, pcInheritedFieldCount + 5, accountDataBeanImpl.loginCount, n, 0);
    }

    private static final int pcGetlogoutCount(AccountDataBeanImpl accountDataBeanImpl) {
        if (accountDataBeanImpl.pcStateManager == null) {
            return accountDataBeanImpl.logoutCount;
        }
        int n = pcInheritedFieldCount + 6;
        accountDataBeanImpl.pcStateManager.accessingField(n);
        return accountDataBeanImpl.logoutCount;
    }

    private static final void pcSetlogoutCount(AccountDataBeanImpl accountDataBeanImpl, int n) {
        if (accountDataBeanImpl.pcStateManager == null) {
            accountDataBeanImpl.logoutCount = n;
            return;
        }
        accountDataBeanImpl.pcStateManager.settingIntField((PersistenceCapable)accountDataBeanImpl, pcInheritedFieldCount + 6, accountDataBeanImpl.logoutCount, n, 0);
    }

    private static final BigDecimal pcGetopenBalance(AccountDataBeanImpl accountDataBeanImpl) {
        if (accountDataBeanImpl.pcStateManager == null) {
            return accountDataBeanImpl.openBalance;
        }
        int n = pcInheritedFieldCount + 7;
        accountDataBeanImpl.pcStateManager.accessingField(n);
        return accountDataBeanImpl.openBalance;
    }

    private static final void pcSetopenBalance(AccountDataBeanImpl accountDataBeanImpl, BigDecimal bigDecimal) {
        if (accountDataBeanImpl.pcStateManager == null) {
            accountDataBeanImpl.openBalance = bigDecimal;
            return;
        }
        accountDataBeanImpl.pcStateManager.settingObjectField((PersistenceCapable)accountDataBeanImpl, pcInheritedFieldCount + 7, (Object)accountDataBeanImpl.openBalance, (Object)bigDecimal, 0);
    }

    private static final Collection pcGetorders(AccountDataBeanImpl accountDataBeanImpl) {
        if (accountDataBeanImpl.pcStateManager == null) {
            return accountDataBeanImpl.orders;
        }
        int n = pcInheritedFieldCount + 8;
        accountDataBeanImpl.pcStateManager.accessingField(n);
        return accountDataBeanImpl.orders;
    }

    private static final void pcSetorders(AccountDataBeanImpl accountDataBeanImpl, Collection collection) {
        if (accountDataBeanImpl.pcStateManager == null) {
            accountDataBeanImpl.orders = collection;
            return;
        }
        accountDataBeanImpl.pcStateManager.settingObjectField((PersistenceCapable)accountDataBeanImpl, pcInheritedFieldCount + 8, accountDataBeanImpl.orders, (Object)collection, 0);
    }

    private static final AccountProfileDataBeanImpl pcGetprofile(AccountDataBeanImpl accountDataBeanImpl) {
        if (accountDataBeanImpl.pcStateManager == null) {
            return accountDataBeanImpl.profile;
        }
        int n = pcInheritedFieldCount + 9;
        accountDataBeanImpl.pcStateManager.accessingField(n);
        return accountDataBeanImpl.profile;
    }

    private static final void pcSetprofile(AccountDataBeanImpl accountDataBeanImpl, AccountProfileDataBeanImpl accountProfileDataBeanImpl) {
        if (accountDataBeanImpl.pcStateManager == null) {
            accountDataBeanImpl.profile = accountProfileDataBeanImpl;
            return;
        }
        accountDataBeanImpl.pcStateManager.settingObjectField((PersistenceCapable)accountDataBeanImpl, pcInheritedFieldCount + 9, (Object)accountDataBeanImpl.profile, (Object)accountProfileDataBeanImpl, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.accountID != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

