/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.ariestrader.entities;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.aries.samples.ariestrader.api.persistence.AccountDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.HoldingDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.OrderDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.QuoteDataBean;
import org.apache.aries.samples.ariestrader.entities.AccountDataBeanImpl;
import org.apache.aries.samples.ariestrader.entities.HoldingDataBeanImpl;
import org.apache.aries.samples.ariestrader.entities.QuoteDataBeanImpl;
import org.apache.aries.samples.ariestrader.util.Log;
import org.apache.aries.samples.ariestrader.util.TradeConfig;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.InternalException;

@Entity(name="orderejb")
@Table(name="orderejb")
@NamedQueries(value={@NamedQuery(name="orderejb.findByOrderfee", query="SELECT o FROM orderejb o WHERE o.orderFee = :orderfee"), @NamedQuery(name="orderejb.findByCompletiondate", query="SELECT o FROM orderejb o WHERE o.completionDate = :completiondate"), @NamedQuery(name="orderejb.findByOrdertype", query="SELECT o FROM orderejb o WHERE o.orderType = :ordertype"), @NamedQuery(name="orderejb.findByOrderstatus", query="SELECT o FROM orderejb o WHERE o.orderStatus = :orderstatus"), @NamedQuery(name="orderejb.findByPrice", query="SELECT o FROM orderejb o WHERE o.price = :price"), @NamedQuery(name="orderejb.findByQuantity", query="SELECT o FROM orderejb o WHERE o.quantity = :quantity"), @NamedQuery(name="orderejb.findByOpendate", query="SELECT o FROM orderejb o WHERE o.openDate = :opendate"), @NamedQuery(name="orderejb.findByOrderid", query="SELECT o FROM orderejb o WHERE o.orderID = :orderid"), @NamedQuery(name="orderejb.findByAccountAccountid", query="SELECT o FROM orderejb o WHERE o.account.accountID = :accountAccountid"), @NamedQuery(name="orderejb.findByQuoteSymbol", query="SELECT o FROM orderejb o WHERE o.quote.symbol = :quoteSymbol"), @NamedQuery(name="orderejb.findByHoldingHoldingid", query="SELECT o FROM orderejb o WHERE o.holding.holdingID = :holdingHoldingid"), @NamedQuery(name="orderejb.closedOrders", query="SELECT o FROM orderejb o WHERE o.orderStatus = 'closed' AND o.account.profile.userID  = :userID"), @NamedQuery(name="orderejb.completeClosedOrders", query="UPDATE orderejb o SET o.orderStatus = 'completed' WHERE o.orderStatus = 'closed' AND o.account.profile.userID  = :userID")})
public class OrderDataBeanImpl
implements OrderDataBean,
Serializable,
PersistenceCapable {
    @TableGenerator(name="orderIdGen", table="KEYGENEJB", pkColumnName="KEYNAME", valueColumnName="KEYVAL", pkColumnValue="order", allocationSize=1000)
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="orderIdGen")
    @Column(name="ORDERID", nullable=false)
    private Integer orderID;
    @Column(name="ORDERTYPE", length=250)
    private String orderType;
    @Column(name="ORDERSTATUS", length=250)
    private String orderStatus;
    @Column(name="OPENDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date openDate;
    @Column(name="COMPLETIONDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date completionDate;
    @Column(name="QUANTITY", nullable=false)
    private double quantity;
    @Column(name="PRICE")
    private BigDecimal price;
    @Column(name="ORDERFEE")
    private BigDecimal orderFee;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ACCOUNT_ACCOUNTID")
    private AccountDataBeanImpl account;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="QUOTE_SYMBOL", columnDefinition="VARCHAR(250)")
    private QuoteDataBeanImpl quote;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="HOLDING_HOLDINGID")
    private HoldingDataBeanImpl holding;
    @Transient
    private String symbol;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Lorg$apache$aries$samples$ariestrader$entities$AccountDataBeanImpl;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Lorg$apache$aries$samples$ariestrader$entities$HoldingDataBeanImpl;
    static /* synthetic */ Class class$Ljava$math$BigDecimal;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$aries$samples$ariestrader$entities$QuoteDataBeanImpl;
    static /* synthetic */ Class class$Lorg$apache$aries$samples$ariestrader$entities$OrderDataBeanImpl;
    private transient Object pcDetachedState;
    private static final long serialVersionUID;

    public OrderDataBeanImpl() {
    }

    public OrderDataBeanImpl(Integer orderID, String orderType, String orderStatus, Date openDate, Date completionDate, double quantity, BigDecimal price, BigDecimal orderFee, String symbol) {
        this.setOrderID(orderID);
        this.setOrderType(orderType);
        this.setOrderStatus(orderStatus);
        this.setOpenDate(openDate);
        this.setCompletionDate(completionDate);
        this.setQuantity(quantity);
        this.setPrice(price);
        this.setOrderFee(orderFee);
        this.setSymbol(symbol);
    }

    public OrderDataBeanImpl(String orderType, String orderStatus, Date openDate, Date completionDate, double quantity, BigDecimal price, BigDecimal orderFee, AccountDataBean account, QuoteDataBean quote, HoldingDataBean holding) {
        this.setOrderType(orderType);
        this.setOrderStatus(orderStatus);
        this.setOpenDate(openDate);
        this.setCompletionDate(completionDate);
        this.setQuantity(quantity);
        this.setPrice(price);
        this.setOrderFee(orderFee);
        this.setAccount(account);
        this.setQuote(quote);
        this.setHolding(holding);
    }

    public static OrderDataBean getRandomInstance() {
        return new OrderDataBeanImpl(new Integer(TradeConfig.rndInt((int)100000)), TradeConfig.rndBoolean() ? "buy" : "sell", "open", new Date(TradeConfig.rndInt((int)Integer.MAX_VALUE)), new Date(TradeConfig.rndInt((int)Integer.MAX_VALUE)), TradeConfig.rndQuantity(), TradeConfig.rndBigDecimal((float)1000.0f), TradeConfig.rndBigDecimal((float)1000.0f), TradeConfig.rndSymbol());
    }

    public String toString() {
        return "Order " + this.getOrderID() + "\n\t      orderType: " + this.getOrderType() + "\n\t    orderStatus: " + this.getOrderStatus() + "\n\t       openDate: " + this.getOpenDate() + "\n\t completionDate: " + this.getCompletionDate() + "\n\t       quantity: " + this.getQuantity() + "\n\t          price: " + this.getPrice() + "\n\t       orderFee: " + this.getOrderFee() + "\n\t         symbol: " + this.getSymbol();
    }

    public String toHTML() {
        return "<BR>Order <B>" + this.getOrderID() + "</B>" + "<LI>      orderType: " + this.getOrderType() + "</LI>" + "<LI>    orderStatus: " + this.getOrderStatus() + "</LI>" + "<LI>       openDate: " + this.getOpenDate() + "</LI>" + "<LI> completionDate: " + this.getCompletionDate() + "</LI>" + "<LI>       quantity: " + this.getQuantity() + "</LI>" + "<LI>          price: " + this.getPrice() + "</LI>" + "<LI>       orderFee: " + this.getOrderFee() + "</LI>" + "<LI>         symbol: " + this.getSymbol() + "</LI>";
    }

    public void print() {
        Log.log((String)this.toString());
    }

    public Integer getOrderID() {
        return OrderDataBeanImpl.pcGetorderID(this);
    }

    public void setOrderID(Integer orderID) {
        OrderDataBeanImpl.pcSetorderID(this, orderID);
    }

    public String getOrderType() {
        return OrderDataBeanImpl.pcGetorderType(this);
    }

    public void setOrderType(String orderType) {
        OrderDataBeanImpl.pcSetorderType(this, orderType);
    }

    public String getOrderStatus() {
        return OrderDataBeanImpl.pcGetorderStatus(this);
    }

    public void setOrderStatus(String orderStatus) {
        OrderDataBeanImpl.pcSetorderStatus(this, orderStatus);
    }

    public Date getOpenDate() {
        return OrderDataBeanImpl.pcGetopenDate(this);
    }

    public void setOpenDate(Date openDate) {
        OrderDataBeanImpl.pcSetopenDate(this, openDate);
    }

    public Date getCompletionDate() {
        return OrderDataBeanImpl.pcGetcompletionDate(this);
    }

    public void setCompletionDate(Date completionDate) {
        OrderDataBeanImpl.pcSetcompletionDate(this, completionDate);
    }

    public double getQuantity() {
        return OrderDataBeanImpl.pcGetquantity(this);
    }

    public void setQuantity(double quantity) {
        OrderDataBeanImpl.pcSetquantity(this, quantity);
    }

    public BigDecimal getPrice() {
        return OrderDataBeanImpl.pcGetprice(this);
    }

    public void setPrice(BigDecimal price) {
        OrderDataBeanImpl.pcSetprice(this, price);
    }

    public BigDecimal getOrderFee() {
        return OrderDataBeanImpl.pcGetorderFee(this);
    }

    public void setOrderFee(BigDecimal orderFee) {
        OrderDataBeanImpl.pcSetorderFee(this, orderFee);
    }

    public String getSymbol() {
        if (OrderDataBeanImpl.pcGetquote(this) != null) {
            return OrderDataBeanImpl.pcGetquote(this).getSymbol();
        }
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public AccountDataBean getAccount() {
        return OrderDataBeanImpl.pcGetaccount(this);
    }

    public void setAccount(AccountDataBean account) {
        OrderDataBeanImpl.pcSetaccount(this, (AccountDataBeanImpl)account);
    }

    public QuoteDataBean getQuote() {
        return OrderDataBeanImpl.pcGetquote(this);
    }

    public void setQuote(QuoteDataBean quote) {
        OrderDataBeanImpl.pcSetquote(this, (QuoteDataBeanImpl)quote);
    }

    public HoldingDataBean getHolding() {
        return OrderDataBeanImpl.pcGetholding(this);
    }

    public void setHolding(HoldingDataBean holding) {
        OrderDataBeanImpl.pcSetholding(this, (HoldingDataBeanImpl)holding);
    }

    public boolean isBuy() {
        String orderType = this.getOrderType();
        return orderType.compareToIgnoreCase("buy") == 0;
    }

    public boolean isSell() {
        String orderType = this.getOrderType();
        return orderType.compareToIgnoreCase("sell") == 0;
    }

    public boolean isOpen() {
        String orderStatus = this.getOrderStatus();
        return orderStatus.compareToIgnoreCase("open") == 0 || orderStatus.compareToIgnoreCase("processing") == 0;
    }

    public boolean isCompleted() {
        String orderStatus = this.getOrderStatus();
        return orderStatus.compareToIgnoreCase("completed") == 0 || orderStatus.compareToIgnoreCase("alertcompleted") == 0 || orderStatus.compareToIgnoreCase("cancelled") == 0;
    }

    public boolean isCancelled() {
        String orderStatus = this.getOrderStatus();
        return orderStatus.compareToIgnoreCase("cancelled") == 0;
    }

    public void cancel() {
        this.setOrderStatus("cancelled");
    }

    public int hashCode() {
        int hash = 0;
        return hash += OrderDataBeanImpl.pcGetorderID(this) != null ? OrderDataBeanImpl.pcGetorderID(this).hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OrderDataBeanImpl)) {
            return false;
        }
        OrderDataBeanImpl other = (OrderDataBeanImpl)object;
        return OrderDataBeanImpl.pcGetorderID(this) == OrderDataBeanImpl.pcGetorderID(other) || OrderDataBeanImpl.pcGetorderID(this) != null && OrderDataBeanImpl.pcGetorderID(this).equals(OrderDataBeanImpl.pcGetorderID(other));
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        serialVersionUID = 3389560314288688757L;
        pcFieldNames = new String[]{"account", "completionDate", "holding", "openDate", "orderFee", "orderID", "orderStatus", "orderType", "price", "quantity", "quote"};
        Class[] classArray = new Class[11];
        Class clazz = class$Lorg$apache$aries$samples$ariestrader$entities$AccountDataBeanImpl != null ? class$Lorg$apache$aries$samples$ariestrader$entities$AccountDataBeanImpl : (class$Lorg$apache$aries$samples$ariestrader$entities$AccountDataBeanImpl = OrderDataBeanImpl.class$("org.apache.aries.samples.ariestrader.entities.AccountDataBeanImpl"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = OrderDataBeanImpl.class$("java.util.Date"));
        classArray[1] = clazz2;
        Class clazz3 = class$Lorg$apache$aries$samples$ariestrader$entities$HoldingDataBeanImpl != null ? class$Lorg$apache$aries$samples$ariestrader$entities$HoldingDataBeanImpl : (class$Lorg$apache$aries$samples$ariestrader$entities$HoldingDataBeanImpl = OrderDataBeanImpl.class$("org.apache.aries.samples.ariestrader.entities.HoldingDataBeanImpl"));
        classArray[2] = clazz3;
        classArray[3] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = OrderDataBeanImpl.class$("java.util.Date"));
        Class clazz4 = class$Ljava$math$BigDecimal != null ? class$Ljava$math$BigDecimal : (class$Ljava$math$BigDecimal = OrderDataBeanImpl.class$("java.math.BigDecimal"));
        classArray[4] = clazz4;
        Class clazz5 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = OrderDataBeanImpl.class$("java.lang.Integer"));
        classArray[5] = clazz5;
        Class clazz6 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = OrderDataBeanImpl.class$("java.lang.String"));
        classArray[6] = clazz6;
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = OrderDataBeanImpl.class$("java.lang.String"));
        classArray[8] = class$Ljava$math$BigDecimal != null ? class$Ljava$math$BigDecimal : (class$Ljava$math$BigDecimal = OrderDataBeanImpl.class$("java.math.BigDecimal"));
        classArray[9] = Double.TYPE;
        Class clazz7 = class$Lorg$apache$aries$samples$ariestrader$entities$QuoteDataBeanImpl != null ? class$Lorg$apache$aries$samples$ariestrader$entities$QuoteDataBeanImpl : (class$Lorg$apache$aries$samples$ariestrader$entities$QuoteDataBeanImpl = OrderDataBeanImpl.class$("org.apache.aries.samples.ariestrader.entities.QuoteDataBeanImpl"));
        classArray[10] = clazz7;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{21, 26, 21, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz8 = class$Lorg$apache$aries$samples$ariestrader$entities$OrderDataBeanImpl != null ? class$Lorg$apache$aries$samples$ariestrader$entities$OrderDataBeanImpl : (class$Lorg$apache$aries$samples$ariestrader$entities$OrderDataBeanImpl = OrderDataBeanImpl.class$("org.apache.aries.samples.ariestrader.entities.OrderDataBeanImpl"));
        PCRegistry.register((Class)clazz8, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"orderejb", (PersistenceCapable)new OrderDataBeanImpl());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.account = null;
        this.completionDate = null;
        this.holding = null;
        this.openDate = null;
        this.orderFee = null;
        this.orderID = null;
        this.orderStatus = null;
        this.orderType = null;
        this.price = null;
        this.quantity = 0.0;
        this.quote = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        OrderDataBeanImpl orderDataBeanImpl = new OrderDataBeanImpl();
        if (bl) {
            orderDataBeanImpl.pcClearFields();
        }
        orderDataBeanImpl.pcStateManager = stateManager;
        orderDataBeanImpl.pcCopyKeyFieldsFromObjectId(object);
        return orderDataBeanImpl;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        OrderDataBeanImpl orderDataBeanImpl = new OrderDataBeanImpl();
        if (bl) {
            orderDataBeanImpl.pcClearFields();
        }
        orderDataBeanImpl.pcStateManager = stateManager;
        return orderDataBeanImpl;
    }

    protected static int pcGetManagedFieldCount() {
        return 11;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.account = (AccountDataBeanImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.completionDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.holding = (HoldingDataBeanImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.openDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.orderFee = (BigDecimal)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.orderID = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.orderStatus = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.orderType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.price = (BigDecimal)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.quantity = this.pcStateManager.replaceDoubleField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.quote = (QuoteDataBeanImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.account);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.completionDate);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.holding);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.openDate);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.orderFee);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.orderID);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.orderStatus);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.orderType);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.price);
                return;
            }
            case 9: {
                this.pcStateManager.providedDoubleField((PersistenceCapable)this, n, this.quantity);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.quote);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(OrderDataBeanImpl orderDataBeanImpl, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.account = orderDataBeanImpl.account;
                return;
            }
            case 1: {
                this.completionDate = orderDataBeanImpl.completionDate;
                return;
            }
            case 2: {
                this.holding = orderDataBeanImpl.holding;
                return;
            }
            case 3: {
                this.openDate = orderDataBeanImpl.openDate;
                return;
            }
            case 4: {
                this.orderFee = orderDataBeanImpl.orderFee;
                return;
            }
            case 5: {
                this.orderID = orderDataBeanImpl.orderID;
                return;
            }
            case 6: {
                this.orderStatus = orderDataBeanImpl.orderStatus;
                return;
            }
            case 7: {
                this.orderType = orderDataBeanImpl.orderType;
                return;
            }
            case 8: {
                this.price = orderDataBeanImpl.price;
                return;
            }
            case 9: {
                this.quantity = orderDataBeanImpl.quantity;
                return;
            }
            case 10: {
                this.quote = orderDataBeanImpl.quote;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        OrderDataBeanImpl orderDataBeanImpl = (OrderDataBeanImpl)object;
        if (orderDataBeanImpl.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(orderDataBeanImpl, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        IntId intId = (IntId)object;
        fieldConsumer.storeObjectField(5 + pcInheritedFieldCount, (Object)new Integer(intId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        IntId intId = (IntId)object;
        this.orderID = new Integer(intId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$aries$samples$ariestrader$entities$OrderDataBeanImpl != null ? class$Lorg$apache$aries$samples$ariestrader$entities$OrderDataBeanImpl : (class$Lorg$apache$aries$samples$ariestrader$entities$OrderDataBeanImpl = OrderDataBeanImpl.class$("org.apache.aries.samples.ariestrader.entities.OrderDataBeanImpl"));
        return new IntId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$aries$samples$ariestrader$entities$OrderDataBeanImpl != null ? class$Lorg$apache$aries$samples$ariestrader$entities$OrderDataBeanImpl : (class$Lorg$apache$aries$samples$ariestrader$entities$OrderDataBeanImpl = OrderDataBeanImpl.class$("org.apache.aries.samples.ariestrader.entities.OrderDataBeanImpl"));
        return new IntId(clazz, this.orderID);
    }

    private static final AccountDataBeanImpl pcGetaccount(OrderDataBeanImpl orderDataBeanImpl) {
        if (orderDataBeanImpl.pcStateManager == null) {
            return orderDataBeanImpl.account;
        }
        int n = pcInheritedFieldCount + 0;
        orderDataBeanImpl.pcStateManager.accessingField(n);
        return orderDataBeanImpl.account;
    }

    private static final void pcSetaccount(OrderDataBeanImpl orderDataBeanImpl, AccountDataBeanImpl accountDataBeanImpl) {
        if (orderDataBeanImpl.pcStateManager == null) {
            orderDataBeanImpl.account = accountDataBeanImpl;
            return;
        }
        orderDataBeanImpl.pcStateManager.settingObjectField((PersistenceCapable)orderDataBeanImpl, pcInheritedFieldCount + 0, (Object)orderDataBeanImpl.account, (Object)accountDataBeanImpl, 0);
    }

    private static final Date pcGetcompletionDate(OrderDataBeanImpl orderDataBeanImpl) {
        if (orderDataBeanImpl.pcStateManager == null) {
            return orderDataBeanImpl.completionDate;
        }
        int n = pcInheritedFieldCount + 1;
        orderDataBeanImpl.pcStateManager.accessingField(n);
        return orderDataBeanImpl.completionDate;
    }

    private static final void pcSetcompletionDate(OrderDataBeanImpl orderDataBeanImpl, Date date) {
        if (orderDataBeanImpl.pcStateManager == null) {
            orderDataBeanImpl.completionDate = date;
            return;
        }
        orderDataBeanImpl.pcStateManager.settingObjectField((PersistenceCapable)orderDataBeanImpl, pcInheritedFieldCount + 1, (Object)orderDataBeanImpl.completionDate, (Object)date, 0);
    }

    private static final HoldingDataBeanImpl pcGetholding(OrderDataBeanImpl orderDataBeanImpl) {
        if (orderDataBeanImpl.pcStateManager == null) {
            return orderDataBeanImpl.holding;
        }
        int n = pcInheritedFieldCount + 2;
        orderDataBeanImpl.pcStateManager.accessingField(n);
        return orderDataBeanImpl.holding;
    }

    private static final void pcSetholding(OrderDataBeanImpl orderDataBeanImpl, HoldingDataBeanImpl holdingDataBeanImpl) {
        if (orderDataBeanImpl.pcStateManager == null) {
            orderDataBeanImpl.holding = holdingDataBeanImpl;
            return;
        }
        orderDataBeanImpl.pcStateManager.settingObjectField((PersistenceCapable)orderDataBeanImpl, pcInheritedFieldCount + 2, (Object)orderDataBeanImpl.holding, (Object)holdingDataBeanImpl, 0);
    }

    private static final Date pcGetopenDate(OrderDataBeanImpl orderDataBeanImpl) {
        if (orderDataBeanImpl.pcStateManager == null) {
            return orderDataBeanImpl.openDate;
        }
        int n = pcInheritedFieldCount + 3;
        orderDataBeanImpl.pcStateManager.accessingField(n);
        return orderDataBeanImpl.openDate;
    }

    private static final void pcSetopenDate(OrderDataBeanImpl orderDataBeanImpl, Date date) {
        if (orderDataBeanImpl.pcStateManager == null) {
            orderDataBeanImpl.openDate = date;
            return;
        }
        orderDataBeanImpl.pcStateManager.settingObjectField((PersistenceCapable)orderDataBeanImpl, pcInheritedFieldCount + 3, (Object)orderDataBeanImpl.openDate, (Object)date, 0);
    }

    private static final BigDecimal pcGetorderFee(OrderDataBeanImpl orderDataBeanImpl) {
        if (orderDataBeanImpl.pcStateManager == null) {
            return orderDataBeanImpl.orderFee;
        }
        int n = pcInheritedFieldCount + 4;
        orderDataBeanImpl.pcStateManager.accessingField(n);
        return orderDataBeanImpl.orderFee;
    }

    private static final void pcSetorderFee(OrderDataBeanImpl orderDataBeanImpl, BigDecimal bigDecimal) {
        if (orderDataBeanImpl.pcStateManager == null) {
            orderDataBeanImpl.orderFee = bigDecimal;
            return;
        }
        orderDataBeanImpl.pcStateManager.settingObjectField((PersistenceCapable)orderDataBeanImpl, pcInheritedFieldCount + 4, (Object)orderDataBeanImpl.orderFee, (Object)bigDecimal, 0);
    }

    private static final Integer pcGetorderID(OrderDataBeanImpl orderDataBeanImpl) {
        if (orderDataBeanImpl.pcStateManager == null) {
            return orderDataBeanImpl.orderID;
        }
        int n = pcInheritedFieldCount + 5;
        orderDataBeanImpl.pcStateManager.accessingField(n);
        return orderDataBeanImpl.orderID;
    }

    private static final void pcSetorderID(OrderDataBeanImpl orderDataBeanImpl, Integer n) {
        if (orderDataBeanImpl.pcStateManager == null) {
            orderDataBeanImpl.orderID = n;
            return;
        }
        orderDataBeanImpl.pcStateManager.settingObjectField((PersistenceCapable)orderDataBeanImpl, pcInheritedFieldCount + 5, (Object)orderDataBeanImpl.orderID, (Object)n, 0);
    }

    private static final String pcGetorderStatus(OrderDataBeanImpl orderDataBeanImpl) {
        if (orderDataBeanImpl.pcStateManager == null) {
            return orderDataBeanImpl.orderStatus;
        }
        int n = pcInheritedFieldCount + 6;
        orderDataBeanImpl.pcStateManager.accessingField(n);
        return orderDataBeanImpl.orderStatus;
    }

    private static final void pcSetorderStatus(OrderDataBeanImpl orderDataBeanImpl, String string) {
        if (orderDataBeanImpl.pcStateManager == null) {
            orderDataBeanImpl.orderStatus = string;
            return;
        }
        orderDataBeanImpl.pcStateManager.settingStringField((PersistenceCapable)orderDataBeanImpl, pcInheritedFieldCount + 6, orderDataBeanImpl.orderStatus, string, 0);
    }

    private static final String pcGetorderType(OrderDataBeanImpl orderDataBeanImpl) {
        if (orderDataBeanImpl.pcStateManager == null) {
            return orderDataBeanImpl.orderType;
        }
        int n = pcInheritedFieldCount + 7;
        orderDataBeanImpl.pcStateManager.accessingField(n);
        return orderDataBeanImpl.orderType;
    }

    private static final void pcSetorderType(OrderDataBeanImpl orderDataBeanImpl, String string) {
        if (orderDataBeanImpl.pcStateManager == null) {
            orderDataBeanImpl.orderType = string;
            return;
        }
        orderDataBeanImpl.pcStateManager.settingStringField((PersistenceCapable)orderDataBeanImpl, pcInheritedFieldCount + 7, orderDataBeanImpl.orderType, string, 0);
    }

    private static final BigDecimal pcGetprice(OrderDataBeanImpl orderDataBeanImpl) {
        if (orderDataBeanImpl.pcStateManager == null) {
            return orderDataBeanImpl.price;
        }
        int n = pcInheritedFieldCount + 8;
        orderDataBeanImpl.pcStateManager.accessingField(n);
        return orderDataBeanImpl.price;
    }

    private static final void pcSetprice(OrderDataBeanImpl orderDataBeanImpl, BigDecimal bigDecimal) {
        if (orderDataBeanImpl.pcStateManager == null) {
            orderDataBeanImpl.price = bigDecimal;
            return;
        }
        orderDataBeanImpl.pcStateManager.settingObjectField((PersistenceCapable)orderDataBeanImpl, pcInheritedFieldCount + 8, (Object)orderDataBeanImpl.price, (Object)bigDecimal, 0);
    }

    private static final double pcGetquantity(OrderDataBeanImpl orderDataBeanImpl) {
        if (orderDataBeanImpl.pcStateManager == null) {
            return orderDataBeanImpl.quantity;
        }
        int n = pcInheritedFieldCount + 9;
        orderDataBeanImpl.pcStateManager.accessingField(n);
        return orderDataBeanImpl.quantity;
    }

    private static final void pcSetquantity(OrderDataBeanImpl orderDataBeanImpl, double d) {
        if (orderDataBeanImpl.pcStateManager == null) {
            orderDataBeanImpl.quantity = d;
            return;
        }
        orderDataBeanImpl.pcStateManager.settingDoubleField((PersistenceCapable)orderDataBeanImpl, pcInheritedFieldCount + 9, orderDataBeanImpl.quantity, d, 0);
    }

    private static final QuoteDataBeanImpl pcGetquote(OrderDataBeanImpl orderDataBeanImpl) {
        if (orderDataBeanImpl.pcStateManager == null) {
            return orderDataBeanImpl.quote;
        }
        int n = pcInheritedFieldCount + 10;
        orderDataBeanImpl.pcStateManager.accessingField(n);
        return orderDataBeanImpl.quote;
    }

    private static final void pcSetquote(OrderDataBeanImpl orderDataBeanImpl, QuoteDataBeanImpl quoteDataBeanImpl) {
        if (orderDataBeanImpl.pcStateManager == null) {
            orderDataBeanImpl.quote = quoteDataBeanImpl;
            return;
        }
        orderDataBeanImpl.pcStateManager.settingObjectField((PersistenceCapable)orderDataBeanImpl, pcInheritedFieldCount + 10, (Object)orderDataBeanImpl.quote, (Object)quoteDataBeanImpl, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.orderID != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

