/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.eclipselink.adapter;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public final class UnionClassLoader
extends ClassLoader
implements BundleReference {
    private static final String ORG_OSGI_FRAMEWORK = "org.osgi.framework.";
    private static final int DOT_INDEX = "org.osgi.framework.".lastIndexOf(46);
    private final Bundle eclipseLinkBundle;
    private final Bundle adaptorBundle;

    public UnionClassLoader(ClassLoader parentLoader, Bundle b, Bundle adaptor) {
        super(parentLoader);
        this.eclipseLinkBundle = b;
        this.adaptorBundle = adaptor;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if ("org.apache.aries.jpa.eclipselink.adapter.platform.OSGiTSServer".equals(name) || "org.apache.aries.jpa.eclipselink.adapter.platform.OSGiTSWrapper".equals(name)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(name.replace('.', '/') + ".class");
            if (is == null) {
                throw new ClassNotFoundException(name);
            }
            try {
                UnionClassLoader.copy(is, baos);
            }
            catch (IOException ioe) {
                throw new ClassNotFoundException(name, ioe);
            }
            return this.defineClass(name, baos.toByteArray(), 0, baos.size());
        }
        if (name.startsWith(ORG_OSGI_FRAMEWORK) && name.lastIndexOf(46) == DOT_INDEX) {
            return this.adaptorBundle.loadClass(name);
        }
        return this.eclipseLinkBundle.loadClass(name);
    }

    public Bundle getBundle() {
        return this.adaptorBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream in, OutputStream out) throws IOException {
        try {
            int len;
            byte[] b = new byte[1024];
            while ((len = in.read(b)) != -1) {
                out.write(b, 0, len);
            }
        }
        finally {
            UnionClassLoader.close(in);
        }
    }

    private static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException e) {
            c = null;
        }
    }
}

