/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.eclipselink.adapter;

import java.lang.reflect.Constructor;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.apache.aries.jpa.eclipselink.adapter.Activator;
import org.apache.aries.jpa.eclipselink.adapter.PersistenceUnitProxyWithTargetServer;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseLinkProviderService
implements ServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private final Bundle eclipseLinkJpaBundle;

    public EclipseLinkProviderService(Bundle b) {
        this.eclipseLinkJpaBundle = b;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        logger.debug("Requested EclipseLink Provider service");
        try {
            Class providerClass = this.eclipseLinkJpaBundle.loadClass("org.eclipse.persistence.jpa.PersistenceProvider");
            Constructor con = providerClass.getConstructor(new Class[0]);
            final PersistenceProvider provider = (PersistenceProvider)con.newInstance(new Object[0]);
            return new PersistenceProvider(){

                public ProviderUtil getProviderUtil() {
                    return provider.getProviderUtil();
                }

                public EntityManagerFactory createEntityManagerFactory(String arg0, Map arg1) {
                    return provider.createEntityManagerFactory(arg0, arg1);
                }

                public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo punit, Map props) {
                    return provider.createContainerEntityManagerFactory((PersistenceUnitInfo)new PersistenceUnitProxyWithTargetServer(punit, EclipseLinkProviderService.this.eclipseLinkJpaBundle), props);
                }

                public void generateSchema(PersistenceUnitInfo punit, Map arg1) {
                    provider.generateSchema((PersistenceUnitInfo)new PersistenceUnitProxyWithTargetServer(punit, EclipseLinkProviderService.this.eclipseLinkJpaBundle), arg1);
                }

                public boolean generateSchema(String arg0, Map arg1) {
                    return provider.generateSchema(arg0, arg1);
                }
            };
        }
        catch (Exception e) {
            logger.error("An exception was caught trying to instantiate the EclipseLink JPA provider.", (Throwable)e);
            return null;
        }
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }
}

