/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.eclipselink.adapter;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.spi.PersistenceProvider;
import org.apache.aries.jpa.eclipselink.adapter.EclipseLinkProviderService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
BundleListener {
    public static final String ECLIPSELINK_JPA_PROVIDER_BUNDLE_SYMBOLIC_NAME = "org.eclipse.persistence.jpa";
    public static final String ECLIPSELINK_JPA_PROVIDER_CLASS_NAME = "org.eclipse.persistence.jpa.PersistenceProvider";
    private final ConcurrentMap<Bundle, ServiceRegistration<?>> registeredProviders = new ConcurrentHashMap();
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private BundleContext context;

    public void start(BundleContext ctx) {
        logger.debug("Starting EclipseLink adapter");
        this.context = ctx;
        ctx.addBundleListener((BundleListener)this);
        for (Bundle b : ctx.getBundles()) {
            if ((b.getState() & 0x3C) == 0) continue;
            this.handlePotentialEclipseLink(b);
        }
    }

    public void stop(BundleContext ctx) {
        logger.debug("Stopping EclipseLink adapter");
        for (ServiceRegistration reg : this.registeredProviders.values()) {
            reg.unregister();
        }
    }

    public void bundleChanged(BundleEvent event) {
        ServiceRegistration reg;
        if ((event.getType() & 0x20) != 0) {
            this.handlePotentialEclipseLink(event.getBundle());
        } else if (event.getType() == 64 | event.getType() == 16 && (reg = (ServiceRegistration)this.registeredProviders.remove(event.getBundle())) != null) {
            reg.unregister();
        }
    }

    private void handlePotentialEclipseLink(Bundle b) {
        if (b.getSymbolicName().equals(ECLIPSELINK_JPA_PROVIDER_BUNDLE_SYMBOLIC_NAME)) {
            logger.debug("Found EclipseLink bundle {}", (Object)b);
            try {
                b.loadClass(ECLIPSELINK_JPA_PROVIDER_CLASS_NAME);
            }
            catch (ClassNotFoundException cnfe) {
                logger.debug("Did not find provider class, exiting");
                return;
            }
            if (!this.registeredProviders.containsKey(b)) {
                logger.debug("Adding new EclipseLink provider for bundle {}", (Object)b);
                EclipseLinkProviderService factory = new EclipseLinkProviderService(b);
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                props.put("org.apache.aries.jpa.container.weaving.packages", this.getJPAPackages(b));
                props.put("javax.persistence.provider", ECLIPSELINK_JPA_PROVIDER_CLASS_NAME);
                ServiceRegistration reg = this.context.registerService(PersistenceProvider.class.getName(), (Object)factory, props);
                ServiceRegistration old = this.registeredProviders.putIfAbsent(b, reg);
                if (old != null) {
                    reg.unregister();
                }
            }
        }
    }

    private String[] getJPAPackages(Bundle jpaBundle) {
        HashSet<String> result = new HashSet<String>();
        for (Bundle b : this.context.getBundles()) {
            BundleWiring bw = (BundleWiring)b.adapt(BundleWiring.class);
            if (bw == null) continue;
            List wires = bw.getProvidedWires("osgi.wiring.package");
            for (BundleWire w : wires) {
                String pkgName = (String)w.getCapability().getAttributes().get("osgi.wiring.package");
                boolean add = false;
                if (b.equals(jpaBundle)) {
                    add = true;
                } else if (pkgName.startsWith("org.eclipse.persistence")) {
                    add = true;
                }
                if (!add) continue;
                String suffix = ";bundle-symbolic-name=" + b.getSymbolicName() + ";" + "bundle-version" + "=" + b.getVersion();
                result.add(pkgName + suffix);
            }
        }
        result.add("org.apache.aries.jpa.eclipselink.adapter.platform;bundle-symbolic-name=" + this.context.getBundle().getSymbolicName() + ";" + "bundle-version" + "=" + this.context.getBundle().getVersion());
        logger.debug("Found JPA packages {}", result);
        return result.toArray(new String[0]);
    }
}

