/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.blueprint.impl;

import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.jpa.blueprint.impl.ResourceLocalTransactionParticipant;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Coordinator;
import org.osgi.service.coordinator.Participant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaInterceptor
implements Interceptor {
    private static final Logger LOG = LoggerFactory.getLogger(JpaInterceptor.class);
    private EntityManager em;
    private Boolean cachedIsResourceLocal;
    private Coordinator coordinator;
    private BlueprintContainer container;
    private String coordinatorId;
    private String emId;

    public JpaInterceptor(BlueprintContainer container, String coordinatorId, String emId) {
        this.container = container;
        this.coordinatorId = coordinatorId;
        this.emId = emId;
    }

    public int getRank() {
        return 0;
    }

    public Object preCall(ComponentMetadata cm, Method m, Object ... parameters) throws Throwable {
        if (this.coordinator == null || this.em == null) {
            this.initServices();
        }
        try {
            boolean weControlTx;
            LOG.debug("PreCall for bean {}, method {}", (Object)cm.getId(), (Object)m.getName());
            Coordination coordination = this.coordinator.begin("jpa", 0L);
            boolean bl = weControlTx = this.isResourceLocal(this.em) && !this.em.getTransaction().isActive();
            if (weControlTx) {
                coordination.addParticipant((Participant)new ResourceLocalTransactionParticipant(this.em));
            }
            return coordination;
        }
        catch (Exception e) {
            LOG.warn("Exception from EmSupplier.preCall", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private synchronized void initServices() {
        if (this.coordinator == null || this.em == null) {
            this.coordinator = (Coordinator)this.container.getComponentInstance(this.coordinatorId);
            this.em = (EntityManager)this.container.getComponentInstance(this.emId);
        }
    }

    public void postCallWithException(ComponentMetadata cm, Method m, Throwable ex, Object preCallToken) {
        LOG.debug("PostCallWithException for bean {}, method {}", new Object[]{cm.getId(), m.getName(), ex});
        if (preCallToken != null) {
            Coordination coordination = (Coordination)preCallToken;
            coordination.fail(ex);
            this.safeEndCoordination(coordination);
        }
    }

    public void postCallWithReturn(ComponentMetadata cm, Method m, Object returnType, Object preCallToken) throws Exception {
        LOG.debug("PostCallWithReturn for bean {}, method {}", (Object)cm.getId(), (Object)m.getName());
        if (preCallToken != null) {
            this.safeEndCoordination((Coordination)preCallToken);
        }
    }

    private boolean isResourceLocal(EntityManager em) {
        if (this.cachedIsResourceLocal == null) {
            this.cachedIsResourceLocal = this.isResourceLocalInternal(em);
        }
        return this.cachedIsResourceLocal;
    }

    private boolean isResourceLocalInternal(EntityManager em) {
        PersistenceUnitTransactionType transactionType = (PersistenceUnitTransactionType)em.getProperties().get(PersistenceUnitTransactionType.class.getName());
        return transactionType == PersistenceUnitTransactionType.RESOURCE_LOCAL;
    }

    private void safeEndCoordination(Coordination coordination) {
        try {
            if (coordination != null) {
                coordination.end();
            }
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
    }
}

