/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.blueprint.impl;

import javax.persistence.EntityManager;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Participant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResourceLocalTransactionParticipant
implements Participant {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceLocalTransactionParticipant.class);
    private final EntityManager em;

    ResourceLocalTransactionParticipant(EntityManager em) {
        this.em = em;
        em.getTransaction().begin();
    }

    public void failed(Coordination coordination) throws Exception {
        this.em.getTransaction().setRollbackOnly();
    }

    public void ended(Coordination coordination) throws Exception {
        if (this.em.getTransaction().getRollbackOnly()) {
            try {
                this.em.getTransaction().rollback();
            }
            catch (Exception e) {
                LOG.debug("Exception on transaction rollback", (Throwable)e);
            }
        } else {
            this.em.getTransaction().commit();
        }
    }
}

