/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal.cxf;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.jax.rs.whiteboard.internal.Whiteboard;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.ComparableResourceComparator;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.PromiseAwareJAXRSInvoker;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.PrototypeServiceReferenceResourceProvider;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.ServiceReferenceFilterProviderInfo;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.ServiceReferenceProviderInfoComparator;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.ServiceReferenceResourceProvider;
import org.apache.aries.jax.rs.whiteboard.internal.utils.ServiceTuple;
import org.apache.aries.jax.rs.whiteboard.internal.utils.Utils;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.ext.ResourceComparator;
import org.apache.cxf.jaxrs.impl.ConfigurableImpl;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.provider.ServerConfigurableFactory;
import org.apache.cxf.jaxrs.sse.SseContextProvider;
import org.apache.cxf.jaxrs.sse.SseEventSinkContextProvider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.service.invoker.Invoker;

public class CxfJaxrsServiceRegistrator {
    private final ServiceTuple<Application> _applicationTuple;
    private final Bus _bus;
    private final Collection<ServiceTuple<?>> _providers;
    private final Collection<ResourceProvider> _services = new ArrayList<ResourceProvider>();
    private volatile boolean _closed = false;
    private JAXRSServerFactoryBean _jaxRsServerFactoryBean;
    private Map<String, Object> _properties;
    private Server _server;

    public CxfJaxrsServiceRegistrator(Bus bus, ServiceTuple<Application> applicationTuple, Map<String, ?> properties) {
        this._bus = bus;
        this._applicationTuple = applicationTuple;
        this._properties = Collections.unmodifiableMap(new HashMap(properties));
        Comparator<ServiceTuple> comparing = Comparator.comparing(ServiceTuple::getCachingServiceReference);
        this._providers = new TreeSet<ServiceTuple>(comparing);
        this.rewire();
    }

    public synchronized void add(ResourceProvider resourceProvider) {
        if (this._closed) {
            return;
        }
        this._services.add(resourceProvider);
        try {
            this.rewire();
        }
        catch (Exception e) {
            this.remove(resourceProvider);
            throw e;
        }
    }

    public synchronized void addProvider(ServiceTuple<?> tuple) {
        if (this._closed) {
            return;
        }
        this._providers.add(tuple);
        try {
            this.rewire();
        }
        catch (Exception e) {
            this.removeProvider(tuple);
            throw e;
        }
    }

    public void close() {
        if (this._closed) {
            return;
        }
        this._closed = true;
        if (this._server != null) {
            this._server.destroy();
        }
        if (this._bus != null) {
            this._bus.shutdown(false);
        }
    }

    public <T> T createEndpoint(Application app, Class<T> endpointType) {
        JAXRSServerFactoryBean bean = (JAXRSServerFactoryBean)RuntimeDelegate.getInstance().createEndpoint(app, JAXRSServerFactoryBean.class);
        if (JAXRSServerFactoryBean.class.isAssignableFrom(endpointType)) {
            return endpointType.cast(bean);
        }
        bean.setStart(false);
        Server server = bean.create();
        return endpointType.cast(server);
    }

    public Bus getBus() {
        return this._bus;
    }

    public Iterable<Class<?>> getStaticResourceClasses() {
        if (this._jaxRsServerFactoryBean == null) {
            return Collections.emptyList();
        }
        JAXRSServiceFactoryBean serviceFactory = this._jaxRsServerFactoryBean.getServiceFactory();
        List classResourceInfo = serviceFactory.getClassResourceInfo();
        ArrayList classes = new ArrayList();
        for (ClassResourceInfo resourceInfo : classResourceInfo) {
            ResourceProvider resourceProvider;
            if (resourceInfo == null || (resourceProvider = resourceInfo.getResourceProvider()) != null && ServiceReferenceResourceProvider.class.isAssignableFrom(resourceProvider.getClass())) continue;
            classes.add(resourceInfo.getResourceClass());
        }
        return classes;
    }

    public synchronized void remove(ResourceProvider resourceProvider) {
        if (this._closed) {
            return;
        }
        this._services.remove(resourceProvider);
        this.rewire();
    }

    public synchronized void removeProvider(ServiceTuple<?> tuple) {
        if (this._closed) {
            return;
        }
        this._providers.remove(tuple);
        this.rewire();
    }

    protected synchronized void rewire() {
        Application application;
        if (!this._applicationTuple.isAvailable()) {
            this._applicationTuple.dispose();
            return;
        }
        if (this._server != null) {
            this._server.destroy();
            this._applicationTuple.refresh();
            for (ServiceTuple<?> provider : this._providers) {
                provider.refresh();
            }
        }
        if ((application = this._applicationTuple.getService()) == null) {
            return;
        }
        if (this._services.isEmpty() && application.getSingletons().isEmpty() && application.getClasses().isEmpty()) {
            return;
        }
        this._jaxRsServerFactoryBean = this.createEndpoint(application, JAXRSServerFactoryBean.class);
        this._jaxRsServerFactoryBean.setInvoker((Invoker)new PromiseAwareJAXRSInvoker());
        this._jaxRsServerFactoryBean.setBus(this._bus);
        this._bus.setExtension(context -> {
            ConfigurableImpl configurable = new ConfigurableImpl((Configurable)context, RuntimeType.SERVER);
            configurable.property("osgi.jaxrs.application.serviceProperties", this._properties);
            return configurable;
        }, ServerConfigurableFactory.class);
        this._jaxRsServerFactoryBean.setStart(false);
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (ServiceTuple<?> provider : this._providers) {
            Object service;
            CachingServiceReference<?> cachingServiceReference = provider.getCachingServiceReference();
            if (!provider.isAvailable() || (service = provider.getService()) == null) continue;
            if (service instanceof javax.ws.rs.core.Feature || service instanceof DynamicFeature) {
                this._jaxRsServerFactoryBean.setProvider(service);
                continue;
            }
            if (service instanceof Feature) {
                features.add((Feature)service);
                continue;
            }
            Class realClass = ClassHelper.getRealClass((Bus)this.getBus(), service);
            Class[] interfaces = (Class[])Arrays.stream(Utils.canonicalize(cachingServiceReference.getProperty("objectClass"))).filter(Whiteboard.SUPPORTED_EXTENSION_INTERFACES::containsKey).map(Whiteboard.SUPPORTED_EXTENSION_INTERFACES::get).toArray(Class[]::new);
            Map<Class<?>, Integer> classesWithPriorities = Arrays.stream(interfaces).collect(Collectors.toMap(c -> c, __ -> AnnotationUtils.getBindingPriority((Class)realClass)));
            this._jaxRsServerFactoryBean.setProvider(new ServiceReferenceFilterProviderInfo(cachingServiceReference, realClass, realClass, service, this.getBus(), CxfJaxrsServiceRegistrator.getFilterNameBindings(this.getBus(), service), false, classesWithPriorities));
        }
        this._jaxRsServerFactoryBean.setProvider((Object)new SseEventSinkContextProvider());
        this._jaxRsServerFactoryBean.setProvider((Object)new SseContextProvider());
        if (!features.isEmpty()) {
            features.addAll(this._jaxRsServerFactoryBean.getFeatures());
            this._jaxRsServerFactoryBean.setFeatures(features);
        }
        for (ResourceProvider resourceProvider : this._services) {
            PrototypeServiceReferenceResourceProvider provider;
            if (resourceProvider instanceof PrototypeServiceReferenceResourceProvider && !(provider = (PrototypeServiceReferenceResourceProvider)resourceProvider).isAvailable()) continue;
            this._jaxRsServerFactoryBean.setResourceProvider(resourceProvider);
        }
        if (this._jaxRsServerFactoryBean.getResourceClasses().isEmpty()) {
            return;
        }
        this._jaxRsServerFactoryBean.setResourceComparator((ResourceComparator)new ComparableResourceComparator());
        ProviderFactory.ProviderInfoClassComparator providerInfoClassComparator = new ProviderFactory.ProviderInfoClassComparator(Object.class);
        this._jaxRsServerFactoryBean.setProviderComparator((Comparator)new ServiceReferenceProviderInfoComparator(providerInfoClassComparator));
        this._server = this._jaxRsServerFactoryBean.create();
        ApplicationInfo applicationInfo = (ApplicationInfo)this._server.getEndpoint().get((Object)Application.class.getName());
        applicationInfo.setOverridingProps((Map)new HashMap<String, Object>(){
            {
                this.put("osgi.jaxrs.application.serviceProperties", CxfJaxrsServiceRegistrator.this._properties);
            }
        });
        this._server.start();
    }

    private static Set<String> getFilterNameBindings(Bus bus, Object provider) {
        Class pClass = ClassHelper.getRealClass((Bus)bus, (Object)provider);
        Set<String> names = AnnotationUtils.getNameBindings((Annotation[])pClass.getAnnotations());
        if (names.isEmpty()) {
            names = Collections.singleton("org.apache.cxf.filter.binding");
        }
        return names;
    }
}

