/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Servlet;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.jax.rs.whiteboard.internal.ApplicationExtensionRegistry;
import org.apache.aries.jax.rs.whiteboard.internal.AriesJaxrsServiceRuntime;
import org.apache.aries.jax.rs.whiteboard.internal.DefaultApplication;
import org.apache.aries.jax.rs.whiteboard.internal.DefaultWeb;
import org.apache.aries.jax.rs.whiteboard.internal.ExtensionRegistry;
import org.apache.aries.jax.rs.whiteboard.internal.Maps;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.CxfJaxrsServiceRegistrator;
import org.apache.aries.jax.rs.whiteboard.internal.utils.LogUtils;
import org.apache.aries.jax.rs.whiteboard.internal.utils.PropertyHolder;
import org.apache.aries.jax.rs.whiteboard.internal.utils.ServiceTuple;
import org.apache.aries.jax.rs.whiteboard.internal.utils.Utils;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.ExtensionManagerBus;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.jaxrs.runtime.JaxrsServiceRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Whiteboard {
    public static final Map<String, Class<?>> SUPPORTED_EXTENSION_INTERFACES = Collections.unmodifiableMap(Stream.of(ContainerRequestFilter.class, ContainerResponseFilter.class, ReaderInterceptor.class, WriterInterceptor.class, MessageBodyReader.class, MessageBodyWriter.class, ContextResolver.class, ExceptionMapper.class, ParamConverterProvider.class, javax.ws.rs.core.Feature.class, DynamicFeature.class, Feature.class, ContextProvider.class).collect(Collectors.toMap(Class::getName, Function.identity())));
    static final String DEFAULT_NAME = ".default";
    private static final Logger _log = LoggerFactory.getLogger(Whiteboard.class);
    private final String _applicationBasePrefix;
    private final ApplicationExtensionRegistry _applicationExtensionRegistry;
    private final ExtensionRegistry _extensionRegistry;
    private final AriesJaxrsServiceRuntime _runtime = new AriesJaxrsServiceRuntime(this);
    private final Map<String, ?> _configurationMap;
    private volatile BundleContext _bundleContext;
    private volatile ServiceRegistrationChangeCounter _counter;
    private volatile ServiceReference<JaxrsServiceRuntime> _runtimeReference;
    private final OSGi<Void> _program;
    private final List<Object> _endpoints;
    private volatile ServiceRegistration<JaxrsServiceRuntime> _runtimeRegistration;
    private OSGiResult _osgiResult;
    private static final Filter _extensionsFilter;
    private static final Filter _resourcesFilter;
    private static Filter _applicationsFilter;

    private Whiteboard(Dictionary<String, ?> configuration) {
        this._configurationMap = Maps.from(configuration);
        this._endpoints = new ArrayList<Object>();
        this._applicationExtensionRegistry = new ApplicationExtensionRegistry();
        this._extensionRegistry = new ExtensionRegistry();
        this._applicationBasePrefix = Utils.canonicalizeAddress(Utils.getString(this._configurationMap.get("application.base.prefix")));
        this._program = OSGi.all((OSGi[])new OSGi[]{OSGi.ignore(this.registerDefaultApplication()), OSGi.ignore(this.getAllServices())});
    }

    public static Whiteboard createWhiteboard(Dictionary<String, ?> configuration) {
        return new Whiteboard(configuration);
    }

    public void start(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._runtimeRegistration = this.registerJaxRSServiceRuntime(new HashMap<String, Object>(this._configurationMap));
        this._runtimeReference = this._runtimeRegistration.getReference();
        this._counter = new ServiceRegistrationChangeCounter(this._runtimeRegistration);
        this._osgiResult = this._program.run(bundleContext);
    }

    public void stop() {
        this._osgiResult.close();
        this._runtimeRegistration.unregister();
        this._applicationExtensionRegistry.close();
        this._extensionRegistry.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpEndpoints(List<String> endpoints) {
        ServiceRegistration<JaxrsServiceRuntime> serviceRegistration = this._runtimeRegistration;
        synchronized (serviceRegistration) {
            this._endpoints.addAll(endpoints);
            Utils.updateProperty(this._runtimeRegistration, "osgi.jaxrs.endpoint", this._endpoints);
        }
    }

    public ServiceReference<JaxrsServiceRuntime> getServiceReference() {
        return this._runtimeReference;
    }

    private OSGi<?> applicationExtensions(OSGi<CachingServiceReference<Object>> extensions) {
        return Whiteboard.onlyValid(Whiteboard.onlySupportedInterfaces(extensions, this._runtime::addInvalidExtension, this._runtime::removeInvalidExtension), this._runtime::addInvalidExtension, this._runtime::removeInvalidExtension).effects(this._extensionRegistry::registerExtension, this._extensionRegistry::unregisterExtension).flatMap(extensionReference -> this.chooseApplication((CachingServiceReference<?>)extensionReference, this._runtime::addApplicationDependentExtension, this._runtime::removeApplicationDependentExtension).flatMap(registratorReference -> Utils.service(registratorReference).flatMap(registrator -> this.waitForExtensionDependencies((CachingServiceReference<?>)extensionReference, (CachingServiceReference<CxfJaxrsServiceRegistrator>)registratorReference, this._runtime::addDependentExtension, this._runtime::removeDependentExtension).then(this.safeRegisterExtension((CachingServiceReference<?>)extensionReference, arg_0 -> ((CachingServiceReference)registratorReference).getProperty(arg_0), (CxfJaxrsServiceRegistrator)registrator)))));
    }

    private OSGi<?> applicationResources(OSGi<CachingServiceReference<Object>> resources) {
        return Whiteboard.onlyValid(resources, this._runtime::addInvalidResource, this._runtime::removeInvalidResource).flatMap(resourceReference -> this.chooseApplication((CachingServiceReference<?>)resourceReference, this._runtime::addApplicationDependentResource, this._runtime::removeApplicationDependentResource).flatMap(registratorReference -> Utils.service(registratorReference).flatMap(registrator -> this.waitForExtensionDependencies((CachingServiceReference<?>)resourceReference, (CachingServiceReference<CxfJaxrsServiceRegistrator>)registratorReference, this._runtime::addDependentService, this._runtime::removeDependentService).then(this.safeRegisterEndpoint((CachingServiceReference)resourceReference, arg_0 -> ((CachingServiceReference)registratorReference).getProperty(arg_0), (CxfJaxrsServiceRegistrator)registrator)))));
    }

    private OSGi<?> getAllServices() {
        OSGi<CachingServiceReference<Application>> applicationsForWhiteboard = this.getApplicationsForWhiteboard();
        return Utils.highestPer(sr -> OSGi.just((Object)AriesJaxrsServiceRuntime.getServiceName(arg_0 -> ((CachingServiceReference)sr).getProperty(arg_0))), this.countChanges(OSGi.all((OSGi[])new OSGi[]{this.getResourcesForWhiteboard(), this.getApplicationExtensionsForWhiteboard(), applicationsForWhiteboard})), this::registerShadowedService, this::unregisterShadowedService).effects(this._runtime::addServiceForName, this._runtime::removedServiceForName).distribute(new Function[]{p -> OSGi.ignore(this.applications((OSGi<CachingServiceReference<Application>>)p.filter(this::isApplication))), p -> OSGi.ignore(this.applicationResources((OSGi<CachingServiceReference<Object>>)p.filter(this::isResource))), p -> OSGi.ignore(this.applicationExtensions((OSGi<CachingServiceReference<Object>>)p.filter(this::isExtension)))});
    }

    private boolean isApplication(CachingServiceReference<?> sr) {
        return _applicationsFilter.match(sr.getServiceReference());
    }

    private boolean isExtension(CachingServiceReference<?> sr) {
        return _extensionsFilter.match(sr.getServiceReference());
    }

    private boolean isResource(CachingServiceReference<?> sr) {
        return _resourcesFilter.match(sr.getServiceReference());
    }

    private <T> boolean matchesWhiteboard(CachingServiceReference<T> ref) {
        Filter filter;
        String target = (String)ref.getProperty("osgi.jaxrs.whiteboard.target");
        if (target == null) {
            return true;
        }
        try {
            filter = FrameworkUtil.createFilter((String)target);
        }
        catch (InvalidSyntaxException ise) {
            if (_log.isErrorEnabled()) {
                _log.error("Invalid '{}' filter syntax in {}", (Object)"osgi.jaxrs.whiteboard.target", ref);
            }
            return false;
        }
        return filter.match(this._runtimeReference);
    }

    private void registerShadowedService(CachingServiceReference<?> sr) {
        if (this.isApplication(sr)) {
            this._runtime.addClashingApplication(sr);
        }
        if (this.isExtension(sr)) {
            this._runtime.addClashingExtension(sr);
        }
        if (this.isResource(sr)) {
            this._runtime.addClashingResource(sr);
        }
    }

    private void unregisterShadowedService(CachingServiceReference<?> sr) {
        if (this.isApplication(sr)) {
            this._runtime.removeClashingApplication(sr);
        }
        if (this.isExtension(sr)) {
            this._runtime.removeClashingExtension(sr);
        }
        if (this.isResource(sr)) {
            this._runtime.removeClashingResource(sr);
        }
    }

    private static <T> OSGi<CachingServiceReference<T>> onlyValid(OSGi<CachingServiceReference<T>> serviceReferences, Consumer<CachingServiceReference<T>> onAddingInvalid, Consumer<CachingServiceReference<T>> onRemovingInvalid) {
        return serviceReferences.flatMap(serviceReference -> {
            OSGi error = OSGi.effects(() -> onAddingInvalid.accept((CachingServiceReference)serviceReference), () -> onRemovingInvalid.accept((CachingServiceReference)serviceReference)).effects(LogUtils.ifDebugEnabled(_log, () -> "Invalid service {}"), LogUtils.ifDebugEnabled(_log, () -> "Invalid service {} is gone")).then(OSGi.nothing());
            Object propertyObject = serviceReference.getProperty("osgi.jaxrs.name");
            if (propertyObject != null && !propertyObject.toString().equals(DEFAULT_NAME) && propertyObject.toString().startsWith(".")) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Invalid property {} in service {}", (Object)DEFAULT_NAME, serviceReference);
                }
                return error;
            }
            if (!Whiteboard.testFilters(serviceReference.getProperty("osgi.jaxrs.application.select"))) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Invalid value for property {} in service {}", (Object)"osgi.jaxrs.application.select", serviceReference);
                }
                return error;
            }
            if (!Whiteboard.testFilters(serviceReference.getProperty("osgi.jaxrs.extension.select"))) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Invalid value for property {} in service {}", (Object)"osgi.jaxrs.extension.select", serviceReference);
                }
                return error;
            }
            return OSGi.just((Object)serviceReference);
        });
    }

    private static boolean testFilters(Object propertyObject) {
        if (propertyObject != null) {
            try {
                String[] properties;
                for (String property : properties = Utils.canonicalize(propertyObject)) {
                    FrameworkUtil.createFilter((String)property);
                }
            }
            catch (InvalidSyntaxException e) {
                return false;
            }
        }
        return true;
    }

    private OSGi<ApplicationReferenceWithContext> waitForApplicationContext(OSGi<CachingServiceReference<Application>> application, Consumer<CachingServiceReference<Application>> onWaitingForContext, Consumer<CachingServiceReference<Application>> onResolvedContext) {
        return application.flatMap(serviceReference -> {
            Object propertyObject = serviceReference.getProperty("osgi.http.whiteboard.context.select");
            if (propertyObject == null && (propertyObject = this._configurationMap.get("osgi.http.whiteboard.context.select")) == null) {
                return OSGi.just((Object)new ApplicationReferenceWithContext(null, (CachingServiceReference<Application>)serviceReference));
            }
            String contextSelect = propertyObject.toString();
            try {
                FrameworkUtil.createFilter((String)contextSelect);
            }
            catch (InvalidSyntaxException e) {
                return OSGi.effects(() -> this._runtime.addInvalidApplication((CachingServiceReference<?>)serviceReference), () -> this._runtime.removeInvalidApplication((CachingServiceReference<?>)serviceReference)).then(OSGi.nothing());
            }
            return OSGi.effects(() -> onWaitingForContext.accept((CachingServiceReference<Application>)serviceReference), () -> onResolvedContext.accept((CachingServiceReference<Application>)serviceReference)).then(org.apache.aries.component.dsl.Utils.highest((OSGi)OSGi.serviceReferences(ServletContextHelper.class, (String)contextSelect)).flatMap(sr -> OSGi.just((Object)new ApplicationReferenceWithContext((CachingServiceReference<ServletContextHelper>)sr, (CachingServiceReference<Application>)serviceReference))).effects(__ -> onResolvedContext.accept((CachingServiceReference<Application>)serviceReference), __ -> onWaitingForContext.accept((CachingServiceReference<Application>)serviceReference)));
        });
    }

    private OSGi<?> applications(OSGi<CachingServiceReference<Application>> applications) {
        OSGi<CachingServiceReference<Application>> applicationsForWhiteboard = this.waitForApplicationDependencies(Whiteboard.onlyValid(applications, this._runtime::addInvalidApplication, this._runtime::removeInvalidApplication));
        OSGi<ApplicationReferenceWithContext> applicationsWithContext = this.waitForApplicationContext(applicationsForWhiteboard, this._runtime::addContextDependentApplication, this._runtime::removeContextDependentApplication);
        OSGi<ApplicationReferenceWithContext> highestRankedPerPath = Utils.highestPer(arwc -> OSGi.just((Object)arwc.getActualBasePath()), applicationsWithContext, t -> this._runtime.addShadowedApplication(t.getApplicationReference(), t.getActualBasePath()), t -> this._runtime.removeShadowedApplication(t.getApplicationReference()));
        return highestRankedPerPath.flatMap(application -> Utils.onlyGettables(OSGi.just(application.getApplicationReference()), this._runtime::addNotGettableApplication, this._runtime::removeNotGettableApplication, _log).recoverWith((t, e) -> OSGi.just((Object)t).map(ServiceTuple::getCachingServiceReference).effects(this._runtime::addErroredApplication, this._runtime::removeErroredApplication).then(OSGi.nothing())).flatMap(at -> this.deployApplication((ServiceTuple<Application>)at, application.getContextReference()).foreach(registrator -> this._runtime.setApplicationForPath(this.getApplicationBase(arg_0 -> at.getCachingServiceReference().getProperty(arg_0)), (CachingServiceReference<Application>)at.getCachingServiceReference(), (CxfJaxrsServiceRegistrator)registrator), registrator -> this._runtime.unsetApplicationForPath(this.getApplicationBase(arg_0 -> at.getCachingServiceReference().getProperty(arg_0))))));
    }

    private ExtensionManagerBus createBus(Map<String, ServiceTuple<Object>> extensions) {
        BundleWiring wiring = (BundleWiring)this._bundleContext.getBundle().adapt(BundleWiring.class);
        HashMap properties = new HashMap(this._configurationMap);
        HashMap cxfExtensions = new HashMap();
        if (extensions.isEmpty()) {
            cxfExtensions = null;
        } else {
            for (Map.Entry<String, ServiceTuple<Object>> entry : extensions.entrySet()) {
                String className = entry.getKey();
                ServiceTuple<Object> serviceTuple = entry.getValue();
                ClassLoader classLoader = this.getClassLoader(serviceTuple);
                try {
                    Class<?> clazz = classLoader.loadClass(className);
                    cxfExtensions.put(clazz, serviceTuple.getService());
                }
                catch (Exception e) {
                    if (!_log.isErrorEnabled()) continue;
                    _log.error("Could not load extension for CXF bus", (Throwable)e);
                }
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Creating CXF Bus with extensions {} and properties {}", extensions, properties);
        }
        ExtensionManagerBus bus = new ExtensionManagerBus(cxfExtensions, properties, wiring.getClassLoader());
        bus.initialize();
        if (_log.isDebugEnabled()) {
            _log.debug("Created CXF Bus with extensions {} and properties {}", extensions, properties);
        }
        return bus;
    }

    private OSGi<CachingServiceReference<CxfJaxrsServiceRegistrator>> applicationMatching(String filter) {
        return OSGi.serviceReferences(CxfJaxrsServiceRegistrator.class, (String)filter).filter(this::matchesWhiteboard);
    }

    private OSGi<CxfJaxrsServiceRegistrator> deployApplication(ServiceTuple<Application> tuple, CachingServiceReference<ServletContextHelper> contextReference) {
        Supplier<Map> properties = () -> {
            CachingServiceReference serviceReference = tuple.getCachingServiceReference();
            Map<String, Object> props = Utils.getApplicationProperties(serviceReference);
            props.put("original.service.id", serviceReference.getProperty("service.id"));
            props.put("original.service.bundleid", serviceReference.getProperty("service.bundleid"));
            return props;
        };
        return this.getCxfExtensions(tuple.getCachingServiceReference()).flatMap(extensions -> this.createRegistrator((Map<String, ServiceTuple<Object>>)extensions, tuple, (Supplier<Map<String, ?>>)properties).flatMap(arg_0 -> this.lambda$null$33((Supplier)properties, contextReference, arg_0)));
    }

    public OSGi<Map<String, ServiceTuple<Object>>> getCxfExtensions(CachingServiceReference<Application> applicationReference) {
        OSGi cxfExtensionsForApplication = Utils.onlyGettables(OSGi.serviceReferences((String)"(cxf.extension=true)").filter(sr -> {
            Object appFilter = sr.getProperty("osgi.jaxrs.application.select");
            if (appFilter == null) {
                return true;
            }
            try {
                Filter filter = FrameworkUtil.createFilter((String)appFilter.toString());
                return filter.match(applicationReference.getServiceReference());
            }
            catch (InvalidSyntaxException e) {
                return false;
            }
        }).filter(this::matchesWhiteboard), __ -> {}, __ -> {}, _log);
        return org.apache.aries.component.dsl.Utils.accumulateInMap(cxfExtensionsForApplication, st -> OSGi.just(Arrays.asList(Utils.canonicalize(st.getCachingServiceReference().getProperty("objectClass")))), OSGi::just);
    }

    private ClassLoader getClassLoader(ServiceTuple<?> serviceTuple) {
        return ((BundleWiring)serviceTuple.getCachingServiceReference().getServiceReference().getBundle().adapt(BundleWiring.class)).getClassLoader();
    }

    private OSGi<CxfJaxrsServiceRegistrator> createRegistrator(Map<String, ServiceTuple<Object>> extensions, ServiceTuple<Application> tuple, Supplier<Map<String, ?>> props) {
        return OSGi.just(() -> new CxfJaxrsServiceRegistrator((Bus)this.createBus(extensions), tuple, (Map)props.get())).effects(__ -> {}, __ -> {}, CxfJaxrsServiceRegistrator::close, __ -> {});
    }

    private OSGi<CachingServiceReference<Object>> getApplicationExtensionsForWhiteboard() {
        return OSGi.serviceReferences((String)_extensionsFilter.toString()).filter(this::matchesWhiteboard);
    }

    private OSGi<CachingServiceReference<Application>> getApplicationsForWhiteboard() {
        return OSGi.serviceReferences(Application.class, (String)_applicationsFilter.toString()).filter(this::matchesWhiteboard);
    }

    private OSGi<CachingServiceReference<Object>> getResourcesForWhiteboard() {
        return OSGi.serviceReferences((String)_resourcesFilter.toString()).filter(this::matchesWhiteboard);
    }

    private OSGi<ServiceRegistration<Application>> registerDefaultApplication() {
        return OSGi.register(Application.class, () -> new DefaultApplication(){

            public Set<Object> getSingletons() {
                Object defaultApplication = Whiteboard.this._configurationMap.get("default.web");
                if (defaultApplication == null || Boolean.parseBoolean(defaultApplication.toString())) {
                    return Collections.singleton(new DefaultWeb());
                }
                return Collections.emptySet();
            }
        }, () -> {
            Object defaultApplicationBase = this._configurationMap.get("default.application.base");
            if (defaultApplicationBase == null || !(defaultApplicationBase instanceof String)) {
                defaultApplicationBase = "/";
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            Utils.mergePropertyMaps(properties, this._configurationMap);
            properties.put("osgi.jaxrs.name", DEFAULT_NAME);
            properties.put("osgi.jaxrs.application.base", defaultApplicationBase);
            properties.put("service.ranking", Integer.MIN_VALUE);
            properties.put("osgi.jaxrs.whiteboard.target", "(service.pid=" + this._configurationMap.get("service.pid") + ")");
            return properties;
        });
    }

    private ServiceRegistration<JaxrsServiceRuntime> registerJaxRSServiceRuntime(Map<String, Object> properties) {
        properties.putIfAbsent("service.ranking", Integer.MIN_VALUE);
        return this._bundleContext.registerService(JaxrsServiceRuntime.class, (Object)this._runtime, new Hashtable<String, Object>(properties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHttpEndpoints(List<String> endpoints) {
        ServiceRegistration<JaxrsServiceRuntime> serviceRegistration = this._runtimeRegistration;
        synchronized (serviceRegistration) {
            this._endpoints.removeAll(endpoints);
            Utils.updateProperty(this._runtimeRegistration, "osgi.jaxrs.endpoint", this._endpoints);
        }
    }

    private <T> OSGi<?> safeRegisterEndpoint(CachingServiceReference<T> serviceReference, PropertyHolder registratorProperties, CxfJaxrsServiceRegistrator registrator) {
        Bundle originalBundle = this._bundleContext.getBundle(((Long)registratorProperties.get("original.service.bundleid")).longValue());
        return OSGi.changeContext((BundleContext)originalBundle.getBundleContext(), Utils.onlyGettables(OSGi.just(serviceReference), this._runtime::addNotGettableEndpoint, this._runtime::removeNotGettableEndpoint, _log)).recoverWith((t, e) -> OSGi.just((Object)serviceReference).effects(this._runtime::addErroredEndpoint, this._runtime::removeErroredEndpoint).effects(LogUtils.ifErrorEnabled(_log, () -> "ServiceReference {} for endpoint produced error: {}", e), LogUtils.ifErrorEnabled(_log, () -> "Errored ServiceReference {} for endpoint left")).then(OSGi.nothing())).flatMap(st -> OSGi.just((Object)st).map(Utils::getResourceProvider).effects(rp -> this._runtime.addApplicationEndpoint(registratorProperties, st.getCachingServiceReference(), registrator.getBus(), st.getService().getClass()), rp -> this._runtime.removeApplicationEndpoint(registratorProperties, st.getCachingServiceReference())).effects(registrator::add, registrator::remove).effects(LogUtils.ifDebugEnabled(_log, () -> "Registered endpoint " + st.getCachingServiceReference().getServiceReference() + " into application " + AriesJaxrsServiceRuntime.getServiceName(registratorProperties)), LogUtils.ifDebugEnabled(_log, () -> "Unregistered endpoint " + st.getCachingServiceReference().getServiceReference() + " from application " + AriesJaxrsServiceRuntime.getServiceName(registratorProperties))));
    }

    private OSGi<?> safeRegisterExtension(CachingServiceReference<?> serviceReference, PropertyHolder registratorProperties, CxfJaxrsServiceRegistrator registrator) {
        Bundle originalBundle = this._bundleContext.getBundle(((Long)registratorProperties.get("original.service.bundleid")).longValue());
        return OSGi.just(() -> AriesJaxrsServiceRuntime.getServiceName(registratorProperties)).flatMap(applicationName -> OSGi.changeContext((BundleContext)originalBundle.getBundleContext(), Utils.onlyGettables(OSGi.just((Object)serviceReference), this._runtime::addNotGettableExtension, this._runtime::removeNotGettableExtension, _log)).recoverWith((t, e) -> OSGi.just(t.getCachingServiceReference()).effects(this._runtime::addErroredExtension, this._runtime::removeErroredExtension).effects(LogUtils.ifErrorEnabled(_log, () -> "ServiceReference {} for extension produced error: {}", e), LogUtils.ifErrorEnabled(_log, () -> "Errored ServiceReference {} for extension left")).then(OSGi.nothing())).effects(registrator::addProvider, registrator::removeProvider).effects(t -> this._runtime.addApplicationExtension(registratorProperties, serviceReference, t.getService().getClass()), __ -> this._runtime.removeApplicationExtension(registratorProperties, serviceReference)).effects(LogUtils.ifDebugEnabled(_log, () -> "Registered extension " + serviceReference.getServiceReference() + " into application " + AriesJaxrsServiceRuntime.getServiceName(registratorProperties)), LogUtils.ifDebugEnabled(_log, () -> "Unregistered extension  " + serviceReference.getServiceReference() + " from application " + AriesJaxrsServiceRuntime.getServiceName(registratorProperties))).effects(__ -> this._applicationExtensionRegistry.registerExtensionInApplication((String)applicationName, serviceReference), __ -> this._applicationExtensionRegistry.unregisterExtensionInApplication((String)applicationName, serviceReference)));
    }

    private OSGi<CachingServiceReference<Application>> waitForApplicationDependencies(OSGi<CachingServiceReference<Application>> references) {
        return references.flatMap(reference -> {
            String[] extensionDependencies = Utils.canonicalize(reference.getProperty("osgi.jaxrs.extension.select"));
            OSGi program = OSGi.just((Object)reference);
            if (extensionDependencies.length == 0) {
                return program;
            }
            for (String extensionDependency : extensionDependencies) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Application {} has a dependency on {}", reference, (Object)extensionDependency);
                }
                try {
                    Filter extensionFilter = this._bundleContext.createFilter(extensionDependency);
                    if (extensionFilter.match(this._runtimeReference)) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug("Application dependency {} provided by whiteboard {}", (Object)extensionDependency, this._runtimeReference);
                        continue;
                    }
                }
                catch (InvalidSyntaxException e) {
                    return program.effects(LogUtils.ifErrorEnabled(_log, () -> String.format("Application %s has invalid dependency %s", reference, extensionDependency)), LogUtils.ifErrorEnabled(_log, () -> String.format("Application %s with invalid dependency has left", reference))).effects(this._runtime::addErroredApplication, this._runtime::removeErroredApplication).then(OSGi.nothing());
                }
                program = OSGi.once((OSGi)this._extensionRegistry.waitForExtension(extensionDependency).flatMap(sr -> {
                    Filter filter;
                    Object applicationSelectProperty = sr.getProperty("osgi.jaxrs.application.select");
                    if (applicationSelectProperty == null) {
                        return OSGi.just((Object)reference);
                    }
                    try {
                        filter = this._bundleContext.createFilter(applicationSelectProperty.toString());
                    }
                    catch (InvalidSyntaxException e) {
                        return OSGi.nothing();
                    }
                    if (filter.matches(Utils.getApplicationProperties(reference))) {
                        return OSGi.just((Object)reference);
                    }
                    return OSGi.nothing();
                })).effects(__ -> {}, __ -> this._runtime.addDependentApplication((CachingServiceReference<Application>)reference)).effects(LogUtils.ifDebugEnabled(_log, () -> "Application " + reference + " dependency " + extensionDependency + " has been fullfiled"), LogUtils.ifDebugEnabled(_log, () -> "Application " + reference + " dependency " + extensionDependency + " has gone")).then(program);
            }
            program = OSGi.effects(() -> this._runtime.addDependentApplication((CachingServiceReference<Application>)reference), () -> this._runtime.removeDependentApplication((CachingServiceReference<Application>)reference)).then(program);
            program = program.effects(__ -> this._runtime.removeDependentApplication((CachingServiceReference<Application>)reference), __ -> {});
            return program;
        });
    }

    private OSGi<?> waitForExtensionDependencies(CachingServiceReference<?> reference, CachingServiceReference<CxfJaxrsServiceRegistrator> applicationRegistratorReference, Consumer<CachingServiceReference<?>> onAddingDependent, Consumer<CachingServiceReference<?>> onRemovingDependent) {
        String applicationName = AriesJaxrsServiceRuntime.getServiceName(arg_0 -> applicationRegistratorReference.getProperty(arg_0));
        String[] extensionDependencies = Utils.canonicalize(reference.getProperty("osgi.jaxrs.extension.select"));
        OSGi program = OSGi.just(reference);
        if (extensionDependencies.length == 0) {
            return program;
        }
        for (String extensionDependency : extensionDependencies) {
            if (_log.isDebugEnabled()) {
                _log.debug("Extension {} has a dependency on {}", reference, (Object)extensionDependency);
            }
            try {
                String finalExtensionDependency = extensionDependency.replace("(objectClass=", "(original.objectClass=");
                Filter extensionFilter = this._bundleContext.createFilter(finalExtensionDependency);
                if (extensionFilter.match(this._runtimeReference) || extensionFilter.match(applicationRegistratorReference.getServiceReference())) continue;
                program = OSGi.once((OSGi)this._applicationExtensionRegistry.waitForApplicationExtension(applicationName, extensionDependency).effects(__ -> {}, __ -> onAddingDependent.accept(reference))).effects(LogUtils.ifDebugEnabled(_log, () -> "Extension " + reference + " dependency " + extensionDependency + " has been fullfiled"), LogUtils.ifDebugEnabled(_log, () -> "Extension " + reference + " dependency " + extensionDependency + " has gone")).then(program);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        program = OSGi.effects(() -> onAddingDependent.accept(reference), () -> onRemovingDependent.accept(reference)).then(program);
        program = program.effects(__ -> onRemovingDependent.accept(reference), __ -> {});
        return program;
    }

    String getApplicationBase(PropertyHolder properties) {
        return this._applicationBasePrefix + Utils.getString(properties.get("osgi.jaxrs.application.base"));
    }

    private OSGi<CachingServiceReference<CxfJaxrsServiceRegistrator>> chooseApplication(CachingServiceReference<?> serviceReference, Consumer<CachingServiceReference<?>> onWaiting, Consumer<CachingServiceReference<?>> onResolved) {
        Object applicationSelectProperty = serviceReference.getProperty("osgi.jaxrs.application.select");
        if (applicationSelectProperty == null) {
            return this.applicationMatching(String.format("(%s=%s)", "osgi.jaxrs.name", DEFAULT_NAME));
        }
        return OSGi.just(AtomicInteger::new).flatMap(counter -> OSGi.effects(() -> onWaiting.accept(serviceReference), () -> {
            onResolved.accept(serviceReference);
            counter.set(0);
        }).then(this.applicationMatching(applicationSelectProperty.toString()).effects(__ -> {
            if (counter.getAndIncrement() == 0) {
                onResolved.accept(serviceReference);
            }
        }, __ -> {
            if (counter.decrementAndGet() == 0) {
                onWaiting.accept(serviceReference);
            }
        })));
    }

    private <T> OSGi<T> countChanges(OSGi<T> program) {
        return program.effects(__ -> {}, __ -> this._counter.inc(), __ -> {}, __ -> this._counter.inc());
    }

    private static CXFNonSpringServlet createCXFServlet(Bus bus) {
        CXFNonSpringServlet cxfNonSpringServlet = new CXFNonSpringServlet(){

            public void destroyBus() {
            }
        };
        cxfNonSpringServlet.setBus(bus);
        return cxfNonSpringServlet;
    }

    private static OSGi<CachingServiceReference<Object>> onlySupportedInterfaces(OSGi<CachingServiceReference<Object>> program, Consumer<CachingServiceReference<?>> onInvalidAdded, Consumer<CachingServiceReference<?>> onInvalidRemoved) {
        return program.flatMap(sr -> {
            if (Whiteboard.signalsValidInterface((CachingServiceReference<Object>)sr)) {
                return OSGi.just((Object)sr);
            }
            return OSGi.effects(() -> onInvalidAdded.accept((CachingServiceReference<?>)sr), () -> onInvalidRemoved.accept((CachingServiceReference<?>)sr)).then(OSGi.nothing());
        });
    }

    private OSGi<ServiceRegistration<Servlet>> registerCXFServletService(final Bus bus, Supplier<Map<String, ?>> servicePropertiesSup, CachingServiceReference<ServletContextHelper> contextReference) {
        Supplier<Map> contextPropertiesSup;
        Map<String, ?> serviceProperties = servicePropertiesSup.get();
        String address = Utils.canonicalizeAddress(this.getApplicationBase(serviceProperties::get));
        String applicationName = AriesJaxrsServiceRuntime.getServiceName(serviceProperties::get);
        OSGi program = OSGi.effects((Runnable)OSGi.NOOP, (Runnable)OSGi.NOOP);
        if (contextReference == null) {
            contextPropertiesSup = () -> {
                HashMap<String, Object> contextProperties = new HashMap<String, Object>();
                Utils.mergePropertyMaps(contextProperties, serviceProperties);
                Utils.mergePropertyMaps(contextProperties, this._configurationMap);
                contextProperties.putIfAbsent("osgi.http.whiteboard.target", "(osgi.http.endpoint=*)");
                String contextName = "".equals(address) ? "default" : "context.for" + applicationName;
                contextProperties.put("osgi.http.whiteboard.context.name", contextName);
                contextProperties.put("osgi.http.whiteboard.context.path", address.equals("") ? "/" : address);
                return contextProperties;
            };
            program = OSGi.register(ServletContextHelper.class, () -> new ServletContextHelper(){}, contextPropertiesSup);
        } else {
            contextPropertiesSup = () -> {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("osgi.http.whiteboard.context.name", contextReference.getProperty("osgi.http.whiteboard.context.name"));
                return properties;
            };
        }
        Supplier<Map> servletPropertiesSup = () -> {
            HashMap<String, Object> servletProperties = new HashMap<String, Object>();
            Utils.mergePropertyMaps(servletProperties, serviceProperties);
            Utils.mergePropertyMaps(servletProperties, this._configurationMap);
            servletProperties.putIfAbsent("osgi.http.whiteboard.target", "(osgi.http.endpoint=*)");
            Map contextProperties = (Map)contextPropertiesSup.get();
            servletProperties.put("osgi.http.whiteboard.context.select", String.format("(%s=%s)", "osgi.http.whiteboard.context.name", contextProperties.get("osgi.http.whiteboard.context.name")));
            if (contextReference == null) {
                servletProperties.put("osgi.http.whiteboard.servlet.pattern", "/*");
            } else {
                servletProperties.put("osgi.http.whiteboard.servlet.pattern", address + "/*");
            }
            servletProperties.put("osgi.http.whiteboard.servlet.asyncSupported", true);
            servletProperties.put("osgi.http.whiteboard.servlet.name", "cxf-servlet");
            return servletProperties;
        };
        return program.then(OSGi.register(Servlet.class, (ServiceFactory)new PrototypeServiceFactory<Servlet>(){

            public Servlet getService(Bundle bundle, ServiceRegistration<Servlet> registration) {
                return Whiteboard.createCXFServlet(bus);
            }

            public void ungetService(Bundle bundle, ServiceRegistration<Servlet> registration, Servlet service) {
            }
        }, servletPropertiesSup));
    }

    private static boolean signalsValidInterface(CachingServiceReference<Object> serviceReference) {
        String[] objectClasses = Utils.canonicalize(serviceReference.getProperty("objectClass"));
        return Arrays.stream(objectClasses).anyMatch(SUPPORTED_EXTENSION_INTERFACES::containsKey);
    }

    private /* synthetic */ OSGi lambda$null$33(Supplier properties, CachingServiceReference contextReference, CxfJaxrsServiceRegistrator registrator) {
        return this.registerCXFServletService(registrator.getBus(), properties, (CachingServiceReference<ServletContextHelper>)contextReference).then(OSGi.register(CxfJaxrsServiceRegistrator.class, () -> registrator, (Supplier)properties).then(OSGi.just((Object)registrator)));
    }

    static {
        try {
            _applicationsFilter = FrameworkUtil.createFilter((String)String.format("(&(objectClass=%s)(%s=*))", Application.class.getName(), "osgi.jaxrs.application.base"));
            _extensionsFilter = FrameworkUtil.createFilter((String)String.format("(%s=true)", "osgi.jaxrs.extension"));
            _resourcesFilter = FrameworkUtil.createFilter((String)String.format("(%s=true)", "osgi.jaxrs.resource"));
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private class ApplicationReferenceWithContext
    implements Comparable<ApplicationReferenceWithContext> {
        private CachingServiceReference<ServletContextHelper> _contextReference;
        private CachingServiceReference<Application> _applicationReference;

        @Override
        public int compareTo(ApplicationReferenceWithContext o) {
            return this._applicationReference.compareTo(o._applicationReference);
        }

        public ApplicationReferenceWithContext(CachingServiceReference<ServletContextHelper> contextReference, CachingServiceReference<Application> applicationReference) {
            this._contextReference = contextReference;
            this._applicationReference = applicationReference;
        }

        public String getActualBasePath() {
            String applicationBase = Whiteboard.this.getApplicationBase(arg_0 -> this._applicationReference.getProperty(arg_0));
            if (this._contextReference == null) {
                return applicationBase;
            }
            Object property = this._contextReference.getProperty("osgi.http.whiteboard.context.path");
            if (property == null) {
                return applicationBase;
            }
            String contextPath = property.toString();
            return contextPath + applicationBase;
        }

        public CachingServiceReference<ServletContextHelper> getContextReference() {
            return this._contextReference;
        }

        public CachingServiceReference<Application> getApplicationReference() {
            return this._applicationReference;
        }
    }

    private static class ServiceRegistrationChangeCounter
    implements ChangeCounter {
        private static final String changecount = "service.changecount";
        private final AtomicLong _atomicLong = new AtomicLong();
        private final ServiceRegistration<?> _serviceRegistration;

        ServiceRegistrationChangeCounter(ServiceRegistration<?> serviceRegistration) {
            this._serviceRegistration = serviceRegistration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void inc() {
            long l = this._atomicLong.incrementAndGet();
            ServiceRegistration<?> serviceRegistration = this._serviceRegistration;
            synchronized (serviceRegistration) {
                Utils.updateProperty(this._serviceRegistration, changecount, l);
            }
        }
    }

    private static interface ChangeCounter {
        public void inc();
    }
}

