/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.component.dsl.Publisher;
import org.osgi.framework.Filter;

public class FilteredPublisher
implements AutoCloseable {
    private Publisher<? super CachingServiceReference<?>> _publisher;
    private Filter _filter;
    private AtomicBoolean _closed = new AtomicBoolean(false);
    private Map<CachingServiceReference<?>, OSGiResult> _results = new HashMap();

    public FilteredPublisher(Publisher<? super CachingServiceReference<?>> publisher, Filter filter) {
        this._publisher = publisher;
        this._filter = filter;
    }

    @Override
    public void close() {
        if (this._closed.compareAndSet(false, true)) {
            this._results.forEach((__, result) -> result.close());
            this._results.clear();
        }
    }

    public void publishIfMatched(CachingServiceReference<?> serviceReference) {
        if (this._closed.get()) {
            return;
        }
        if (this._filter.match(serviceReference.getServiceReference())) {
            OSGiResult result = this._publisher.publish(serviceReference);
            OSGiResult old = this._results.put(serviceReference, result);
            if (old != null) {
                old.close();
            }
            if (this._closed.get()) {
                result.close();
            }
        }
    }

    public void retractIfMatched(CachingServiceReference<?> serviceReference) {
        OSGiResult result;
        if (this._closed.get()) {
            return;
        }
        if (this._filter.match(serviceReference.getServiceReference()) && (result = this._results.remove(serviceReference)) != null) {
            result.close();
        }
    }
}

