/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal;

import java.util.HashSet;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.jax.rs.whiteboard.internal.FilteredPublisher;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class ExtensionRegistry
implements AutoCloseable {
    private final HashSet<FilteredPublisher> _extensionPublishers = new HashSet();
    private final HashSet<CachingServiceReference<?>> _registeredExtensions = new HashSet();

    @Override
    public void close() {
        for (FilteredPublisher extensionPublisher : new HashSet<FilteredPublisher>(this._extensionPublishers)) {
            extensionPublisher.close();
        }
    }

    public OSGi<CachingServiceReference<?>> waitForExtension(String extensionFilter) {
        Filter filter;
        try {
            filter = FrameworkUtil.createFilter((String)extensionFilter);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException();
        }
        return OSGi.fromOsgiRunnable((bc, p) -> {
            ExtensionRegistry extensionRegistry = this;
            synchronized (extensionRegistry) {
                FilteredPublisher ep = new FilteredPublisher(p, filter);
                this._extensionPublishers.add(ep);
                for (CachingServiceReference<?> extension : new HashSet(this._registeredExtensions)) {
                    ep.publishIfMatched(extension);
                }
                return () -> {
                    ExtensionRegistry extensionRegistry = this;
                    synchronized (extensionRegistry) {
                        this._extensionPublishers.remove(ep);
                        for (CachingServiceReference<?> extension : new HashSet(this._registeredExtensions)) {
                            ep.retractIfMatched(extension);
                        }
                    }
                };
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExtension(CachingServiceReference<?> extension) {
        ExtensionRegistry extensionRegistry = this;
        synchronized (extensionRegistry) {
            for (FilteredPublisher publisher : new HashSet<FilteredPublisher>(this._extensionPublishers)) {
                publisher.publishIfMatched(extension);
            }
            this._registeredExtensions.add(extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterExtension(CachingServiceReference<?> extension) {
        ExtensionRegistry extensionRegistry = this;
        synchronized (extensionRegistry) {
            for (FilteredPublisher publisher : new HashSet<FilteredPublisher>(this._extensionPublishers)) {
                publisher.retractIfMatched(extension);
            }
            this._registeredExtensions.remove(extension);
        }
    }
}

