/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.jax.rs.whiteboard.internal.FilteredPublisher;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class ApplicationExtensionRegistry
implements AutoCloseable {
    private final HashMap<String, Collection<FilteredPublisher>> _applicationPublishers = new HashMap();
    private final HashMap<String, Collection<CachingServiceReference<?>>> _applicationRegisteredExtensions = new HashMap();

    @Override
    public void close() {
        this._applicationPublishers.forEach((__, aeps) -> aeps.forEach(FilteredPublisher::close));
    }

    public OSGi<CachingServiceReference<?>> waitForApplicationExtension(String applicationName, String extensionFilter) {
        Filter filter;
        try {
            filter = FrameworkUtil.createFilter((String)extensionFilter);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException();
        }
        return OSGi.fromOsgiRunnable((bc, p) -> {
            ApplicationExtensionRegistry applicationExtensionRegistry = this;
            synchronized (applicationExtensionRegistry) {
                FilteredPublisher aep = new FilteredPublisher(p, filter);
                this._applicationPublishers.compute(applicationName, (__, set) -> {
                    if (set == null) {
                        set = new HashSet<FilteredPublisher>();
                    }
                    set.add(aep);
                    return set;
                });
                Collection<CachingServiceReference<?>> extensions = this._applicationRegisteredExtensions.get(applicationName);
                if (extensions != null) {
                    for (CachingServiceReference<?> extension : new HashSet(extensions)) {
                        aep.publishIfMatched(extension);
                    }
                }
                return () -> {
                    ApplicationExtensionRegistry applicationExtensionRegistry = this;
                    synchronized (applicationExtensionRegistry) {
                        Collection<FilteredPublisher> set = this._applicationPublishers.get(applicationName);
                        set.remove(aep);
                        if (extensions != null) {
                            for (CachingServiceReference extension : new HashSet(extensions)) {
                                aep.retractIfMatched(extension);
                            }
                        }
                    }
                };
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExtensionInApplication(String applicationName, CachingServiceReference<?> extension) {
        ApplicationExtensionRegistry applicationExtensionRegistry = this;
        synchronized (applicationExtensionRegistry) {
            Collection<FilteredPublisher> publishers = this._applicationPublishers.get(applicationName);
            if (publishers != null) {
                for (FilteredPublisher publisher : new HashSet<FilteredPublisher>(publishers)) {
                    publisher.publishIfMatched(extension);
                }
            }
            this._applicationRegisteredExtensions.compute(applicationName, (__, set) -> {
                if (set == null) {
                    set = new HashSet<CachingServiceReference>();
                }
                set.add(extension);
                return set;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterExtensionInApplication(String applicationName, CachingServiceReference<?> extension) {
        ApplicationExtensionRegistry applicationExtensionRegistry = this;
        synchronized (applicationExtensionRegistry) {
            Collection<FilteredPublisher> publishers = this._applicationPublishers.get(applicationName);
            if (publishers != null) {
                for (FilteredPublisher publisher : new HashSet<FilteredPublisher>(publishers)) {
                    publisher.retractIfMatched(extension);
                }
            }
            this._applicationRegisteredExtensions.compute(applicationName, (__, set) -> {
                if (set == null) {
                    set = new HashSet();
                }
                set.remove(extension);
                return set;
            });
        }
    }
}

