/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.internal;

import java.util.Deque;
import java.util.LinkedList;

public class UpdateSupport {
    private static final ThreadLocal<Deque<Deque<Runnable>>> deferredTerminatorsStack = ThreadLocal.withInitial(LinkedList::new);
    private static final ThreadLocal<Boolean> isUpdate = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public static void defer(Runnable runnable) {
        if (isUpdate.get().booleanValue()) {
            deferredTerminatorsStack.get().peekLast().addLast(runnable);
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUpdate(Runnable runnable) {
        isUpdate.set(true);
        Deque<Deque<Runnable>> deferred = deferredTerminatorsStack.get();
        deferred.addLast(new LinkedList());
        try {
            runnable.run();
        }
        finally {
            isUpdate.set(false);
            Deque<Runnable> terminators = deferredTerminatorsStack.get().removeLast();
            for (Runnable terminator : terminators) {
                terminator.run();
            }
        }
    }
}

