/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.component.dsl.Publisher;
import org.apache.aries.component.dsl.Utils;
import org.apache.aries.component.dsl.internal.ProbeImpl;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;

public class DSLTest {
    static BundleContext bundleContext = FrameworkUtil.getBundle(DSLTest.class).getBundleContext();

    @Test
    public void testAccumulate() {
        ArrayList lists = new ArrayList();
        ArrayList<List<Object>> expected = new ArrayList<List<Object>>();
        ArrayList gone = new ArrayList();
        expected.add(Collections.emptyList());
        OSGi<List> osgi = Utils.accumulate(OSGi.serviceReferences(Service.class).map(this::getId)).effects(lists::add, gone::add);
        OSGiResult run = osgi.run(bundleContext);
        ServiceRegistration serviceRegistrationOne = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){});
        expected.add(Collections.singletonList(this.getId(serviceRegistrationOne)));
        serviceRegistrationOne.unregister();
        expected.add(Collections.emptyList());
        serviceRegistrationOne = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){});
        expected.add(Collections.singletonList(this.getId(serviceRegistrationOne)));
        ServiceRegistration serviceRegistrationTwo = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){});
        expected.add(Arrays.asList(this.getId(serviceRegistrationOne), this.getId(serviceRegistrationTwo)));
        serviceRegistrationOne.unregister();
        expected.add(Collections.singletonList(this.getId(serviceRegistrationTwo)));
        serviceRegistrationTwo.unregister();
        expected.add(Collections.emptyList());
        Assert.assertEquals(expected, lists);
        run.close();
        Assert.assertEquals(lists, gone);
    }

    @Test
    public void testAccumulateAtLeastOne() {
        ArrayList lists = new ArrayList();
        ArrayList<List<String>> expected = new ArrayList<List<String>>();
        ArrayList gone = new ArrayList();
        OSGi<List> osgi = Utils.accumulate(OSGi.serviceReferences(Service.class).map(this::getId)).filter(l -> !l.isEmpty()).effects(lists::add, gone::add);
        OSGiResult run = osgi.run(bundleContext);
        ServiceRegistration serviceRegistrationOne = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){});
        expected.add(Collections.singletonList(this.getId(serviceRegistrationOne)));
        serviceRegistrationOne.unregister();
        serviceRegistrationOne = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){});
        expected.add(Collections.singletonList(this.getId(serviceRegistrationOne)));
        ServiceRegistration serviceRegistrationTwo = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){});
        expected.add(Arrays.asList(this.getId(serviceRegistrationOne), this.getId(serviceRegistrationTwo)));
        serviceRegistrationOne.unregister();
        expected.add(Collections.singletonList(this.getId(serviceRegistrationTwo)));
        serviceRegistrationTwo.unregister();
        Assert.assertEquals(expected, lists);
        run.close();
        Assert.assertEquals(lists, gone);
    }

    @Test
    public void testApplicativeApplyTo() {
        AtomicInteger integer = new AtomicInteger(0);
        OSGi program = OSGi.just(5).applyTo(OSGi.just(i -> i + 5));
        program.run(bundleContext, newValue -> {
            integer.set((int)newValue);
            return OSGi.NOOP;
        });
        Assert.assertEquals((long)10L, (long)integer.get());
    }

    @Test
    public void testApply() {
        AtomicInteger integer = new AtomicInteger(0);
        OSGi<Integer> program = OSGi.combine((a, b, c) -> a + b + c, OSGi.just(5), OSGi.just(5), OSGi.just(5));
        program.run(bundleContext, newValue -> {
            integer.set((int)newValue);
            return OSGi.NOOP;
        });
        Assert.assertEquals((long)15L, (long)integer.get());
    }

    @Test
    public void testCoalesce() {
        ProbeImpl program1 = new ProbeImpl();
        ProbeImpl program2 = new ProbeImpl();
        ArrayList effects = new ArrayList();
        OSGiResult result = OSGi.coalesce(program1, program2, OSGi.just(Arrays.asList("fixed1", "fixed2")), OSGi.just("never")).effects(effects::add, effects::add).run(bundleContext);
        Publisher<String> publisher1 = program1.getPublisher();
        Publisher<String> publisher2 = program2.getPublisher();
        Assert.assertEquals(Arrays.asList("fixed1", "fixed2"), effects);
        OSGiResult event1Result = publisher2.publish("event1");
        program2.onClose(event1Result);
        Assert.assertEquals(Arrays.asList("fixed1", "fixed2", "fixed2", "fixed1", "event1"), effects);
        OSGiResult event2Result = publisher1.publish("event2");
        Assert.assertEquals(Arrays.asList("fixed1", "fixed2", "fixed2", "fixed1", "event1", "event1", "event2"), effects);
        event2Result.close();
        Assert.assertEquals(Arrays.asList("fixed1", "fixed2", "fixed2", "fixed1", "event1", "event1", "event2", "event2", "fixed1", "fixed2"), effects);
        event2Result = publisher1.publish("event3");
        program1.onClose(event2Result);
        Assert.assertEquals(Arrays.asList("fixed1", "fixed2", "fixed2", "fixed1", "event1", "event1", "event2", "event2", "fixed1", "fixed2", "fixed2", "fixed1", "event3"), effects);
        result.close();
        Assert.assertEquals(Arrays.asList("fixed1", "fixed2", "fixed2", "fixed1", "event1", "event1", "event2", "event2", "fixed1", "fixed2", "fixed2", "fixed1", "event3", "event3"), effects);
    }

    @Test
    public void testCoalesceWhenEmpty() {
        ProbeImpl program1 = new ProbeImpl();
        ProbeImpl program2 = new ProbeImpl();
        ArrayList effects = new ArrayList();
        OSGiResult result = OSGi.coalesce(program1, program2).effects(effects::add, effects::add).run(bundleContext);
        Publisher<String> publisher1 = program1.getPublisher();
        Publisher<String> publisher2 = program2.getPublisher();
        Assert.assertEquals(Collections.emptyList(), effects);
        OSGiResult event1Result = publisher2.publish("event1");
        program2.onClose(event1Result);
        Assert.assertEquals(Arrays.asList("event1"), effects);
        OSGiResult event2Result = publisher1.publish("event2");
        Assert.assertEquals(Arrays.asList("event1", "event1", "event2"), effects);
        event2Result.close();
        Assert.assertEquals(Arrays.asList("event1", "event1", "event2", "event2"), effects);
        event2Result = publisher1.publish("event3");
        program1.onClose(event2Result);
        Assert.assertEquals(Arrays.asList("event1", "event1", "event2", "event2", "event3"), effects);
        result.close();
        Assert.assertEquals(Arrays.asList("event1", "event1", "event2", "event2", "event3", "event3"), effects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoalesceWithConfigurationUpdate() throws IOException, InterruptedException {
        ServiceReference serviceReference = bundleContext.getServiceReference(ConfigurationAdmin.class);
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(serviceReference);
        Configuration configuration = configurationAdmin.getConfiguration("test.configuration");
        configuration.update(new Hashtable());
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        AtomicInteger counter = new AtomicInteger();
        CountDownLatch countDownLatch = new CountDownLatch(4);
        ServiceRegistration serviceRegistration = bundleContext.registerService(ManagedService.class, __ -> countDownLatch.countDown(), (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("service.pid", "test.configuration");
            }
        });
        AtomicReference<Runnable> effect = new AtomicReference<Runnable>();
        effect.set(countDownLatch::countDown);
        try (OSGiResult result = OSGi.coalesce(OSGi.configuration("test.configuration"), OSGi.just(Hashtable::new)).run(bundleContext, x -> {
            atomicReference.set(x);
            counter.incrementAndGet();
            ((Runnable)effect.get()).run();
            return OSGi.NOOP;
        });){
            configuration.update((Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("property", "value");
                }
            });
            countDownLatch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)2L, (long)counter.get());
            Assert.assertEquals((Object)"value", ((Dictionary)atomicReference.get()).get("property"));
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
            }
            CountDownLatch deleteLatch = new CountDownLatch(2);
            effect.set(deleteLatch::countDown);
            serviceRegistration = bundleContext.registerService(ManagedService.class, __ -> deleteLatch.countDown(), (Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("service.pid", "test.configuration");
                }
            });
            configuration.delete();
            deleteLatch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)3L, (long)counter.get());
            Assert.assertTrue((boolean)((Dictionary)atomicReference.get()).isEmpty());
        }
        finally {
            bundleContext.ungetService(serviceReference);
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfiguration() throws IOException, InterruptedException {
        ServiceReference serviceReference = bundleContext.getServiceReference(ConfigurationAdmin.class);
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(serviceReference);
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        Configuration configuration = null;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        try (OSGiResult result = OSGi.configuration("test.configuration").run(bundleContext, x -> {
            atomicReference.set(x);
            countDownLatch.countDown();
            return OSGi.NOOP;
        });){
            Assert.assertNull(atomicReference.get());
            configuration = configurationAdmin.getConfiguration("test.configuration");
            configuration.update(new Hashtable());
            countDownLatch.await(10L, TimeUnit.SECONDS);
            Assert.assertNotNull(atomicReference.get());
        }
        finally {
            bundleContext.ungetService(serviceReference);
            if (configuration != null) {
                configuration.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfigurationWithExistingValues() throws IOException, InterruptedException {
        ServiceReference serviceReference = bundleContext.getServiceReference(ConfigurationAdmin.class);
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(serviceReference);
        Configuration configuration = configurationAdmin.getConfiguration("test.configuration");
        configuration.update(new Hashtable());
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        AtomicInteger counter = new AtomicInteger();
        CountDownLatch countDownLatch = new CountDownLatch(2);
        ServiceRegistration serviceRegistration = bundleContext.registerService(ManagedService.class, __ -> countDownLatch.countDown(), (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("service.pid", "test.configuration");
            }
        });
        try (OSGiResult result = OSGi.configuration("test.configuration").run(bundleContext, x -> {
            atomicReference.set(x);
            counter.incrementAndGet();
            countDownLatch.countDown();
            return OSGi.NOOP;
        });){
            Assert.assertNotNull(atomicReference.get());
            countDownLatch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)counter.get());
        }
        finally {
            bundleContext.ungetService(serviceReference);
            configuration.delete();
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfigurations() throws IOException, InterruptedException {
        ServiceReference serviceReference = bundleContext.getServiceReference(ConfigurationAdmin.class);
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(serviceReference);
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Configuration configuration = null;
        try (OSGiResult result = OSGi.configurations("test.configuration").run(bundleContext, x -> {
            atomicReference.set(x);
            countDownLatch.countDown();
            return OSGi.NOOP;
        });){
            Assert.assertNull(atomicReference.get());
            configuration = configurationAdmin.createFactoryConfiguration("test.configuration");
            configuration.update(new Hashtable());
            countDownLatch.await(10L, TimeUnit.SECONDS);
            Assert.assertNotNull(atomicReference.get());
        }
        finally {
            bundleContext.ungetService(serviceReference);
            if (configuration != null) {
                configuration.delete();
            }
        }
    }

    @Test
    public void testConfigurationsAndRegistrations() throws InvalidSyntaxException, IOException, InterruptedException {
        ServiceReference serviceReference = bundleContext.getServiceReference(ConfigurationAdmin.class);
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(serviceReference);
        OSGi program = OSGi.configurations("test.configuration").map(d -> d.get("key")).flatMap(key -> OSGi.register(Service.class, new Service(), (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("key", key);
                this.put("test.configuration", true);
            }
        }));
        OSGiResult result = program.run(bundleContext);
        Assert.assertEquals((long)0L, (long)bundleContext.getServiceReferences(Service.class, "(test.configuration=*)").size());
        final CountDownLatch addedLatch = new CountDownLatch(3);
        ServiceTracker<Service, Service> serviceTracker = new ServiceTracker<Service, Service>(bundleContext, Service.class, null){

            public Service addingService(ServiceReference<Service> reference) {
                addedLatch.countDown();
                return null;
            }
        };
        serviceTracker.open();
        final CountDownLatch deletedLatch = new CountDownLatch(3);
        ServiceTracker<Service, Service> serviceTracker2 = new ServiceTracker<Service, Service>(bundleContext, Service.class, null){

            public void removedService(ServiceReference<Service> reference, Service service) {
                deletedLatch.countDown();
            }
        };
        serviceTracker2.open();
        Configuration configuration = configurationAdmin.createFactoryConfiguration("test.configuration");
        configuration.update((Dictionary)new Hashtable<String, Object>(){
            {
                this.put("key", "service one");
            }
        });
        Configuration configuration2 = configurationAdmin.createFactoryConfiguration("test.configuration");
        configuration2.update((Dictionary)new Hashtable<String, Object>(){
            {
                this.put("key", "service two");
            }
        });
        Configuration configuration3 = configurationAdmin.createFactoryConfiguration("test.configuration");
        configuration3.update((Dictionary)new Hashtable<String, Object>(){
            {
                this.put("key", "service three");
            }
        });
        Assert.assertTrue((boolean)addedLatch.await(10L, TimeUnit.SECONDS));
        Assert.assertEquals((long)1L, (long)bundleContext.getServiceReferences(Service.class, "(key=service one)").size());
        Assert.assertEquals((long)1L, (long)bundleContext.getServiceReferences(Service.class, "(key=service two)").size());
        Assert.assertEquals((long)1L, (long)bundleContext.getServiceReferences(Service.class, "(key=service three)").size());
        configuration3.delete();
        configuration2.delete();
        configuration.delete();
        Assert.assertTrue((boolean)deletedLatch.await(10L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)bundleContext.getServiceReferences(Service.class, "(test.configuration=*)").size());
        serviceTracker.close();
        serviceTracker2.close();
        result.close();
        bundleContext.ungetService(serviceReference);
    }

    @Test
    public void testHighestRankingDiscards() {
        ArrayList discards = new ArrayList();
        OSGi<CachingServiceReference<Service>> program = Utils.highest(OSGi.serviceReferences(Service.class), Comparator.naturalOrder(), dp -> dp.map(CachingServiceReference::getServiceReference).effects(discards::add, discards::remove).then(OSGi.nothing()));
        Assert.assertTrue((boolean)discards.isEmpty());
        try (OSGiResult result = program.run(bundleContext);){
            ServiceRegistration serviceRegistrationOne = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("service.ranking", 0);
                }
            });
            Assert.assertEquals(Collections.emptyList(), discards);
            ServiceRegistration serviceRegistrationTwo = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("service.ranking", 1);
                }
            });
            Assert.assertEquals(Collections.singletonList(serviceRegistrationOne.getReference()), discards);
            ServiceRegistration serviceRegistrationMinusOne = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("service.ranking", -1);
                }
            });
            Assert.assertEquals(Arrays.asList(serviceRegistrationOne.getReference(), serviceRegistrationMinusOne.getReference()), discards);
            serviceRegistrationTwo.unregister();
            Assert.assertEquals(Arrays.asList(serviceRegistrationMinusOne.getReference()), discards);
            serviceRegistrationOne.unregister();
            Assert.assertTrue((boolean)discards.isEmpty());
            serviceRegistrationOne = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("service.ranking", 0);
                }
            });
            Assert.assertEquals(Arrays.asList(serviceRegistrationMinusOne.getReference()), discards);
            serviceRegistrationMinusOne.unregister();
            serviceRegistrationOne.unregister();
        }
    }

    @Test
    public void testHighestRankingOnly() {
        AtomicReference current = new AtomicReference();
        OSGi<Void> program = Utils.highest(OSGi.serviceReferences(Service.class)).foreach(current::set, sr -> current.set(null));
        Assert.assertNull(current.get());
        try (OSGiResult result = program.run(bundleContext);){
            ServiceRegistration serviceRegistrationOne = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("service.ranking", 0);
                }
            });
            Assert.assertEquals((Object)serviceRegistrationOne.getReference(), ((CachingServiceReference)current.get()).getServiceReference());
            ServiceRegistration serviceRegistrationTwo = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("service.ranking", 1);
                }
            });
            Assert.assertEquals((Object)serviceRegistrationTwo.getReference(), ((CachingServiceReference)current.get()).getServiceReference());
            ServiceRegistration serviceRegistrationMinusOne = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("service.ranking", -1);
                }
            });
            Assert.assertEquals((Object)serviceRegistrationTwo.getReference(), ((CachingServiceReference)current.get()).getServiceReference());
            serviceRegistrationTwo.unregister();
            Assert.assertEquals((Object)serviceRegistrationOne.getReference(), ((CachingServiceReference)current.get()).getServiceReference());
            serviceRegistrationOne.unregister();
            Assert.assertEquals((Object)serviceRegistrationMinusOne.getReference(), ((CachingServiceReference)current.get()).getServiceReference());
            serviceRegistrationOne = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("service.ranking", 0);
                }
            });
            Assert.assertEquals((Object)serviceRegistrationOne.getReference(), ((CachingServiceReference)current.get()).getServiceReference());
            serviceRegistrationOne.unregister();
            serviceRegistrationMinusOne.unregister();
        }
    }

    @Test
    public void testJust() {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        OSGi<Integer> just = OSGi.just(25);
        Assert.assertEquals((long)0L, (long)atomicInteger.get());
        try (OSGiResult result = just.run(bundleContext, newValue -> {
            atomicInteger.set((int)newValue);
            return OSGi.NOOP;
        });){
            Assert.assertEquals((long)25L, (long)atomicInteger.get());
        }
        atomicInteger.set(0);
        OSGi<Integer> map = OSGi.just(25).map(s -> s + 5);
        try (OSGiResult result = map.run(bundleContext, newValue -> {
            atomicInteger.set((int)newValue);
            return OSGi.NOOP;
        });){
            Assert.assertEquals((long)30L, (long)atomicInteger.get());
        }
        atomicInteger.set(0);
        OSGi flatMap = OSGi.just(25).flatMap(s -> OSGi.just(s + 10));
        try (OSGiResult result = flatMap.run(bundleContext, newValue -> {
            atomicInteger.set((int)newValue);
            return OSGi.NOOP;
        });){
            Assert.assertEquals((long)35L, (long)atomicInteger.get());
        }
        atomicInteger.set(0);
        OSGi<Integer> filter = OSGi.just(25).filter(s -> s % 2 == 0);
        try (OSGiResult result = filter.run(bundleContext, newValue -> {
            atomicInteger.set((int)newValue);
            return OSGi.NOOP;
        });){
            Assert.assertEquals((long)0L, (long)atomicInteger.get());
        }
        atomicInteger.set(0);
        filter = OSGi.just(25).filter(s -> s % 2 != 0);
        result = filter.run(bundleContext, newValue -> {
            atomicInteger.set((int)newValue);
            return OSGi.NOOP;
        });
        var7_15 = null;
        try {
            Assert.assertEquals((long)25L, (long)atomicInteger.get());
        }
        catch (Throwable throwable) {
            var7_15 = throwable;
            throw throwable;
        }
        finally {
            if (result != null) {
                if (var7_15 != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable) {
                        var7_15.addSuppressed(throwable);
                    }
                } else {
                    result.close();
                }
            }
        }
    }

    @Test
    public void testMultipleApplies() {
        ArrayList results = new ArrayList();
        AtomicInteger results2 = new AtomicInteger();
        OSGi<Integer> program = OSGi.combine((a, b, c) -> a + b + c, OSGi.just(Arrays.asList(5, 20)), OSGi.just(Arrays.asList(5, 40)), OSGi.just(Arrays.asList(5, 60)));
        OSGiResult or = program.run(bundleContext, newValue -> {
            results.add(newValue);
            return OSGi.NOOP;
        });
        or.close();
        OSGiResult or2 = program.run(bundleContext, i -> {
            results2.accumulateAndGet((int)i, (a, b) -> a + b);
            return OSGi.NOOP;
        });
        or2.close();
        Assert.assertEquals((long)8L, (long)results.size());
        Assert.assertEquals((long)540L, (long)results2.get());
    }

    @Test
    public void testOnCloseWithError() {
        ArrayList result = new ArrayList();
        ArrayList left = new ArrayList();
        OSGi program = OSGi.just(Arrays.asList(1, 2, 3, 4, 5, 6)).recoverWith((__, e) -> OSGi.just(0)).flatMap(t -> OSGi.onClose(() -> left.add(t)).then(OSGi.just(t))).flatMap(t -> {
            if (t % 2 != 0) {
                throw new RuntimeException();
            }
            return OSGi.just(t);
        });
        try (OSGiResult run = program.run(bundleContext, e -> {
            result.add(e);
            return OSGi.NOOP;
        });){
            Assert.assertEquals(Arrays.asList(0, 2, 0, 4, 0, 6), result);
            Assert.assertEquals(Arrays.asList(1, 3, 5), left);
        }
    }

    @Test
    public void testOnce() {
        ProbeImpl probe = new ProbeImpl();
        AtomicInteger count = new AtomicInteger();
        OSGi<Integer> once = OSGi.once(probe).effects(t -> count.incrementAndGet(), t -> count.set(0));
        once.run(bundleContext);
        Publisher op = probe.getPublisher();
        Assert.assertEquals((long)0L, (long)count.get());
        Object se = op.apply((Object)1);
        Assert.assertEquals((long)1L, (long)count.get());
        se.run();
        Assert.assertEquals((long)0L, (long)count.get());
        se = op.apply((Object)1);
        Object se2 = op.apply((Object)2);
        Object se3 = op.apply((Object)3);
        Assert.assertEquals((long)1L, (long)count.get());
        se.run();
        Assert.assertEquals((long)1L, (long)count.get());
        se3.run();
        Assert.assertEquals((long)1L, (long)count.get());
        se2.run();
        Assert.assertEquals((long)0L, (long)count.get());
    }

    @Test
    public void testProgrammaticDependencies() {
        AtomicBoolean executed = new AtomicBoolean(false);
        AtomicBoolean closed = new AtomicBoolean(false);
        String[] filters = new String[]{"(key=service one)", "(key=service two)", "(key=service three)"};
        OSGi<Void> program = OSGi.onClose(() -> closed.set(true)).foreach(ign -> executed.set(true));
        for (String filter : filters) {
            program = OSGi.services(filter).then(program);
        }
        try (OSGiResult result = program.run(bundleContext);){
            Assert.assertFalse((boolean)closed.get());
            Assert.assertFalse((boolean)executed.get());
            ServiceRegistration serviceRegistrationOne = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("key", "service one");
                }
            });
            Assert.assertFalse((boolean)closed.get());
            Assert.assertFalse((boolean)executed.get());
            ServiceRegistration serviceRegistrationTwo = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("key", "service two");
                }
            });
            Assert.assertFalse((boolean)closed.get());
            Assert.assertFalse((boolean)executed.get());
            ServiceRegistration serviceRegistrationThree = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("key", "service three");
                }
            });
            Assert.assertFalse((boolean)closed.get());
            Assert.assertTrue((boolean)executed.get());
            serviceRegistrationOne.unregister();
            Assert.assertTrue((boolean)closed.get());
            serviceRegistrationTwo.unregister();
            serviceRegistrationThree.unregister();
        }
    }

    @Test
    public void testRecover() {
        ArrayList result = new ArrayList();
        ArrayList arrived = new ArrayList();
        ArrayList left = new ArrayList();
        OSGi<Integer> program = OSGi.just(Arrays.asList(1, 2, 3, 4, 5, 6)).recover((__, e) -> 0).effects(arrived::add, left::add).effects(t -> {
            if (t % 2 != 0) {
                throw new RuntimeException();
            }
        }, __ -> {});
        try (OSGiResult run = program.run(bundleContext, e -> {
            result.add(e);
            return OSGi.NOOP;
        });){
            Assert.assertEquals(Arrays.asList(0, 2, 0, 4, 0, 6), result);
            Assert.assertEquals(Arrays.asList(1, 0, 2, 3, 0, 4, 5, 0, 6), arrived);
            Assert.assertEquals(Arrays.asList(1, 3, 5), left);
            arrived.removeAll(left);
            Assert.assertEquals(arrived, result);
        }
    }

    @Test
    public void testRecoverWith() {
        ArrayList result = new ArrayList();
        ArrayList arrived = new ArrayList();
        ArrayList left = new ArrayList();
        OSGi<Integer> program = OSGi.just(Arrays.asList(1, 2, 3, 4, 5, 6)).recoverWith((__, e) -> OSGi.just(0)).effects(arrived::add, left::add).effects(t -> {
            if (t % 2 != 0) {
                throw new RuntimeException();
            }
        }, __ -> {});
        try (OSGiResult run = program.run(bundleContext, e -> {
            result.add(e);
            return OSGi.NOOP;
        });){
            Assert.assertEquals(Arrays.asList(0, 2, 0, 4, 0, 6), result);
            Assert.assertEquals(Arrays.asList(1, 0, 2, 3, 0, 4, 5, 0, 6), arrived);
            Assert.assertEquals(Arrays.asList(1, 3, 5), left);
            arrived.removeAll(left);
            Assert.assertEquals(arrived, result);
        }
    }

    @Test
    public void testRegister() {
        Assert.assertNull((Object)bundleContext.getServiceReference(Service.class));
        Service service = new Service();
        OSGiResult result = OSGi.register(Service.class, service, new HashMap<String, Object>()).run(bundleContext);
        ServiceReference serviceReference = bundleContext.getServiceReference(Service.class);
        Assert.assertEquals((Object)service, (Object)bundleContext.getService(serviceReference));
        result.close();
        Assert.assertNull((Object)bundleContext.getServiceReference(Service.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServiceReferenceRefresher() {
        ServiceRegistration serviceRegistration = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("good", 0);
                this.put("bad", 0);
            }
        });
        AtomicInteger atomicInteger = new AtomicInteger();
        try {
            OSGi<Object> program = OSGi.serviceReferences(Service.class, csr -> csr.isDirty("good")).map(csr -> csr.getProperty("good"));
            program.run(bundleContext, __ -> {
                atomicInteger.incrementAndGet();
                return OSGi.NOOP;
            });
            Assert.assertEquals((long)1L, (long)atomicInteger.get());
            serviceRegistration.setProperties((Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("good", 0);
                    this.put("bad", 1);
                }
            });
            Assert.assertEquals((long)1L, (long)atomicInteger.get());
            serviceRegistration.setProperties((Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("good", 1);
                    this.put("bad", 1);
                }
            });
            Assert.assertEquals((long)2L, (long)atomicInteger.get());
        }
        finally {
            serviceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServiceReferences() {
        AtomicReference atomicReference = new AtomicReference();
        ServiceRegistration serviceRegistration = null;
        try (OSGiResult osGiResult = OSGi.serviceReferences(Service.class).run(bundleContext, newValue -> {
            atomicReference.set(newValue);
            return OSGi.NOOP;
        });){
            Assert.assertNull(atomicReference.get());
            serviceRegistration = bundleContext.registerService(Service.class, (Object)new Service(), new Hashtable());
            Assert.assertEquals((Object)serviceRegistration.getReference(), ((CachingServiceReference)atomicReference.get()).getServiceReference());
        }
        finally {
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServiceReferencesAndClose() {
        AtomicReference atomicReference = new AtomicReference();
        OSGi program = OSGi.serviceReferences(Service.class).flatMap(ref -> OSGi.onClose(() -> atomicReference.set(null)).then(OSGi.just(ref)));
        ServiceRegistration serviceRegistration = null;
        try (OSGiResult osGiResult = program.run(bundleContext, newValue -> {
            atomicReference.set(newValue);
            return OSGi.NOOP;
        });){
            Assert.assertNull(atomicReference.get());
            serviceRegistration = bundleContext.registerService(Service.class, (Object)new Service(), new Hashtable());
            Assert.assertEquals((Object)serviceRegistration.getReference(), ((CachingServiceReference)atomicReference.get()).getServiceReference());
        }
        finally {
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
            }
        }
        Assert.assertNull(atomicReference.get());
    }

    @Test
    public void testServicesMap() {
        AtomicReference map = new AtomicReference(new HashMap());
        ArrayList maps = new ArrayList();
        ArrayList gone = new ArrayList();
        OSGi mapOSGi = Utils.accumulateInMap(OSGi.serviceReferences(Service.class), csr -> OSGi.just(Arrays.asList(DSLTest.canonicalize(csr.getProperty("key")))), csr -> OSGi.just(this.getId((CachingServiceReference<?>)csr)));
        OSGi<Map> effects = mapOSGi.effects(map::set, __ -> {}).effects(maps::add, gone::add);
        OSGiResult result = effects.run(bundleContext);
        Assert.assertEquals(Collections.emptyMap(), map.get());
        final ServiceRegistration serviceRegistrationOne = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("key", new String[]{"a"});
            }
        });
        Assert.assertEquals((Object)new HashMap<String, String>(){
            {
                this.put("a", DSLTest.this.getId(serviceRegistrationOne));
            }
        }, map.get());
        final ServiceRegistration serviceRegistrationTwo = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("key", new String[]{"b"});
            }
        });
        Assert.assertEquals((Object)new HashMap<String, String>(){
            {
                this.put("a", DSLTest.this.getId(serviceRegistrationOne));
                this.put("b", DSLTest.this.getId(serviceRegistrationTwo));
            }
        }, map.get());
        final ServiceRegistration serviceRegistrationThree = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("key", new String[]{"a", "b"});
                this.put("service.ranking", 10);
            }
        });
        Assert.assertEquals((Object)new HashMap<String, String>(){
            {
                this.put("a", DSLTest.this.getId(serviceRegistrationThree));
                this.put("b", DSLTest.this.getId(serviceRegistrationThree));
            }
        }, map.get());
        serviceRegistrationThree.unregister();
        Assert.assertEquals((Object)new HashMap<String, String>(){
            {
                this.put("a", DSLTest.this.getId(serviceRegistrationOne));
                this.put("b", DSLTest.this.getId(serviceRegistrationTwo));
            }
        }, map.get());
        serviceRegistrationTwo.unregister();
        Assert.assertEquals((Object)new HashMap<String, String>(){
            {
                this.put("a", DSLTest.this.getId(serviceRegistrationOne));
            }
        }, map.get());
        serviceRegistrationOne.unregister();
        Assert.assertEquals(Collections.emptyMap(), map.get());
        result.close();
        Assert.assertEquals(maps, gone);
    }

    private static String[] canonicalize(Object propertyValue) {
        if (propertyValue == null) {
            return new String[0];
        }
        if (propertyValue instanceof String[]) {
            return (String[])propertyValue;
        }
        if (propertyValue instanceof Collection) {
            return (String[])((Collection)propertyValue).stream().map(Object::toString).toArray(String[]::new);
        }
        return new String[]{propertyValue.toString()};
    }

    private String getId(CachingServiceReference<?> csr) {
        return csr.getProperty("service.id").toString();
    }

    private String getId(ServiceRegistration<?> sr) {
        return sr.getReference().getProperty("service.id").toString();
    }

    private class Service {
        private Service() {
        }
    }
}

