/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.test;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class CachingServiceReferenceTests {
    private static BundleContext bundleContext = FrameworkUtil.getBundle(CachingServiceReferenceTests.class).getBundleContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComparable() {
        ServiceRegistration serviceRegistrationNoRanking = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){});
        ServiceRegistration serviceRegistrationOne = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("service.ranking", 1);
            }
        });
        ServiceRegistration serviceRegistrationMinusOne = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("service.ranking", -1);
            }
        });
        try {
            TreeSet<CachingServiceReference> set = new TreeSet<CachingServiceReference>();
            CachingServiceReference noRanking = new CachingServiceReference(serviceRegistrationNoRanking.getReference());
            set.add(noRanking);
            CachingServiceReference rankingOne = new CachingServiceReference(serviceRegistrationOne.getReference());
            set.add(rankingOne);
            CachingServiceReference minusOne = new CachingServiceReference(serviceRegistrationMinusOne.getReference());
            set.add(minusOne);
            CachingServiceReference first = (CachingServiceReference)set.first();
            Assert.assertTrue((boolean)first.equals(minusOne));
            CachingServiceReference second = set.higher(first);
            Assert.assertTrue((boolean)second.equals(noRanking));
            CachingServiceReference third = set.higher(second);
            Assert.assertTrue((boolean)third.equals(rankingOne));
        }
        finally {
            serviceRegistrationMinusOne.unregister();
            serviceRegistrationNoRanking.unregister();
            serviceRegistrationOne.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCachingNullProperties() {
        ServiceRegistration serviceRegistration = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){});
        try {
            ServiceReference serviceReference = serviceRegistration.getReference();
            CachingServiceReference cachingServiceReference = new CachingServiceReference(serviceReference);
            Assert.assertEquals((Object)serviceReference.getProperty("property"), (Object)cachingServiceReference.getProperty("property"));
            serviceRegistration.setProperties((Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("property", "value2");
                }
            });
            Assert.assertEquals((Object)serviceReference.getProperty("property"), (Object)"value2");
            Assert.assertNull((Object)cachingServiceReference.getProperty("property"));
            Assert.assertTrue((boolean)cachingServiceReference.isDirty());
        }
        finally {
            serviceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullPropertiesKeysAreNotReturned() {
        ServiceRegistration serviceRegistration = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){});
        try {
            ServiceReference serviceReference = serviceRegistration.getReference();
            CachingServiceReference cachingServiceReference = new CachingServiceReference(serviceReference);
            Assert.assertNull((Object)serviceReference.getProperty("property"));
            Assert.assertEquals((Object)serviceReference.getProperty("property"), (Object)cachingServiceReference.getProperty("property"));
            List<String> properties = Arrays.asList(cachingServiceReference.getPropertyKeys());
            Assert.assertFalse((boolean)properties.contains("property"));
            serviceRegistration.setProperties((Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("property", "value2");
                }
            });
            Assert.assertEquals((Object)serviceReference.getProperty("property"), (Object)"value2");
            properties = Arrays.asList(cachingServiceReference.getPropertyKeys());
            Assert.assertFalse((boolean)properties.contains("property"));
        }
        finally {
            serviceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCachingProperties() {
        ServiceRegistration serviceRegistration = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("property", "value");
            }
        });
        try {
            ServiceReference serviceReference = serviceRegistration.getReference();
            CachingServiceReference cachingServiceReference = new CachingServiceReference(serviceReference);
            Assert.assertEquals((Object)serviceReference.getProperty("property"), (Object)cachingServiceReference.getProperty("property"));
            serviceRegistration.setProperties((Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("property", "value2");
                }
            });
            Assert.assertEquals((Object)serviceReference.getProperty("property"), (Object)"value2");
            Assert.assertEquals((Object)cachingServiceReference.getProperty("property"), (Object)"value");
        }
        finally {
            serviceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCachingPropertiesBecomingNull() {
        ServiceRegistration serviceRegistration = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("property", "value");
            }
        });
        try {
            ServiceReference serviceReference = serviceRegistration.getReference();
            Object[] propertyKeys = serviceReference.getPropertyKeys();
            Arrays.sort(propertyKeys);
            CachingServiceReference cachingServiceReference = new CachingServiceReference(serviceReference);
            Assert.assertEquals((Object)serviceReference.getProperty("property"), (Object)cachingServiceReference.getProperty("property"));
            serviceRegistration.setProperties((Dictionary)new Hashtable<String, Object>(){});
            Assert.assertNull((Object)serviceReference.getProperty("property"));
            Assert.assertEquals((Object)"value", (Object)cachingServiceReference.getProperty("property"));
            Assert.assertTrue((boolean)cachingServiceReference.isDirty());
            Object[] cachedPropertyKeys = cachingServiceReference.getPropertyKeys();
            Arrays.sort(cachedPropertyKeys);
            Assert.assertTrue((boolean)Arrays.equals(propertyKeys, cachedPropertyKeys));
        }
        finally {
            serviceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsDirty() {
        ServiceRegistration serviceRegistration = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("property", "value");
            }
        });
        try {
            ServiceReference serviceReference = serviceRegistration.getReference();
            CachingServiceReference cachingServiceReference = new CachingServiceReference(serviceReference);
            Assert.assertEquals((Object)serviceReference.getProperty("property"), (Object)cachingServiceReference.getProperty("property"));
            serviceRegistration.setProperties((Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("property", "value2");
                }
            });
            Assert.assertTrue((boolean)cachingServiceReference.isDirty());
        }
        finally {
            serviceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsNotDirty() {
        ServiceRegistration serviceRegistration = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("property", "value");
            }
        });
        try {
            ServiceReference serviceReference = serviceRegistration.getReference();
            CachingServiceReference cachingServiceReference = new CachingServiceReference(serviceReference);
            serviceRegistration.setProperties((Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("property", "value2");
                }
            });
            Assert.assertFalse((boolean)cachingServiceReference.isDirty());
        }
        finally {
            serviceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsDirtyDoesNotCache() {
        ServiceRegistration serviceRegistration = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("property", "value");
            }
        });
        try {
            ServiceReference serviceReference = serviceRegistration.getReference();
            CachingServiceReference cachingServiceReference = new CachingServiceReference(serviceReference);
            serviceRegistration.setProperties((Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("property", "value2");
                }
            });
            Assert.assertFalse((boolean)cachingServiceReference.isDirty("property"));
            Assert.assertEquals((Object)"value2", (Object)cachingServiceReference.getProperty("property"));
            Assert.assertFalse((boolean)cachingServiceReference.isDirty("property"));
            serviceRegistration.setProperties((Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("property", "value3");
                }
            });
            Assert.assertTrue((boolean)cachingServiceReference.isDirty("property"));
        }
        finally {
            serviceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsDirtyNullProperty() {
        ServiceRegistration serviceRegistration = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){});
        try {
            ServiceReference serviceReference = serviceRegistration.getReference();
            CachingServiceReference cachingServiceReference = new CachingServiceReference(serviceReference);
            Assert.assertFalse((boolean)cachingServiceReference.isDirty("nonExisting"));
        }
        finally {
            serviceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPropertiesAreCachedWhenQueried() {
        ServiceRegistration serviceRegistration = bundleContext.registerService(Service.class, (Object)new Service(), (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("property", "value");
            }
        });
        try {
            ServiceReference serviceReference = serviceRegistration.getReference();
            CachingServiceReference cachingServiceReference = new CachingServiceReference(serviceReference);
            serviceRegistration.setProperties((Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("property", "value2");
                }
            });
            Assert.assertEquals((Object)serviceReference.getProperty("property"), (Object)cachingServiceReference.getProperty("property"));
        }
        finally {
            serviceRegistration.unregister();
        }
    }

    private class Service {
        private Service() {
        }
    }
}

