/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.test;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.component.dsl.Publisher;
import org.apache.aries.component.dsl.internal.ProbeImpl;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Ignore
public class AsynchronousTest {
    static BundleContext bundleContext = FrameworkUtil.getBundle(AsynchronousTest.class).getBundleContext();

    @Test
    public void testApplicative() throws InterruptedException {
        int RUNS = 40;
        AtomicBoolean[][][] started = new AtomicBoolean[RUNS][RUNS][RUNS];
        AtomicBoolean[][][] closed = new AtomicBoolean[RUNS][RUNS][RUNS];
        for (int i2 = 0; i2 < RUNS; ++i2) {
            for (int j = 0; j < RUNS; ++j) {
                for (int k = 0; k < RUNS; ++k) {
                    started[i2][j][k] = new AtomicBoolean();
                    closed[i2][j][k] = new AtomicBoolean();
                }
            }
        }
        OSGi<Integer> as = OSGi.services(Service.class, "(property=a)").map(Service::getI);
        OSGi<Integer> bs = OSGi.services(Service.class, "(property=b)").map(Service::getI);
        OSGi<Integer> cs = OSGi.services(Service.class, "(property=c)").map(Service::getI);
        OSGi<int[]> combined = OSGi.combine((x, y, z) -> new int[]{x, y, z}, as, bs, cs);
        OSGi<int[]> program = combined.effects(i -> started[i[0]][i[1]][i[2]].set(true), i -> closed[i[0]][i[1]][i[2]].set(true));
        OSGiResult result = program.run(bundleContext);
        ExecutorService executor = Executors.newFixedThreadPool(RUNS);
        Random random = new Random(System.currentTimeMillis());
        for (int i3 = 0; i3 < RUNS; ++i3) {
            int ii = i3;
            for (int j = 0; j < RUNS; ++j) {
                int jj = j;
                int k = 0;
                while (k < RUNS) {
                    int kk = k++;
                    executor.execute(() -> {
                        AsynchronousTest.ignoreException(() -> Thread.sleep(random.nextInt(10)));
                        ServiceRegistration sr = bundleContext.registerService(Service.class, (Object)new Service(ii), (Dictionary)new Hashtable<String, Object>(){
                            {
                                this.put("property", "a");
                            }
                        });
                        AsynchronousTest.ignoreException(() -> Thread.sleep(random.nextInt(2)));
                        sr.unregister();
                    });
                    executor.execute(() -> {
                        AsynchronousTest.ignoreException(() -> Thread.sleep(random.nextInt(5)));
                        ServiceRegistration sr = bundleContext.registerService(Service.class, (Object)new Service(jj), (Dictionary)new Hashtable<String, Object>(){
                            {
                                this.put("property", "b");
                            }
                        });
                        AsynchronousTest.ignoreException(() -> Thread.sleep(random.nextInt(2)));
                        sr.unregister();
                    });
                    executor.execute(() -> {
                        AsynchronousTest.ignoreException(() -> Thread.sleep(random.nextInt(2)));
                        ServiceRegistration sr = bundleContext.registerService(Service.class, (Object)new Service(kk), (Dictionary)new Hashtable<String, Object>(){
                            {
                                this.put("property", "c");
                            }
                        });
                        AsynchronousTest.ignoreException(() -> Thread.sleep(random.nextInt(2)));
                        sr.unregister();
                    });
                }
            }
        }
        executor.shutdown();
        boolean finished = executor.awaitTermination(1L, TimeUnit.MINUTES);
        result.close();
        System.out.println("******** FINISHED: " + finished);
        int executedCount = 0;
        int totalCount = 0;
        int errors = 0;
        for (int i4 = 0; i4 < RUNS; ++i4) {
            for (int j = 0; j < RUNS; ++j) {
                for (int k = 0; k < RUNS; ++k) {
                    if (started[i4][j][k].get()) {
                        ++executedCount;
                    }
                    if (started[i4][j][k].get() != closed[i4][j][k].get()) {
                        ++errors;
                    }
                    ++totalCount;
                }
            }
        }
        System.out.println("******* TOTAL: " + totalCount);
        System.out.println("******* EXECUTED: " + executedCount);
        System.out.println("******* ERRORS: " + errors);
        Assert.assertTrue((executedCount < totalCount ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)errors);
    }

    @Test
    public void testApplicativeConfiguration() throws InterruptedException {
        int RUNS = 40;
        AtomicBoolean[][][] started = new AtomicBoolean[RUNS][RUNS][RUNS];
        AtomicBoolean[][][] closed = new AtomicBoolean[RUNS][RUNS][RUNS];
        for (int i2 = 0; i2 < RUNS; ++i2) {
            for (int j = 0; j < RUNS; ++j) {
                for (int k = 0; k < RUNS; ++k) {
                    started[i2][j][k] = new AtomicBoolean();
                    closed[i2][j][k] = new AtomicBoolean();
                }
            }
        }
        OSGi<Integer> as = OSGi.services(Service.class, "(property=a)").map(Service::getI);
        OSGi<Integer> bs = OSGi.services(Service.class, "(property=b)").map(Service::getI);
        OSGi<Integer> cs = OSGi.configurations("configurationc").map(d -> (Integer)d.get("property"));
        OSGi<int[]> combined = OSGi.combine((x, y, z) -> new int[]{x, y, z}, as, bs, cs);
        OSGi<int[]> program = combined.effects(i -> started[i[0]][i[1]][i[2]].set(true), i -> closed[i[0]][i[1]][i[2]].set(true));
        OSGiResult result = program.run(bundleContext);
        ServiceReference configAdmin = bundleContext.getServiceReference(ConfigurationAdmin.class);
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(configAdmin);
        ExecutorService executor = Executors.newFixedThreadPool(RUNS);
        ExecutorService executor2 = Executors.newFixedThreadPool(1);
        Random random = new Random(System.currentTimeMillis());
        for (int i3 = 0; i3 < RUNS; ++i3) {
            int ii = i3;
            for (int j = 0; j < RUNS; ++j) {
                int jj = j;
                int k = 0;
                while (k < RUNS) {
                    final int kk = k++;
                    executor.execute(() -> {
                        AsynchronousTest.ignoreException(() -> Thread.sleep(random.nextInt(10)));
                        ServiceRegistration sr = bundleContext.registerService(Service.class, (Object)new Service(ii), (Dictionary)new Hashtable<String, Object>(){
                            {
                                this.put("property", "a");
                            }
                        });
                        AsynchronousTest.ignoreException(() -> Thread.sleep(random.nextInt(2)));
                        sr.unregister();
                    });
                    executor.execute(() -> {
                        AsynchronousTest.ignoreException(() -> Thread.sleep(random.nextInt(5)));
                        ServiceRegistration sr = bundleContext.registerService(Service.class, (Object)new Service(jj), (Dictionary)new Hashtable<String, Object>(){
                            {
                                this.put("property", "b");
                            }
                        });
                        AsynchronousTest.ignoreException(() -> Thread.sleep(random.nextInt(2)));
                        sr.unregister();
                    });
                    executor2.execute(() -> AsynchronousTest.ignoreException(() -> {
                        Thread.sleep(random.nextInt(2));
                        Configuration configurationc = configurationAdmin.createFactoryConfiguration("configurationc");
                        configurationc.update((Dictionary)new Hashtable<String, Object>(){
                            {
                                this.put("property", kk);
                            }
                        });
                        configurationc.delete();
                    }));
                }
            }
        }
        executor.shutdown();
        boolean finished = executor.awaitTermination(1L, TimeUnit.MINUTES);
        result.close();
        System.out.println("******** FINISHED: " + finished);
        int executedCount = 0;
        int totalCount = 0;
        int errors = 0;
        for (int i4 = 0; i4 < RUNS; ++i4) {
            for (int j = 0; j < RUNS; ++j) {
                for (int k = 0; k < RUNS; ++k) {
                    if (started[i4][j][k].get()) {
                        ++executedCount;
                    }
                    if (started[i4][j][k].get() != closed[i4][j][k].get()) {
                        ++errors;
                    }
                    ++totalCount;
                }
            }
        }
        System.out.println("******* TOTAL: " + totalCount);
        System.out.println("******* EXECUTED: " + executedCount);
        System.out.println("******* ERRORS: " + errors);
        Assert.assertTrue((executedCount < totalCount ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)errors);
    }

    @Test
    public void testApplicativeProbe() throws InterruptedException {
        int RUNS = 40;
        AtomicBoolean[][][] started = new AtomicBoolean[RUNS][RUNS][RUNS];
        AtomicBoolean[][][] closed = new AtomicBoolean[RUNS][RUNS][RUNS];
        for (int i2 = 0; i2 < RUNS; ++i2) {
            for (int j = 0; j < RUNS; ++j) {
                for (int k = 0; k < RUNS; ++k) {
                    started[i2][j][k] = new AtomicBoolean();
                    closed[i2][j][k] = new AtomicBoolean();
                }
            }
        }
        ProbeImpl as = new ProbeImpl();
        ProbeImpl bs = new ProbeImpl();
        ProbeImpl cs = new ProbeImpl();
        OSGi<int[]> combined = OSGi.combine((x, y, z) -> new int[]{x, y, z}, as, bs, cs);
        OSGi<int[]> program = combined.effects(i -> started[i[0]][i[1]][i[2]].set(true), i -> closed[i[0]][i[1]][i[2]].set(true));
        OSGiResult result = program.run(bundleContext);
        Publisher opa = as.getPublisher();
        Publisher opb = bs.getPublisher();
        Publisher opc = cs.getPublisher();
        ExecutorService executor = Executors.newFixedThreadPool(8);
        Random random = new Random(System.currentTimeMillis());
        for (int i3 = 0; i3 < RUNS; ++i3) {
            int ii = i3;
            for (int j = 0; j < RUNS; ++j) {
                int jj = j;
                int k = 0;
                while (k < RUNS) {
                    int kk = k++;
                    executor.execute(() -> {
                        AsynchronousTest.ignoreException(() -> Thread.sleep(random.nextInt(10)));
                        Object sentEvent = opa.apply((Object)ii);
                        AsynchronousTest.ignoreException(() -> Thread.sleep(random.nextInt(2)));
                        sentEvent.run();
                    });
                    executor.execute(() -> {
                        AsynchronousTest.ignoreException(() -> Thread.sleep(random.nextInt(5)));
                        Object sentEvent = opb.apply((Object)jj);
                        AsynchronousTest.ignoreException(() -> Thread.sleep(random.nextInt(2)));
                        sentEvent.run();
                    });
                    executor.execute(() -> {
                        AsynchronousTest.ignoreException(() -> Thread.sleep(random.nextInt(2)));
                        Object sentEvent = opc.apply((Object)kk);
                        AsynchronousTest.ignoreException(() -> Thread.sleep(random.nextInt(2)));
                        sentEvent.run();
                    });
                }
            }
        }
        executor.shutdown();
        boolean finished = executor.awaitTermination(2L, TimeUnit.MINUTES);
        result.close();
        System.out.println("******** FINISHED: " + finished);
        int executedCount = 0;
        int totalCount = 0;
        int errors = 0;
        for (int i4 = 0; i4 < RUNS; ++i4) {
            for (int j = 0; j < RUNS; ++j) {
                for (int k = 0; k < RUNS; ++k) {
                    if (started[i4][j][k].get()) {
                        ++executedCount;
                    }
                    if (started[i4][j][k].get() != closed[i4][j][k].get()) {
                        ++errors;
                    }
                    ++totalCount;
                }
            }
        }
        System.out.println("******* TOTAL: " + totalCount);
        System.out.println("******* EXECUTED: " + executedCount);
        System.out.println("******* ERRORS: " + errors);
        Assert.assertTrue((executedCount < totalCount ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)errors);
    }

    private static void ignoreException(ExceptionalRunnable callable) {
        try {
            callable.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class Service {
        int i;

        public Service(int i) {
            this.i = i;
        }

        public int getI() {
            return this.i;
        }
    }

    private static interface ExceptionalRunnable {
        public void run() throws Exception;
    }
}

