/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.internal;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.Publisher;
import org.apache.aries.component.dsl.internal.ProbeImpl;
import org.apache.aries.component.dsl.test.DSLTest;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Ignore
public class ProbeTests {
    static BundleContext bundleContext = FrameworkUtil.getBundle(DSLTest.class).getBundleContext();

    @Test
    public void testTupleTermination() {
        AtomicReference<String> result = new AtomicReference<String>("");
        ProbeImpl<String> probeA = new ProbeImpl<String>();
        AtomicReference probeBreference = new AtomicReference();
        OSGi program = probeA.flatMap(a -> OSGi.onClose(() -> result.accumulateAndGet("Hello", (x, y) -> x.replace((CharSequence)y, ""))).flatMap(__ -> {
            ProbeImpl<String> probeB = new ProbeImpl<String>();
            probeBreference.set(probeB);
            return probeB.flatMap(b -> OSGi.onClose(() -> result.accumulateAndGet(", World", (x, y) -> x.replace((CharSequence)y, ""))).then(OSGi.just(a + b)));
        }));
        program.run(bundleContext, newValue -> {
            result.set((String)newValue);
            return OSGi.NOOP;
        });
        Publisher opA = probeA.getPublisher();
        Object sentA = opA.apply("Hello");
        Publisher opB = ((ProbeImpl)probeBreference.get()).getPublisher();
        sentA.run();
        Object sentB = opB.apply(", World");
        sentB.run();
        Assert.assertEquals((Object)"", (Object)result.get());
        program.run(bundleContext, newValue -> {
            result.set((String)newValue);
            return OSGi.NOOP;
        });
        opA = probeA.getPublisher();
        sentA = opA.apply("Hello");
        opB = ((ProbeImpl)probeBreference.get()).getPublisher();
        sentB = opB.apply(", World");
        Assert.assertEquals((Object)"Hello, World", (Object)result.get());
        sentA.run();
        sentB.run();
        Assert.assertEquals((Object)"", (Object)result.get());
    }

    @Test
    public void testProbe() {
        AtomicInteger result = new AtomicInteger();
        ProbeImpl<Integer> probeA = new ProbeImpl<Integer>();
        OSGi<Integer> just10 = OSGi.just(10);
        OSGi program = probeA.flatMap(a -> OSGi.onClose(result::incrementAndGet).then(just10.flatMap(b -> OSGi.onClose(result::incrementAndGet).then(OSGi.just(a + b)))));
        program.run(bundleContext, newValue -> {
            result.set((int)newValue);
            return OSGi.NOOP;
        });
        Assert.assertEquals((long)0L, (long)result.get());
        Publisher opA = probeA.getPublisher();
        Object sentA = opA.apply((Object)5);
        Assert.assertEquals((long)15L, (long)result.get());
        sentA.run();
        Assert.assertEquals((long)17L, (long)result.get());
        sentA = opA.apply((Object)10);
        Assert.assertEquals((long)20L, (long)result.get());
        sentA.run();
        Assert.assertEquals((long)22L, (long)result.get());
    }
}

