/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.component.dsl.Utils;
import org.apache.aries.component.dsl.test.DSLTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;

public class ComponentTest {
    static BundleContext _bundleContext = FrameworkUtil.getBundle(DSLTest.class).getBundleContext();
    private static ConfigurationAdmin _configurationAdmin;
    private static ServiceReference<ConfigurationAdmin> _configAdminServiceReference;

    @BeforeClass
    public static void setupClass() {
        _configAdminServiceReference = _bundleContext.getServiceReference(ConfigurationAdmin.class);
        _configurationAdmin = (ConfigurationAdmin)_bundleContext.getService(_configAdminServiceReference);
    }

    @AfterClass
    public static void tearDownClass() {
        _bundleContext.ungetService(_configAdminServiceReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComponent() throws IOException {
        OSGi program = OSGi.configurations("org.components.MyComponent").flatMap(props -> OSGi.services(Service.class).flatMap(ms -> OSGi.just(new Component((Dictionary<String, ?>)props, (Service)ms)).flatMap(component -> {
            OSGi[] oSGiArray = new OSGi[2];
            oSGiArray[0] = ComponentTest.dynamic(ComponentTest.highestService(ServiceOptional.class), component::setOptional, c -> component.setOptional(null));
            oSGiArray[1] = ComponentTest.dynamic(OSGi.services(ServiceForList.class), component::addService, component::removeService);
            return OSGi.register(Component.class, component, new HashMap<String, Object>()).then(OSGi.all(oSGiArray));
        })));
        ServiceTracker serviceTracker = new ServiceTracker(_bundleContext, Component.class, null);
        serviceTracker.open();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        _bundleContext.registerService(ManagedService.class, dictionary -> countDownLatch.countDown(), (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("service.pid", "org.components.MyComponent");
            }
        });
        Configuration factoryConfiguration = null;
        try (OSGiResult run2 = program.run(_bundleContext);){
            factoryConfiguration = _configurationAdmin.createFactoryConfiguration("org.components.MyComponent");
            factoryConfiguration.update(new Hashtable());
            countDownLatch.await(10L, TimeUnit.SECONDS);
            Assert.assertNull((Object)serviceTracker.getService());
            ServiceRegistration serviceRegistration = _bundleContext.registerService(Service.class, (Object)new Service(), new Hashtable());
            Component component = (Component)serviceTracker.waitForService(10000L);
            Assert.assertNotNull((Object)component);
            Assert.assertNull((Object)component.getOptional());
            ServiceRegistration serviceRegistration2 = _bundleContext.registerService(ServiceOptional.class, (Object)new ServiceOptional(), new Hashtable());
            Thread.sleep(1000L);
            Assert.assertNotNull((Object)component.getOptional());
            ServiceOptional serviceOptional = new ServiceOptional();
            ServiceRegistration serviceRegistration3 = _bundleContext.registerService(ServiceOptional.class, (Object)serviceOptional, (Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("service.ranking", 1);
                }
            });
            Assert.assertEquals((Object)serviceOptional, (Object)component.getOptional());
            serviceRegistration3.unregister();
            Assert.assertNotNull((Object)component.getOptional());
            serviceRegistration2.unregister();
            Assert.assertNull((Object)component.getOptional());
            ServiceRegistration serviceRegistration4 = _bundleContext.registerService(ServiceForList.class, (Object)new ServiceForList(), new Hashtable());
            ServiceRegistration serviceRegistration5 = _bundleContext.registerService(ServiceForList.class, (Object)new ServiceForList(), new Hashtable());
            Assert.assertEquals((long)2L, (long)component.getServiceForLists().size());
            serviceRegistration4.unregister();
            Assert.assertEquals((long)1L, (long)component.getServiceForLists().size());
            serviceRegistration5.unregister();
            Assert.assertEquals((long)0L, (long)component.getServiceForLists().size());
            serviceRegistration.unregister();
            Assert.assertNull((Object)serviceTracker.getService());
        }
        catch (IOException run2) {
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Timeout waiting for configuration");
        }
        finally {
            serviceTracker.close();
            if (factoryConfiguration != null) {
                factoryConfiguration.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComponentApplicative() throws IOException, TimeoutException {
        OSGi program = OSGi.combine((x$0, x$1) -> new Component((Dictionary<String, ?>)x$0, (Service)x$1), OSGi.configurations("org.components.MyComponent"), OSGi.services(Service.class)).flatMap(comp -> {
            OSGi[] oSGiArray = new OSGi[2];
            oSGiArray[0] = ComponentTest.dynamic(ComponentTest.highestService(ServiceOptional.class), comp::setOptional, c -> comp.setOptional(null));
            oSGiArray[1] = ComponentTest.dynamic(OSGi.services(ServiceForList.class), comp::addService, comp::removeService);
            return OSGi.register(Component.class, comp, new HashMap<String, Object>()).then(OSGi.all(oSGiArray));
        });
        ServiceTracker serviceTracker = new ServiceTracker(_bundleContext, Component.class, null);
        serviceTracker.open();
        Configuration factoryConfiguration = null;
        try (OSGiResult run2 = program.run(_bundleContext);){
            factoryConfiguration = _configurationAdmin.createFactoryConfiguration("org.components.MyComponent");
            factoryConfiguration.update(new Hashtable());
            Thread.sleep(1000L);
            Assert.assertNull((Object)serviceTracker.getService());
            ServiceRegistration serviceRegistration = _bundleContext.registerService(Service.class, (Object)new Service(), new Hashtable());
            Component component = (Component)serviceTracker.waitForService(10000L);
            Assert.assertNotNull((Object)component);
            ServiceRegistration serviceRegistration10 = _bundleContext.registerService(Service.class, (Object)new Service(), new Hashtable());
            Assert.assertEquals((long)2L, (long)serviceTracker.getServiceReferences().length);
            Configuration factoryConfiguration2 = _configurationAdmin.createFactoryConfiguration("org.components.MyComponent");
            factoryConfiguration2.update(new Hashtable());
            Thread.sleep(1000L);
            Assert.assertEquals((long)4L, (long)serviceTracker.getServiceReferences().length);
            factoryConfiguration2.delete();
            Thread.sleep(1000L);
            Assert.assertEquals((long)2L, (long)serviceTracker.getServiceReferences().length);
            serviceRegistration10.unregister();
            Assert.assertNull((Object)component.getOptional());
            ServiceRegistration serviceRegistration2 = _bundleContext.registerService(ServiceOptional.class, (Object)new ServiceOptional(), new Hashtable());
            Thread.sleep(1000L);
            Assert.assertNotNull((Object)component.getOptional());
            ServiceOptional serviceOptional = new ServiceOptional();
            ServiceRegistration serviceRegistration3 = _bundleContext.registerService(ServiceOptional.class, (Object)serviceOptional, (Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("service.ranking", 1);
                }
            });
            Assert.assertEquals((Object)serviceOptional, (Object)component.getOptional());
            serviceRegistration3.unregister();
            Assert.assertNotNull((Object)component.getOptional());
            serviceRegistration2.unregister();
            Assert.assertNull((Object)component.getOptional());
            ServiceRegistration serviceRegistration4 = _bundleContext.registerService(ServiceForList.class, (Object)new ServiceForList(), new Hashtable());
            ServiceRegistration serviceRegistration5 = _bundleContext.registerService(ServiceForList.class, (Object)new ServiceForList(), new Hashtable());
            Assert.assertEquals((long)2L, (long)component.getServiceForLists().size());
            serviceRegistration4.unregister();
            Assert.assertEquals((long)1L, (long)component.getServiceForLists().size());
            serviceRegistration5.unregister();
            Assert.assertEquals((long)0L, (long)component.getServiceForLists().size());
            serviceRegistration.unregister();
            Assert.assertNull((Object)serviceTracker.getService());
        }
        catch (IOException run2) {
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Timeout waiting for configuration");
        }
        finally {
            serviceTracker.close();
            if (factoryConfiguration != null) {
                factoryConfiguration.delete();
            }
        }
    }

    private static <T> OSGi<T> highestService(Class<T> clazz) {
        return Utils.highest(OSGi.serviceReferences(clazz)).map(CachingServiceReference::getServiceReference).flatMap(sr -> OSGi.bundleContext().flatMap(bc -> OSGi.onClose(() -> bc.ungetService(sr)).then(OSGi.just(bc.getService(sr)))));
    }

    public static <T> OSGi<Void> dynamic(OSGi<T> program, Consumer<T> bind, Consumer<T> unbind) {
        return program.foreach(bind, unbind);
    }

    private class ServiceForList {
        private ServiceForList() {
        }
    }

    private class ServiceOptional {
        private ServiceOptional() {
        }
    }

    private class Service {
        private Service() {
        }
    }

    private class Component {
        final Dictionary<String, ?> configuration;
        final Service mandatory;
        private final ArrayList<ServiceForList> _serviceForLists;
        ServiceOptional optional = null;

        public Component(Dictionary<String, ?> configuration, Service mandatory) {
            this.configuration = configuration;
            this.mandatory = mandatory;
            this._serviceForLists = new ArrayList();
        }

        public Dictionary<String, ?> getConfiguration() {
            return this.configuration;
        }

        public Service getMandatory() {
            return this.mandatory;
        }

        public ServiceOptional getOptional() {
            return this.optional;
        }

        public void setOptional(ServiceOptional optional) {
            this.optional = optional;
        }

        public void addService(ServiceForList serviceForList) {
            this._serviceForLists.add(serviceForList);
        }

        public void removeService(ServiceForList serviceForList) {
            this._serviceForLists.remove(serviceForList);
        }

        public ArrayList<ServiceForList> getServiceForLists() {
            return this._serviceForLists;
        }
    }
}

