/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.internal;

import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.component.dsl.Publisher;
import org.apache.aries.component.dsl.Refresher;
import org.apache.aries.component.dsl.internal.OSGiImpl;
import org.apache.aries.component.dsl.internal.OSGiResultImpl;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceReferenceOSGi<T>
extends OSGiImpl<CachingServiceReference<T>> {
    public ServiceReferenceOSGi(String filterString, Class<T> clazz) {
        this(filterString, clazz, CachingServiceReference::isDirty);
    }

    public ServiceReferenceOSGi(String filterString, Class<T> clazz, Refresher<? super CachingServiceReference<T>> refresher) {
        super((bundleContext, op) -> {
            ServiceTracker serviceTracker = new ServiceTracker(bundleContext, ServiceReferenceOSGi.buildFilter(bundleContext, filterString, clazz), new DefaultServiceTrackerCustomizer(op, refresher));
            serviceTracker.open();
            return new OSGiResultImpl(() -> ((ServiceTracker)serviceTracker).close());
        });
    }

    private static class Tracked<T> {
        volatile CachingServiceReference<T> cachingServiceReference;
        volatile Runnable runnable;

        public Tracked(CachingServiceReference<T> cachingServiceReference, Runnable runnable) {
            this.cachingServiceReference = cachingServiceReference;
            this.runnable = runnable;
        }
    }

    private static class DefaultServiceTrackerCustomizer<T>
    implements ServiceTrackerCustomizer<T, Tracked<T>> {
        private final Publisher<? super CachingServiceReference<T>> _addedSource;
        private Refresher<? super CachingServiceReference<T>> _refresher;

        public DefaultServiceTrackerCustomizer(Publisher<? super CachingServiceReference<T>> addedSource, Refresher<? super CachingServiceReference<T>> refresher) {
            this._addedSource = addedSource;
            this._refresher = refresher;
        }

        public Tracked<T> addingService(ServiceReference<T> reference) {
            CachingServiceReference<T> cachingServiceReference = new CachingServiceReference<T>(reference);
            return new Tracked<T>(cachingServiceReference, (Runnable)this._addedSource.apply((Object)cachingServiceReference));
        }

        public void modifiedService(ServiceReference<T> reference, Tracked<T> tracked) {
            if (this._refresher.test(tracked.cachingServiceReference)) {
                tracked.runnable.run();
                tracked.cachingServiceReference = new CachingServiceReference<T>(reference);
                tracked.runnable = this._addedSource.apply((Object)tracked.cachingServiceReference);
            }
        }

        public void removedService(ServiceReference<T> reference, Tracked<T> tracked) {
            tracked.runnable.run();
        }
    }
}

