/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.component.dsl.Publisher;
import org.apache.aries.component.dsl.internal.OSGiImpl;
import org.apache.aries.component.dsl.internal.OSGiResultImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class ConfigurationsOSGiImpl
extends OSGiImpl<Dictionary<String, ?>> {
    public ConfigurationsOSGiImpl(final String factoryPid) {
        super((BundleContext bundleContext, Publisher<T> op) -> {
            ConcurrentHashMap<String, Runnable> results = new ConcurrentHashMap<String, Runnable>();
            AtomicBoolean closed = new AtomicBoolean();
            ServiceRegistration serviceRegistration = bundleContext.registerService(ManagedServiceFactory.class, (Object)new ConfigurationsManagedServiceFactory(results, op, closed), (Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("service.pid", factoryPid);
                }
            });
            return new OSGiResultImpl(() -> {
                closed.set(true);
                serviceRegistration.unregister();
                results.values().forEach(Runnable::run);
                results.clear();
            });
        });
    }

    private static class ConfigurationsManagedServiceFactory
    implements ManagedServiceFactory {
        private final Map<String, Runnable> _results;
        private final Publisher<? super Dictionary<String, ?>> _op;
        private AtomicBoolean _closed;

        public ConfigurationsManagedServiceFactory(Map<String, Runnable> results, Publisher<? super Dictionary<String, ?>> op, AtomicBoolean closed) {
            this._results = results;
            this._op = op;
            this._closed = closed;
        }

        public void deleted(String s) {
            Runnable runnable = this._results.remove(s);
            runnable.run();
        }

        public String getName() {
            return "Functional OSGi Managed Service Factory";
        }

        public void updated(String s, Dictionary<String, ?> dictionary) throws ConfigurationException {
            Object terminator = this._op.apply((Object)dictionary);
            Runnable old = this._results.put(s, (Runnable)terminator);
            if (old != null) {
                old.run();
            }
            if (this._closed.get()) {
                this._results.computeIfPresent(s, (key, runnable) -> {
                    runnable.run();
                    return null;
                });
            }
        }
    }
}

