/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.tests;

import java.util.ArrayList;
import java.util.List;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.rbac.RBACManagerListener;
import org.apache.archiva.redback.rbac.Role;
import org.apache.archiva.redback.rbac.UserAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbacManagerEventTracker
implements RBACManagerListener {
    public long initCount = 0L;
    public Boolean lastDbFreshness;
    public List<String> addedRoleNames = new ArrayList<String>();
    public List<String> removedRoleNames = new ArrayList<String>();
    public List<String> addedPermissionNames = new ArrayList<String>();
    public List<String> removedPermissionNames = new ArrayList<String>();
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public void rbacInit(boolean freshdb) {
        this.log("Init - freshdb: " + freshdb);
        ++this.initCount;
        this.lastDbFreshness = freshdb;
    }

    public void rbacPermissionRemoved(Permission permission) {
        this.log("Permission Removed: " + permission.getName());
        String obj = permission.getName();
        if (!this.removedPermissionNames.contains(obj)) {
            this.removedPermissionNames.add(obj);
        }
    }

    public void rbacPermissionSaved(Permission permission) {
        this.log("Permission Saved: " + permission.getName());
        String obj = permission.getName();
        if (!this.addedPermissionNames.contains(obj)) {
            this.addedPermissionNames.add(obj);
        }
    }

    public void rbacRoleRemoved(Role role) {
        this.log("Role Removed: " + role.getName());
        String obj = role.getName();
        if (!this.removedRoleNames.contains(obj)) {
            this.removedRoleNames.add(obj);
        }
    }

    public void rbacRoleSaved(Role role) {
        this.log("Role Saved: " + role.getName());
        String obj = role.getName();
        if (!this.addedRoleNames.contains(obj)) {
            this.addedRoleNames.add(obj);
        }
    }

    public void rbacUserAssignmentRemoved(UserAssignment userAssignment) {
    }

    public void rbacUserAssignmentSaved(UserAssignment userAssignment) {
    }

    private void log(String msg) {
        this.logger.info("[RBAC Event Tracker] : {}", (Object)msg);
    }
}

