/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.tests;

import java.util.Collections;
import junit.framework.TestCase;
import org.apache.archiva.redback.rbac.Operation;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.Resource;
import org.apache.archiva.redback.rbac.Role;
import org.apache.archiva.redback.rbac.UserAssignment;
import org.apache.archiva.redback.tests.utils.RBACDefaults;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath*:/META-INF/spring-context.xml", "classpath*:/spring-context.xml"})
public class AbstractRbacManagerPerformanceTestCase
extends TestCase {
    private RBACManager rbacManager;
    private RBACDefaults rbacDefaults;
    private static final int ITERATIONS = 10000;
    private static final int ONESECOND = 1000;

    public void setRbacManager(RBACManager store) {
        this.rbacManager = store;
        this.rbacDefaults = new RBACDefaults(this.rbacManager);
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    private Role getDeveloperRole() throws RbacManagerException {
        Role role = this.rbacManager.createRole("DEVELOPER");
        role.setAssignable(true);
        Permission perm = this.rbacManager.createPermission("EDIT_MY_USER", "EDIT", "User:Self");
        role.addPermission(perm);
        return role;
    }

    private Role getSuperDeveloperRole() {
        Role role = this.rbacManager.createRole("SUPER_DEVELOPER");
        role.setAssignable(true);
        return role;
    }

    public void assertPerformance(String msg, long startTime, long endTime, int iterations, double threshold) {
        long elapsed = endTime - startTime;
        double ratio = (double)elapsed / 1000.0;
        double opsPerSecond = (double)iterations / ratio;
        System.out.println("Performance " + msg + ": " + opsPerSecond + " operations per second. (effective)");
        if (opsPerSecond < threshold) {
            StringBuilder stats = new StringBuilder();
            stats.append("Stats on ").append(msg);
            stats.append("\nStart Time (ms): ").append(Long.toString(startTime));
            stats.append("\nEnd Time (ms)  : ").append(Long.toString(endTime));
            stats.append("\nElapsed (ms)   : ").append(Long.toString(elapsed));
            stats.append("\nRatio          : ").append(Double.toString(ratio));
            stats.append("\nOps per second : ").append(Double.toString(opsPerSecond));
            System.out.println(stats.toString());
            AbstractRbacManagerPerformanceTestCase.fail((String)("Performance Error: " + msg + " expecting greater than [" + threshold + "], actual [" + opsPerSecond + "]"));
        }
    }

    @Test
    public void testPerformanceResource() throws RbacManagerException {
        AbstractRbacManagerPerformanceTestCase.assertNotNull((Object)this.rbacManager);
        this.rbacManager.eraseDatabase();
        Resource resource = this.rbacManager.createResource("foo");
        Resource resource2 = this.rbacManager.createResource("bar");
        AbstractRbacManagerPerformanceTestCase.assertNotNull((Object)resource);
        Resource added = this.rbacManager.saveResource(resource);
        AbstractRbacManagerPerformanceTestCase.assertNotNull((Object)added);
        Resource added2 = this.rbacManager.saveResource(resource2);
        AbstractRbacManagerPerformanceTestCase.assertNotNull((Object)added2);
        AbstractRbacManagerPerformanceTestCase.assertEquals((int)2, (int)this.rbacManager.getAllResources().size());
        String resFooId = resource.getIdentifier();
        String resBarId = resource2.getIdentifier();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i <= 10000; ++i) {
            Resource resFoo = this.rbacManager.getResource(resFooId);
            Resource resBar = this.rbacManager.getResource(resBarId);
            AbstractRbacManagerPerformanceTestCase.assertNotNull((Object)resFoo);
            AbstractRbacManagerPerformanceTestCase.assertNotNull((Object)resBar);
            AbstractRbacManagerPerformanceTestCase.assertEquals((String)"foo", (String)resFoo.getIdentifier());
            AbstractRbacManagerPerformanceTestCase.assertEquals((String)"bar", (String)resBar.getIdentifier());
        }
        long endTime = System.currentTimeMillis();
        this.assertPerformance("Resource", startTime, endTime, 10000, 500.0);
    }

    @Test
    public void testPerformanceUserAssignment() throws RbacManagerException {
        RBACManager manager = this.rbacManager;
        this.rbacManager.eraseDatabase();
        Role devRole = this.getDeveloperRole();
        Role devPlusRole = this.getSuperDeveloperRole();
        devPlusRole.setChildRoleNames(Collections.singletonList(devRole.getName()));
        devRole = manager.saveRole(devRole);
        devPlusRole = manager.saveRole(devPlusRole);
        String username = "bob";
        UserAssignment assignment = manager.createUserAssignment(username);
        assignment.addRoleName(devRole);
        assignment = manager.saveUserAssignment(assignment);
        AbstractRbacManagerPerformanceTestCase.assertEquals((int)1, (int)manager.getAllUserAssignments().size());
        AbstractRbacManagerPerformanceTestCase.assertEquals((String)"should be only one role assigned", (int)1, (int)manager.getAssignedRoles(assignment.getPrincipal()).size());
        AbstractRbacManagerPerformanceTestCase.assertEquals((String)"should be one role left to assign", (int)1, (int)manager.getUnassignedRoles(assignment.getPrincipal()).size());
        AbstractRbacManagerPerformanceTestCase.assertEquals((int)2, (int)manager.getAllRoles().size());
        assignment.addRoleName(devRole.getName());
        manager.saveUserAssignment(assignment);
        AbstractRbacManagerPerformanceTestCase.assertEquals((int)1, (int)assignment.getRoleNames().size());
        String bobId = assignment.getPrincipal();
        username = "janet";
        devPlusRole.setChildRoleNames(Collections.singletonList(devRole.getName()));
        devRole = manager.saveRole(devRole);
        manager.saveRole(devPlusRole);
        assignment = manager.createUserAssignment(username);
        assignment.addRoleName(devRole);
        assignment = manager.saveUserAssignment(assignment);
        AbstractRbacManagerPerformanceTestCase.assertEquals((int)2, (int)manager.getAllUserAssignments().size());
        AbstractRbacManagerPerformanceTestCase.assertEquals((String)"should be only one role assigned", (int)1, (int)manager.getAssignedRoles(assignment.getPrincipal()).size());
        AbstractRbacManagerPerformanceTestCase.assertEquals((String)"should be one role left to assign", (int)1, (int)manager.getUnassignedRoles(assignment.getPrincipal()).size());
        AbstractRbacManagerPerformanceTestCase.assertEquals((int)2, (int)manager.getAllRoles().size());
        assignment.addRoleName(devRole.getName());
        manager.saveUserAssignment(assignment);
        AbstractRbacManagerPerformanceTestCase.assertEquals((int)1, (int)assignment.getRoleNames().size());
        String janetId = assignment.getPrincipal();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i <= 10000; ++i) {
            UserAssignment uaBob = this.rbacManager.getUserAssignment(bobId);
            UserAssignment uaJanet = this.rbacManager.getUserAssignment(janetId);
            AbstractRbacManagerPerformanceTestCase.assertNotNull((Object)uaBob);
            AbstractRbacManagerPerformanceTestCase.assertNotNull((Object)uaJanet);
            AbstractRbacManagerPerformanceTestCase.assertEquals((String)"bob", (String)uaBob.getPrincipal());
            AbstractRbacManagerPerformanceTestCase.assertEquals((String)"janet", (String)uaJanet.getPrincipal());
        }
        long endTime = System.currentTimeMillis();
        this.assertPerformance("UserAssignment", startTime, endTime, 10000, 350.0);
    }

    @Test
    public void testPerformanceRoles() throws RbacManagerException {
        this.rbacDefaults.createDefaults();
        String roleIdSysAdmin = "System Administrator";
        String roleIdUserAdmin = "User Administrator";
        long startTime = System.currentTimeMillis();
        for (int i = 0; i <= 10000; ++i) {
            Role roleSysAdmin = this.rbacManager.getRole(roleIdSysAdmin);
            Role roleUserAdmin = this.rbacManager.getRole(roleIdUserAdmin);
            AbstractRbacManagerPerformanceTestCase.assertNotNull((Object)roleSysAdmin);
            AbstractRbacManagerPerformanceTestCase.assertNotNull((Object)roleUserAdmin);
            AbstractRbacManagerPerformanceTestCase.assertEquals((String)roleIdSysAdmin, (String)roleSysAdmin.getName());
            AbstractRbacManagerPerformanceTestCase.assertEquals((String)roleIdUserAdmin, (String)roleUserAdmin.getName());
        }
        long endTime = System.currentTimeMillis();
        this.assertPerformance("Roles", startTime, endTime, 10000, 130.0);
    }

    @Test
    public void testPerformancePermissions() throws RbacManagerException {
        this.rbacDefaults.createDefaults();
        String permIdRunIndexer = "Run Indexer";
        String permIdAddRepo = "Add Repository";
        long startTime = System.currentTimeMillis();
        for (int i = 0; i <= 10000; ++i) {
            Permission permRunIndex = this.rbacManager.getPermission(permIdRunIndexer);
            Permission permAddRepo = this.rbacManager.getPermission(permIdAddRepo);
            AbstractRbacManagerPerformanceTestCase.assertNotNull((Object)permRunIndex);
            AbstractRbacManagerPerformanceTestCase.assertNotNull((Object)permAddRepo);
            AbstractRbacManagerPerformanceTestCase.assertEquals((String)permIdRunIndexer, (String)permRunIndex.getName());
            AbstractRbacManagerPerformanceTestCase.assertEquals((String)permIdAddRepo, (String)permAddRepo.getName());
        }
        long endTime = System.currentTimeMillis();
        this.assertPerformance("Permissions", startTime, endTime, 10000, 350.0);
    }

    @Test
    public void testPerformanceOperations() throws RbacManagerException {
        this.rbacDefaults.createDefaults();
        String operIdEditRepo = "edit-repository";
        String operIdDelRepo = "delete-repository";
        long startTime = System.currentTimeMillis();
        for (int i = 0; i <= 10000; ++i) {
            Operation operEditRepo = this.rbacManager.getOperation(operIdEditRepo);
            Operation operDelRepo = this.rbacManager.getOperation(operIdDelRepo);
            AbstractRbacManagerPerformanceTestCase.assertNotNull((Object)operEditRepo);
            AbstractRbacManagerPerformanceTestCase.assertNotNull((Object)operDelRepo);
            AbstractRbacManagerPerformanceTestCase.assertEquals((String)operIdEditRepo, (String)operEditRepo.getName());
            AbstractRbacManagerPerformanceTestCase.assertEquals((String)operIdDelRepo, (String)operDelRepo.getName());
        }
        long endTime = System.currentTimeMillis();
        this.assertPerformance("Operations", startTime, endTime, 10000, 500.0);
    }
}

