/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.management;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.apache.archiva.redback.keys.AuthenticationKey;
import org.apache.archiva.redback.keys.KeyManager;
import org.apache.archiva.redback.keys.KeyManagerException;
import org.apache.archiva.redback.keys.jdo.AuthenticationKeyDatabase;
import org.apache.archiva.redback.keys.jdo.io.stax.RedbackKeyManagementJdoStaxReader;
import org.apache.archiva.redback.keys.jdo.io.stax.RedbackKeyManagementJdoStaxWriter;
import org.apache.archiva.redback.management.DataManagementTool;
import org.apache.archiva.redback.rbac.Operation;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.Resource;
import org.apache.archiva.redback.rbac.Role;
import org.apache.archiva.redback.rbac.UserAssignment;
import org.apache.archiva.redback.rbac.jdo.RbacDatabase;
import org.apache.archiva.redback.rbac.jdo.io.stax.RbacJdoModelStaxReader;
import org.apache.archiva.redback.rbac.jdo.io.stax.RbacJdoModelStaxWriter;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.jdo.UserDatabase;
import org.apache.archiva.redback.users.jdo.io.stax.UsersManagementStaxReader;
import org.apache.archiva.redback.users.jdo.io.stax.UsersManagementStaxWriter;
import org.codehaus.plexus.util.IOUtil;
import org.springframework.stereotype.Service;

@Service(value="dataManagementTool#jdo")
public class JdoDataManagementTool
implements DataManagementTool {
    private static final String USERS_XML_NAME = "users.xml";
    private static final String KEYS_XML_NAME = "keys.xml";
    private static final String RBAC_XML_NAME = "rbac.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupRBACDatabase(RBACManager manager, File backupDirectory) throws RbacManagerException, IOException, XMLStreamException {
        RbacDatabase database = new RbacDatabase();
        database.setRoles(manager.getAllRoles());
        database.setUserAssignments(manager.getAllUserAssignments());
        database.setPermissions(manager.getAllPermissions());
        database.setOperations(manager.getAllOperations());
        database.setResources(manager.getAllResources());
        RbacJdoModelStaxWriter writer = new RbacJdoModelStaxWriter();
        Writer fileWriter = this.createWriter(backupDirectory, RBAC_XML_NAME, database.getModelEncoding());
        try {
            writer.write(fileWriter, database);
        }
        finally {
            IOUtil.close((Writer)fileWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupUserDatabase(UserManager manager, File backupDirectory) throws IOException, XMLStreamException {
        UserDatabase database = new UserDatabase();
        database.setUsers(manager.getUsers());
        UsersManagementStaxWriter writer = new UsersManagementStaxWriter();
        Writer fileWriter = this.createWriter(backupDirectory, USERS_XML_NAME, database.getModelEncoding());
        try {
            writer.write(fileWriter, database);
        }
        finally {
            IOUtil.close((Writer)fileWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupKeyDatabase(KeyManager manager, File backupDirectory) throws IOException, XMLStreamException {
        try {
            manager.removeExpiredKeys();
        }
        catch (KeyManagerException e) {
            throw new IOException("Error removing expired keys");
        }
        AuthenticationKeyDatabase database = new AuthenticationKeyDatabase();
        database.setKeys(manager.getAllKeys());
        RedbackKeyManagementJdoStaxWriter writer = new RedbackKeyManagementJdoStaxWriter();
        Writer fileWriter = this.createWriter(backupDirectory, KEYS_XML_NAME, database.getModelEncoding());
        try {
            writer.write(fileWriter, database);
        }
        finally {
            IOUtil.close((Writer)fileWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreRBACDatabase(RBACManager manager, File backupDirectory) throws IOException, XMLStreamException, RbacManagerException {
        RbacDatabase database;
        RbacJdoModelStaxReader reader = new RbacJdoModelStaxReader();
        FileReader fileReader = new FileReader(new File(backupDirectory, RBAC_XML_NAME));
        try {
            database = reader.read((Reader)fileReader);
        }
        finally {
            IOUtil.close((Reader)fileReader);
        }
        HashMap<String, Permission> permissionMap = new HashMap<String, Permission>();
        HashMap<String, Resource> resources = new HashMap<String, Resource>();
        HashMap<String, Operation> operations = new HashMap<String, Operation>();
        for (Role role : database.getRoles()) {
            ArrayList<Permission> permissions = new ArrayList<Permission>();
            for (Permission permission : role.getPermissions()) {
                if (permissionMap.containsKey(permission.getName())) {
                    permission = (Permission)permissionMap.get(permission.getName());
                } else if (manager.permissionExists(permission)) {
                    permission = manager.getPermission(permission.getName());
                    permissionMap.put(permission.getName(), permission);
                } else {
                    Operation operation = permission.getOperation();
                    if (operations.containsKey(operation.getName())) {
                        operation = (Operation)operations.get(operation.getName());
                    } else if (manager.operationExists(operation)) {
                        operation = manager.getOperation(operation.getName());
                        operations.put(operation.getName(), operation);
                    } else {
                        operation = manager.saveOperation(operation);
                        operations.put(operation.getName(), operation);
                    }
                    permission.setOperation(operation);
                    Resource resource = permission.getResource();
                    if (resources.containsKey(resource.getIdentifier())) {
                        resource = (Resource)resources.get(resource.getIdentifier());
                    } else if (manager.resourceExists(resource)) {
                        resource = manager.getResource(resource.getIdentifier());
                        resources.put(resource.getIdentifier(), resource);
                    } else {
                        resource = manager.saveResource(resource);
                        resources.put(resource.getIdentifier(), resource);
                    }
                    permission.setResource(resource);
                    permission = manager.savePermission(permission);
                    permissionMap.put(permission.getName(), permission);
                }
                permissions.add(permission);
            }
            role.setPermissions(permissions);
            manager.saveRole(role);
        }
        for (UserAssignment userAssignment : database.getUserAssignments()) {
            manager.saveUserAssignment(userAssignment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreUsersDatabase(UserManager manager, File backupDirectory) throws IOException, XMLStreamException {
        UserDatabase database;
        UsersManagementStaxReader reader = new UsersManagementStaxReader();
        FileReader fileReader = new FileReader(new File(backupDirectory, USERS_XML_NAME));
        try {
            database = reader.read((Reader)fileReader);
        }
        finally {
            IOUtil.close((Reader)fileReader);
        }
        for (User user : database.getUsers()) {
            manager.addUserUnchecked(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreKeysDatabase(KeyManager manager, File backupDirectory) throws IOException, XMLStreamException {
        AuthenticationKeyDatabase database;
        RedbackKeyManagementJdoStaxReader reader = new RedbackKeyManagementJdoStaxReader();
        FileReader fileReader = new FileReader(new File(backupDirectory, KEYS_XML_NAME));
        try {
            database = reader.read((Reader)fileReader);
        }
        finally {
            IOUtil.close((Reader)fileReader);
        }
        for (AuthenticationKey key : database.getKeys()) {
            manager.addKey(key);
        }
    }

    public void eraseRBACDatabase(RBACManager manager) {
        manager.eraseDatabase();
    }

    public void eraseUsersDatabase(UserManager manager) {
        manager.eraseDatabase();
    }

    public void eraseKeysDatabase(KeyManager manager) {
        manager.eraseDatabase();
    }

    private Writer createWriter(File directory, String file, String encoding) throws FileNotFoundException {
        File f = new File(directory, file);
        File parentFile = f.getParentFile();
        parentFile.mkdirs();
        FileOutputStream out = new FileOutputStream(f);
        return new OutputStreamWriter((OutputStream)out, Charset.forName(encoding));
    }
}

