/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.common.jdo;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.components.jdo.DefaultConfigurableJdoFactory;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="jdoFactory#users")
public class UserConfigurableJdoFactory
extends DefaultConfigurableJdoFactory {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private UserConfiguration userConfiguration;

    @Inject
    public UserConfigurableJdoFactory(@Named(value="userConfiguration#default") UserConfiguration userConfiguration) {
        this.userConfiguration = userConfiguration;
    }

    private String getConfigString(String key, String currentValue, String defaultValue) {
        String valueFromSysProps = System.getProperty("redback." + key);
        if (StringUtils.isNotEmpty((String)valueFromSysProps)) {
            return valueFromSysProps;
        }
        String value = null;
        value = StringUtils.isNotEmpty((String)currentValue) ? this.userConfiguration.getString(key, currentValue) : this.userConfiguration.getString(key, defaultValue);
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(System.getProperties()));
        try {
            return interpolator.interpolate(value);
        }
        catch (InterpolationException e) {
            this.log.warn("skip issue during interpolation {}", (Object)e.getMessage());
            return value;
        }
    }

    @PostConstruct
    public void initialize() {
        String jdbcDriverName = this.getConfigString("jdbc.driver.name", super.getDriverName(), "org.apache.derby.jdbc.EmbeddedDriver");
        String jdbcUrl = this.getConfigString("jdbc.url", super.getUrl(), "jdbc:derby:${plexus.home}/database;create=true");
        String jdbcUsername = this.getConfigString("jdbc.username", super.getUserName(), "sa");
        String jdbcPassword = this.getConfigString("jdbc.password", super.getPassword(), "");
        super.setDriverName(jdbcDriverName);
        super.setUrl(jdbcUrl);
        super.setUserName(jdbcUsername);
        super.setPassword(jdbcPassword);
        if (StringUtils.isEmpty((String)this.persistenceManagerFactoryClass)) {
            super.setPersistenceManagerFactoryClass("org.jpox.PersistenceManagerFactoryImpl");
        }
        if (this.otherProperties == null || this.otherProperties.isEmpty()) {
            super.setProperty("org.jpox.autoCreateSchema", "true");
            super.setProperty("org.jpox.validateSchema", "false");
            super.setProperty("org.jpox.validateTables", "false");
            super.setProperty("org.jpox.validateConstraints", "false");
            super.setProperty("org.jpox.transactionIsolation", "READ_COMMITTED");
            super.setProperty("org.jpox.rdbms.dateTimezone", "JDK_DEFAULT_TIMEZONE");
        }
        super.initialize();
    }

    public UserConfiguration getUserConfiguration() {
        return this.userConfiguration;
    }

    public void setUserConfiguration(UserConfiguration userConfiguration) {
        this.userConfiguration = userConfiguration;
    }
}

