/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.authorization.rbac.evaluator;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.authorization.rbac.evaluator.PermissionEvaluationException;
import org.apache.archiva.redback.authorization.rbac.evaluator.PermissionEvaluator;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="permissionEvaluator")
public class DefaultPermissionEvaluator
implements PermissionEvaluator {
    @Inject
    @Named(value="userManager#default")
    private UserManager userManager;

    @Override
    public boolean evaluate(Permission permission, String operation, String resource, String principal) throws PermissionEvaluationException {
        String tempStr;
        String permissionResource = permission.getResource().getIdentifier();
        if (permissionResource.startsWith("${") && "username".equals(tempStr = permissionResource.substring(2, permissionResource.indexOf(125)))) {
            try {
                permissionResource = this.userManager.findUser(principal).getUsername();
            }
            catch (UserNotFoundException e) {
                throw new PermissionEvaluationException("unable to locate user to retrieve username", e);
            }
            catch (UserManagerException e) {
                throw new PermissionEvaluationException("trouble finding user: " + e.getMessage(), e);
            }
        }
        if (permission.getOperation().getName().equals(operation)) {
            if ("*".equals(permission.getResource().getIdentifier())) {
                return true;
            }
            if (resource == null) {
                return true;
            }
            if (permissionResource.equals(resource)) {
                return true;
            }
        }
        return false;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

