/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.authorization.rbac;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.authorization.AuthorizationDataSource;
import org.apache.archiva.redback.authorization.AuthorizationException;
import org.apache.archiva.redback.authorization.AuthorizationResult;
import org.apache.archiva.redback.authorization.Authorizer;
import org.apache.archiva.redback.authorization.NotAuthorizedException;
import org.apache.archiva.redback.authorization.rbac.evaluator.PermissionEvaluationException;
import org.apache.archiva.redback.authorization.rbac.evaluator.PermissionEvaluator;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.RbacObjectNotFoundException;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="authorizer#rbac")
public class RbacAuthorizer
implements Authorizer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    @Named(value="rbacManager#default")
    private RBACManager manager;
    @Inject
    @Named(value="userManager#default")
    private UserManager userManager;
    @Inject
    private PermissionEvaluator evaluator;

    public String getId() {
        return "rbac";
    }

    public AuthorizationResult isAuthorized(AuthorizationDataSource source) throws AuthorizationException {
        String principal = source.getPrincipal();
        String operation = source.getPermission();
        String resource = source.getResource();
        try {
            Map permissionMap;
            User guest;
            if (principal != null) {
                Map permissionMap2 = this.manager.getAssignedPermissionMap(principal);
                if (permissionMap2.keySet().contains(operation)) {
                    for (Permission permission : (List)permissionMap2.get(operation)) {
                        this.log.debug("checking permission {} for operation {} resource {}", new Object[]{permission != null ? permission.getName() : "null", operation, resource});
                        if (!this.evaluator.evaluate(permission, operation, resource, principal)) continue;
                        return new AuthorizationResult(true, (Object)permission, null);
                    }
                    this.log.debug("no permission found for operation {} resource {}", (Object)operation, (Object)resource);
                } else {
                    this.log.debug("permission map does not contain operation: {}", (Object)operation);
                }
            }
            if (!(guest = this.userManager.getGuestUser()).isLocked() && (permissionMap = this.manager.getAssignedPermissionMap(guest.getUsername())).keySet().contains(operation)) {
                for (Permission permission : (List)permissionMap.get(operation)) {
                    this.log.debug("checking permission {}", (Object)permission.getName());
                    if (!this.evaluator.evaluate(permission, operation, resource, guest.getUsername())) continue;
                    return new AuthorizationResult(true, (Object)permission, null);
                }
            }
            return new AuthorizationResult(false, null, (Exception)new NotAuthorizedException("no matching permissions"));
        }
        catch (PermissionEvaluationException pe) {
            return new AuthorizationResult(false, null, (Exception)pe);
        }
        catch (RbacObjectNotFoundException nfe) {
            return new AuthorizationResult(false, null, (Exception)((Object)nfe));
        }
        catch (UserNotFoundException ne) {
            return new AuthorizationResult(false, null, (Exception)new NotAuthorizedException("no matching permissions, guest not found"));
        }
        catch (RbacManagerException rme) {
            return new AuthorizationResult(false, null, (Exception)((Object)rme));
        }
        catch (UserManagerException e) {
            return new AuthorizationResult(false, null, (Exception)((Object)e));
        }
    }

    public RBACManager getManager() {
        return this.manager;
    }

    public void setManager(RBACManager manager) {
        this.manager = manager;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public PermissionEvaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(PermissionEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public boolean isFinalImplementation() {
        return true;
    }

    public String getDescriptionKey() {
        return "archiva.redback.authorizer.rbac";
    }
}

