/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.archiva.xml.LatinEntities;

public class LatinEntityResolutionReader
extends Reader {
    private BufferedReader originalReader;
    private char[] leftover;
    private Pattern entityPattern;

    public LatinEntityResolutionReader(Reader reader) {
        this.originalReader = new BufferedReader(reader);
        this.entityPattern = Pattern.compile("\\&[a-zA-Z]+\\;");
    }

    public int read(char[] destbuf, int offset, int length) throws IOException {
        StringBuffer sbuf;
        int tmp_length;
        int current_requested_offset = offset;
        int current_requested_length = length;
        if (this.leftover != null) {
            if (this.leftover.length > length) {
                System.arraycopy(this.leftover, 0, destbuf, current_requested_offset, length);
                char[] tmp = new char[length];
                System.arraycopy(this.leftover, length, tmp, 0, length);
                this.leftover = new char[tmp.length];
                System.arraycopy(tmp, 0, this.leftover, 0, length);
                return length;
            }
            tmp_length = this.leftover.length;
            System.arraycopy(this.leftover, 0, destbuf, current_requested_offset, tmp_length);
            this.leftover = null;
            current_requested_offset += tmp_length;
            current_requested_length -= tmp_length;
        }
        if ((sbuf = this.getExpandedBuffer(current_requested_length)) == null) {
            if (current_requested_offset > offset) {
                return current_requested_offset - offset;
            }
            return -1;
        }
        tmp_length = Math.min(sbuf.length(), current_requested_length);
        sbuf.getChars(0, tmp_length, destbuf, current_requested_offset);
        if (tmp_length < sbuf.length()) {
            this.leftover = new char[sbuf.length() - tmp_length];
            sbuf.getChars(tmp_length, tmp_length + this.leftover.length, this.leftover, 0);
        }
        return current_requested_offset - offset + tmp_length;
    }

    private StringBuffer getExpandedBuffer(int minimum_length) throws IOException {
        boolean done;
        StringBuffer buf = null;
        String line = this.originalReader.readLine();
        boolean bl = done = line == null;
        while (!done) {
            if (buf == null) {
                buf = new StringBuffer();
            }
            buf.append(this.expandLine(line));
            if (this.originalReader.ready()) {
                buf.append("\n");
            }
            if (buf.length() > minimum_length) {
                done = true;
                continue;
            }
            line = this.originalReader.readLine();
            done = line == null;
        }
        return buf;
    }

    private String expandLine(String line) {
        StringBuffer ret = new StringBuffer();
        int offset = 0;
        Matcher mat = this.entityPattern.matcher(line);
        while (mat.find(offset)) {
            ret.append(line.substring(offset, mat.start()));
            String entity = mat.group();
            ret.append(LatinEntities.resolveEntity(entity));
            offset = mat.start() + entity.length();
        }
        ret.append(line.substring(offset));
        return ret.toString();
    }

    public void close() throws IOException {
        this.originalReader.close();
    }
}

