/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.transaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.archiva.transaction.AbstractTransactionEvent;
import org.apache.archiva.transaction.CopyFileEvent;
import org.apache.archiva.transaction.CreateFileEvent;
import org.apache.archiva.transaction.TransactionEvent;
import org.apache.archiva.transaction.TransactionException;
import org.codehaus.plexus.digest.Digester;

public class FileTransaction {
    private List<AbstractTransactionEvent> events = new ArrayList<AbstractTransactionEvent>();

    public void commit() throws TransactionException {
        ArrayList<TransactionEvent> toRollback = new ArrayList<TransactionEvent>(this.events.size());
        for (TransactionEvent transactionEvent : this.events) {
            try {
                transactionEvent.commit();
                toRollback.add(transactionEvent);
            }
            catch (IOException e) {
                try {
                    this.rollback(toRollback);
                    throw new TransactionException("Unable to commit file transaction", e);
                }
                catch (IOException ioe) {
                    throw new TransactionException("Unable to commit file transaction, and rollback failed with error: '" + ioe.getMessage() + "'", e);
                }
            }
        }
    }

    private void rollback(List<TransactionEvent> toRollback) throws IOException {
        for (TransactionEvent event : toRollback) {
            event.rollback();
        }
    }

    public void copyFile(File source, File destination, List<? extends Digester> digesters) {
        this.events.add(new CopyFileEvent(source, destination, digesters));
    }

    public void createFile(String content, File destination, List<? extends Digester> digesters) {
        this.events.add(new CreateFileEvent(content, destination, digesters));
    }
}

